/******************************************************************/
/* INSTALL.CMD Workplace Security installation utility            */
/*                                                                */
/* Workplace Security Copyright (C) 1995 by Maple Valley Software */
/******************************************************************/
  
'@Echo Off'

/* Set the installation variables */

Title = 'Workplace Security'

file.1  = 'README.DOC'         /* Readme instructions       */
file.2  = 'INSTALL.CMD'        /* installation cmd          */
file.3  = 'INSTALL.DOC'        /* installation doc          */
file.4  = 'ORDER.DOC'          /* order form                */
file.5  = 'REGISTER.EXE'       /* registration utility      */
file.6  = 'ACTIVATE.EXE'       /* activation utility        */
file.7  = 'REMOVE.EXE'         /* removal utility           */
file.8  = 'WPSECURE.DOC'       /* WP Security documentation */
file.9  = 'WPSECUG.INF'        /* WP Security User Guide    */
file.10 = 'WPSECURE.HLP'       /* WP Security Help file     */
file.11 = 'WPSECURE.DLL'       /* WP Security Class library */
 
files = 11                    /* total files to install */

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initialize */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

/* get current directory */

Result = SysFileTree('WPSECURE.DLL', 'Dirs', 'O' )
If Dirs.0 = 0 Then Do
  Say 'Change to the directory or diskette drive containing'
  Say 'the Workplace Security files to be installed.' 
  exit
  End
Parse var dirs.1 current_directory '\WPSECURE.DLL' .

Call SysCls
say ' '
say ' '
say ' '
Say 'Installing 'Title '...'
Say ' '

/* Verify that all files are present */

n = 1
do files
Result = SysFileTree( file.n, 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR:' file.n 'not found!'
  Signal DONE
  End
n = n + 1
End


/* Find the drive for the d:\OS2\DLL directory */

Drives = SysDriveMap(C,'LOCAL')
   do words(drives)
      parse var drives drive drives
      directory = drive||'\OS2\DLL'
      Result = SysFileTree(Directory,'Dirs','D')
      If Dirs.0 > 0 Then signal ASKDRIVE
      end

Directory = 'C:\OS2\DLL'

/* Ask for the DLL directory name. */
ASKDRIVE:
Say 'Please enter the drive letter of your'
Say 'OS/2 boot drive. (default' drive ')'
Say ' '
Parse upper pull bootdrive ':' .

if bootdrive = "Q" Then signal DONE
If bootdrive > "" Then drive  = bootdrive||':'


/* Verify the directory exists. */
Result = SysFileTree( drive||"\OS2\DLL", 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Say ' '
  Say 'OS/2 could not be found on drive' drive||':'
  Say ' '
  Signal ASKDRIVE
  End


/* Create the target directory for the other WPSECURE files */

Directory = drive||'\WPSECURE'

/* Ask for the WPSECURE directory name. */
Say ' '
Say 'Please enter the full name of the directory where you'
Say 'want Workplace Security installed (default' Directory '):'
Say 'Press Enter for default or type Q to Quit'
Say ' '
Parse upper pull Direct

if Direct = "Q" Then signal DONE
If Direct > "" Then Directory = Direct

/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory.'
    Signal DONE
    End
  End

Say ''
/* Perform the installation. */

n = 1
do files
If Directory = current_directory Then nop
Else
  Do
  Say 'Copying' file.n ' to ' Directory '...'
  Copy file.n Directory                   '1>NUL'
  n = n + 1
  End
End

/* change to installed directory */
parse var directory drv  ':' direct .
install_drive = drv||":"

install_drive
   
'cd'||direct

Say  "Copying WPSECURE.HLP to  "drive||"\OS2\HELP"
Copy "WPSECURE.HLP" drive||"\OS2\HELP" '1>NUL'
Say  "Copying WPSECURE.DLL to  "drive||"\OS2\DLL" 
Copy "WPSECURE.DLL" drive||"\OS2\DLL"  '1>NUL'

Say ''
Say 'Creating 'Title 'Folder on desktop' 
Result = SysCreateObject( "WPFolder", "Workplace Security", "<WP_DESKTOP>", "OBJECTID=<WP_SECURE>","REPLACE")
if Result = 0  then do
   say 'Error creating 'Title 'Folder'
   exit(1)
   end

Say 'Adding WPS Security program objects to folder...'
Type = 'WPProgram'
Folder = '<WP_SECURE>'
Title = 'Workplace Security Registration'
Parms = "PROGTYPE=PM;EXENAME="Directory"\REGISTER.EXE;STARTUPDIR="Directory";OBJECTID=<Register>;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 0 Then
  Say 'ERROR:' Title ' program object not created.'

Title = 'Workplace Security User Guide'
Parms = "PROGTYPE=PM;EXENAME="Drive"\OS2\VIEW.EXE;STARTUPDIR="Directory";PARAMETERS="Directory||"\WPSECUG.INF;OBJECTID=<UserGuide>"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 0 Then
  Say 'ERROR:' Title ' program object not created.'

Type = 'WPProgram'
Folder = '<WP_SECURE>'
Title =  'Workplace Security order form'
Parms = "EXENAME="drive||"\OS2\APPS\EPM.EXE;PARAMETERS="directory||"\ORDER.DOC;OBJECTID=<Orderform>;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 0 Then
  Say 'ERROR:' Title ' program object not created.'

Say 'Program objects created successfully'

Say 'Activating Workplace Security'
'ACTIVATE'
if rc > 1 then do
  say 'Activate Failed, rc='rc 'See INSTALL.DOC for help'
  exit
  end  /* Do */
say ' '
Say ' '
Say 'Shutdown and Re-boot to enable Workplace Security'
Say ' '
Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
