'WPINI.BAS
'generic module to manage INI files
'by Jonathan Zuck
'First published in PC Magazine, October 11, 1994, US Edition

Option Explicit

DefInt A-Z


Declare Sub WritePrivateProfileString Lib "Kernel" (ByVal Section$, ByVal Entry As Any, ByVal zValue As Any, ByVal IniFile$)
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal Section$, ByVal Entry As Any, ByVal Default As Any, ByVal mzBuff$, ByVal mzBuffLen, ByVal IniFile$) As Integer

Dim mzBuff As String

Sub DeleteEntry (IniFile$, Section$, Entry$)
    WritePrivateProfileString Section$, Entry$, 0&, IniFile$
End Sub

Sub DeleteSection (IniFile$, Section$)
    WritePrivateProfileString Section$, 0&, 0&, IniFile$
End Sub

Function GetEntries (ByVal IniFile$, ByVal Section$, Entry$())
    Dim nChars As Integer
    Dim nEntries As Integer
    Dim nStart As Integer
    Dim nPos As Integer
    Dim nBuffLen As Integer

    'keep making the buffer bigger until it is big enough
    Do
        nBuffLen = nBuffLen + 256
        mzBuff = Space(nBuffLen)
        nChars = GetPrivateProfileString(Section$, 0&, "None", mzBuff, nBuffLen, IniFile$)
        'nChars holds nBuffLen - 2 if buffer too small
    Loop Until nChars <> nBuffLen - 2
    If nChars > 0 Then
        nEntries = 0
        nStart = 1
        nPos = InStr(nStart, mzBuff, Chr$(0))
        While (nPos - nStart) > 1
            nEntries = nEntries + 1
            ReDim Preserve Entry$(nEntries - 1)
            Entry$(nEntries - 1) = Mid(mzBuff, nStart, nPos - nStart)
            nStart = nPos + 1
            nPos = InStr(nStart, mzBuff, Chr$(0))
        Wend
    End If
    GetEntries = nEntries
End Function

Function GetIniLong& (IniFile$, Section$, Entry$, Default&)
    GetIniLong& = Val(GetIniString$(IniFile$, Section$, Entry$, Format$(Default&)))
End Function

Function GetIniString$ (IniFile$, Section$, Entry$, Default$)
    Dim nChars As Integer
    Dim nBuffLen As Integer

    'keep making the buffer bigger until it is big enough
    Do
        nBuffLen = nBuffLen + 256
        mzBuff = Space(nBuffLen)
        nChars = GetPrivateProfileString(Section$, ByVal Entry$, ByVal Default$, mzBuff, nBuffLen, IniFile$)
        'nChars holds nBuffLen - 2 if buffer too small
    Loop Until nChars <> nBuffLen - 2

    If nChars > 0 Then
        GetIniString$ = Left(mzBuff, nChars)
    Else
        GetIniString$ = ""
    End If
End Function

Sub SetIniLong (IniFile$, Section$, Entry$, ByVal Default&)
    SetIniString IniFile$, Section$, Entry$, Format$(Default&)
End Sub

Sub SetIniString (IniFile$, Section$, Entry$, Default$)
    WritePrivateProfileString Section$, Entry$, Default$, IniFile$
End Sub

