Option Explicit

DefInt A-Z

Declare Function GetAsyncKeyState Lib "User" (ByVal VKCODE)


Global Const VK_SHIFT = &H10
Global Const VK_CONTROL = &H11
Global Const VK_MENU = &H12


'Hotkey Definitions
Global giVKCode
Global giVKMask

Global glLColor As Long
Global giLSize

Type APIPOINT
    X As Integer
    Y As Integer
End Type

Declare Sub GetCursorPos Lib "User" (P As APIPOINT)
Declare Sub SetCursorPos Lib "User" (ByVal X, ByVal Y)

'Virtual Key codes
Global Const KEY_LBUTTON = &H1
Global Const KEY_SHIFT = &H10
Global Const KEY_LEFT = &H25
Global Const KEY_UP = &H26
Global Const KEY_RIGHT = &H27
Global Const KEY_DOWN = &H28

Function GetCurrentMask ()
    Dim iMask As Integer

    iMask = 0
    If GetAsyncKeyState(VK_CONTROL) And &H8000 Then iMask = iMask + 2
    If GetAsyncKeyState(VK_SHIFT) And &H8000 Then iMask = iMask + 1
    If GetAsyncKeyState(VK_MENU) And &H8000 Then iMask = iMask + 4
    GetCurrentMask = iMask
End Function

Sub Main ()
    Dim zIniFile As String, zSection As String
    Dim bHotkey As Integer
    Const MODAL = 1

    'First read values from WINPNTR.INI
    zIniFile = "WINPNTR.INI"
    
    zSection = "Hotkey"
    giVKCode = GetIniLong(zIniFile, zSection, "VKCode", Asc("C"))
    giVKMask = GetIniLong(zIniFile, zSection, "VKMask", 2)

    zSection = "Line Draw"
    glLColor = GetIniLong(zIniFile, zSection, "glLColor", 0)
    giLSize = GetIniLong(zIniFile, zSection, "giLSize", 3)

    'Show our main form
    frmMain.Show
    DoEvents

    'This loop runs for life of app
    Do
        'Poll for the bHotkey
        bHotkey = False
        Do
            DoEvents
            If GetAsyncKeyState(giVKCode) Then
                If GetCurrentMask() = giVKMask Then
                    bHotkey = True
                End If
            End If
        Loop Until bHotkey

        'Save the screen and show the form
        Load frmSave
        ScreenCapture frmSave
        frmSave.Show MODAL
        'the line above shows the form to which we have copied the screen
        'if you wanted to create a file from the image instead. Use the
        'following line to replace the one above:
        '         SavePicture frmSave.Image, InputBox("File Name")
        'this line would prompt the user for a file name and save the
        'captured image to disk.
    Loop
End Sub

