/**************************************************************************/
/*                             Vowel Number Utility                       */
/*                                                                        */
/*                                     M\Cooper                           */
/*                                    PO Box 237                          */
/*                            St. David, AZ 85630-0237                    */
/*                        -------------------------------                 */
/*                        Email:  thegrendel@theriver.com                 */
/*                                                                        */
/*                  $2.00 to register the entire WORDY package            */
/*                                                                        */
/**************************************************************************/


#include <conio.h>
#include "srch.h"


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 8
#define CR "\n"
#define FILE_SUFFIX ".5v8"
#define MAXLEN 30
#define FNLEN 40
#define LINE_LEN 80
#define NOARGS 1
#define FILEARGS 2
#define INCREMENT 1
#define SPACE ' '
#define XOUT '@'
#define WILDCARD '?'
#define FILLCHAR '_'
#define BINGO 7
#define BUFFERSIZE 8192

char ad[] =
"VOWEL utility by M\\Cooper, PO Box 237, St. David, AZ 85630-0237";


typedef enum { FALSE, TRUE } Boolean;


void getword( int no_of_vowels, char *sourcefile );
void center( char *strng );
Boolean wordtest( int vn, char *wrd );


void main( int argc, char **argv )
{

   char vowelnum [ MAXLEN ],
        wordfile [ FNLEN ];
   int vn,
       wl;

	 if( argc < FILEARGS )
	    {
	    clrscr();
	    puts("Enter number of vowels ");
	    gets( vowelnum );
     vn = atoi( vowelnum );
	    }
   else
     vn = atoi( *( argv + 1 ) );

      if( argc > FILEARGS )
          strcpy( wordfile, *( argv + 2 ) );
      else
          strcpy( wordfile, "word.lst" );
         

	 getword( vn, wordfile );
}



/**********************************WORDTEST********************************/
/*       Function tests if word contains specified number of vowels       */
/*         Returns: error_flag == TRUE (1) if yes, FALSE (0) if no        */
/**************************************************************************/

Boolean wordtest( int vowelnum, char *word )
{
   char v_lset [] = "aeiou";
   int vowels_counted = 0;

      while( *word )
         {
         if( strchr( v_lset, *word++ ) != NULL )
            vowels_counted++;
         }

      if( vowels_counted == vowelnum )
          return( TRUE );
      else
          return( FALSE );
}

/*************************************************************/
void getword( int vowelnum, char *sourcefile )
{

    char file_name[ MAXLEN ],
         word [ MAXLEN ],
         tempstr [ MAXLEN + 1 ],
         tstr [ MAXLEN ],
         targetfile [ MAXLEN ],
         bar [ LINE_LEN + 1 ],
         double_bar [ LINE_LEN + 1 ],
        *ppos;

   FILE *fptr,
        *tfile;
   int fnamelen,
       i;
   long wcount = 0L;


       strcpy( file_name, "word.lst" );

	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
    printf( CR );   /*****44444*****/
//  printf( " " );  //Pad out line.
	   printf( double_bar );
	   printf( CR );
	   /****************************************/



	   /*   Create name of file to store derived words in   */
	   /*********************************************************/
       sprintf( tstr, "%d", vowelnum );   /***222***/
       strcpy( targetfile, "vowels." );
       strcat( targetfile, tstr );



	   /*********************************************************/


	   if( !( fptr = fopen( sourcefile, "rt" ) ) ) /***ZZZ***/
		 {
		 printf( "\7\7\7Cannot open Wordfile: %s!", file_name );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, 2 * BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR );

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to save words in!" );
		 exit ( FILE_OPENING_ERROR + 2 );
		 }
      if( setvbuf( tfile, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR );

	   /**************'Wait' Message***************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will take a few seconds...\n" );
	   printf( "Please be patient.\n\n" );
	   printf( "Now searching 100,000+ word file and writing file.\n\n" );
	   /********************************************/




      fprintf( tfile, double_bar );
      fprintf( tfile, CR );
      sprintf( tempstr, "Words with %d vowel(s):", vowelnum );
      center( tempstr );
      fprintf( tfile, tempstr );
      fprintf( tfile, CR );     /***03333***/

      fprintf( tfile, double_bar );
      fprintf( tfile, CR );
      fprintf( tfile, CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( wordtest( vowelnum, word )  ) 
			   {
			   fprintf( tfile, "%s", word );
			   wcount++;
			   }
		  /*******************************************/


		  fprintf( tfile, bar );
      fprintf( tfile, CR );
		  sprintf( tempstr, "%ld words in the list have %d vowel(s).",
				 wcount, vowelnum );
		  center( tempstr );		      
		  fprintf( tfile, tempstr );
		  fprintf( tfile, "\n\n" );

		  center( ad );
		  fprintf( tfile, ad );

		  fcloseall();

		  sprintf( tempstr,
				 "The file %s has %ld words with %d vowel(s)\7.",
				 targetfile, wcount, vowelnum );
		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );

}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}
