/**************************************************************************/
/*                               UNSCRAMBLE Utility                       */
/*                                                                        */
/*                                     M\Cooper                           */
/*                                    PO Box 237                          */
/*                            St. David, AZ 85630-0237                    */
/*                        -------------------------------                 */
/*                        Email:  thegrendel@theriver.com                 */
/*                                                                        */
/*                                                                        */
/*                   $2.00 to register the entire WORDY package           */
/*                                                                        */
/**************************************************************************/


/**********************************WORDTEST********************************/
/*       Function tests if word is constructible from Letterset	        */
/*                 Args in: char *letterset, char *word						  */
/*   Returns: error_flag == TRUE (1) if constructible, FALSE (0) if not   */
/**************************************************************************/

#include <conio.h>
#include <ctype.h>
#include "srch.h"


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 40
#define CR "\n"
#define FILE_SUFFIX ".wds"
#define MAXLEN 30
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '
#define XOUT '@'
#define WILDCARD '?'

#define BUFFERSIZE 16384

#define NOPOSITION -1
#define NOLETTER '@'
#define WORDLEN 40
#define XTRALETS 2

typedef enum { FALSE, TRUE } Boolean;
typedef struct { char wd [WORDLEN]; int position; char letter; } Wboundary;


void getword( char *letter_set, size_t w_len, char *filenam, int pos, char c );
void center( char *strng );
Wboundary parse ( char *wordinfo );

/****************************globals****************************************/
char ad[] =
     "UNSCRAMBLE utility by M\\Cooper, PO Box 237, St. David, AZ 85630-0237";
char Lset [MAXLEN];
/**************************************************************************/

void main( int argc, char **argv )
{

   char letterset [MAXLEN],
        filenam [FILENAME_MAXLEN];
   Wboundary Wb;

	 if( argc == NOARGS )
	    {
	    clrscr();
	    puts( "Enter a LETTERSET to test ... " );
	    gets( letterset );
     strcpy( filenam, "word.lst" );
     strcpy( Lset, letterset );
     Wb = parse ( letterset );
     getword( Wb.wd, strlen( Wb.wd ), filenam, Wb.position, Wb. letter );

	    }

  else   
      if( argc == NOARGS + 1 )
         {
         strcpy( filenam, "word.lst" );
         strcpy( letterset, *( argv + 1) );
         strcpy( Lset, letterset );
         Wb = parse ( letterset );
         getword( Wb.wd, strlen( Wb.wd ), filenam, Wb.position, Wb. letter );
         }
	 else
	    {
	    strcpy( letterset, *( argv + 1 ) );
     strcpy( Lset, letterset );
     strcpy( filenam, *( argv + 2 ) );
     Wb = parse ( letterset );
     getword( Wb.wd, strlen( Wb.wd ), filenam, Wb.position, Wb. letter );
	    }
}



Boolean wordtest( char *letterset, char *word )
{
	Boolean error_flag = TRUE;
	static char dup_lset[ MAXLEN ];
	register char *letpos;

	 strcpy( dup_lset, letterset );
		 
		while( *word )
			{
			if( ( letpos  = strchr( dup_lset, *word++ ) ) != NULL )
				*letpos = XOUT;     //As long as letter contained...
/****************Wildcards now allowed***********************/
      else
         if( ( letpos = strchr( dup_lset, WILDCARD ) ) != NULL ) 
            *letpos = XOUT;  //Or wildcard character...

			else
				{ error_flag = FALSE; break; } //test fails (not contained)
			}

		return( error_flag );
}

/*************************************************************/
void getword( char *letter_set, size_t w_len, char *filename, int pos, char c )
{

	char	l_set [ MAXLEN ],
		word [ MAXLEN ],
		tempstr [ MAXLEN + 1 ],
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ],
   ts [ MAXLEN ];

	FILE *fptr;
	long wcount = 0L;

	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
	   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   strcpy ( l_set, letter_set );
	   strcat ( letter_set, CR );


	   if( !( fptr = fopen( filename, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open wordfile %s!", filename );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR );

	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will take a few seconds...\n" );
	   printf( "Please be patient.\n\n" );
	   printf( "Now searching 100,000+ word file for possible solutions...\n\n" );
	   /*****************************************/





	   sprintf( tempstr, "Word(s) unscrambled from: %s\n", strupr( Lset ) );
	   center( tempstr );
	   printf( double_bar );
	   printf( tempstr );
	   printf( double_bar );
	   printf( CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

      if( wordtest( letter_set, word ) )
         if( strlen( word ) == w_len + INCREMENT && ( ( *( word + pos - 1 ) == c ) || pos == NOPOSITION ) )
           {
           printf( "%s", word );
           wcount++;
           }


      if( wcount == INCREMENT )
         strcpy( ts, "word" );
      else
         strcpy( ts, "words" );

		  /*******************************************/

		  printf( bar );
		  sprintf( tempstr, "%ld %s can be unscrambled from %s.",
				 wcount, ts, Lset );
		  center( tempstr );		      
		  printf( tempstr );
		  printf( "\n\n" );

		  center( ad );
		  printf( ad );
      printf( "\7\n\n" );

		  fcloseall();


}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}


Wboundary parse ( char *wordinf )
{
   Wboundary wp;
   char *wptr = wordinf,
         wxtra [ XTRALETS ];

       strcpy( wp.wd, wptr );
       wp.position = NOPOSITION;
       wp.letter = NOLETTER;

       while ( *wordinf )
         {
         if( isdigit ( *wordinf ) )
            {
            wp.position = atoi ( wordinf );
            wp.letter = *( wordinf + 1 );
            *wordinf = NULL;
            strcpy( wp.wd, wptr );
            *wxtra = wp.letter;
            *( wxtra + 1 ) = NULL;
            strcat( wp.wd, wxtra );
            break;
            }
          wordinf++;
          }

      return( wp );
}
