/**************************************************************************/
/*                             Anagram Utility                            */
/*                                                                        */
/*                                 M\Cooper                               */
/*                          3425 Chestnut Ridge Rd.                       */
/*                        Grantsville, MD 21536-9801                      */
/*                        --------------------------                      */
/*                        Email:  thegrendel@aol.com                      */
/*                                                                        */
/*                $2.00 to register the entire WORDY package              */
/*                                                                        */
/**************************************************************************/


#include <conio.h>
#include "srch.h"


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 8
#define CR "\n"
#define FILE_SUFFIX ".wds"
#define MAXLEN 40
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '
#define XOUT '@'
#define WILDCARD '?'
#define FILLCHAR '_'
#define WD 12

#define BUFFERSIZE 8192

   char ad[] =
"ANAGRAM utility by M\\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536-9801";


void getword( char *lset );
void center( char *strng );

typedef enum { FALSE, TRUE } Boolean;

void main( int argc, char **argv )
{

   char letterset[ MAXLEN ];

	 if( argc == NOARGS )
	    {
	    clrscr();
	    puts("Enter a LETTERSET to test ... ");
	    gets( letterset );
	    }
	 else
	    strcpy( letterset, *( argv + 1 ) );

	 getword( letterset );
}


/**********************************WORDTEST********************************/
/*       Function tests if word is constructible from Letterset           */
/*                 Args in: char *letterset, char *word                   */
/*   Returns: error_flag == TRUE (1) if constructible, FALSE (0) if not   */
/**************************************************************************/

Boolean wordtest( char *letterset, char *word )
{
	Boolean error_flag = TRUE;
	static char dup_lset[ MAXLEN ];
	register char *letpos;

//	 dup_lset = strdup( letterset );
	 strcpy( dup_lset, letterset );
		 
		while( *word )
			{
			if( ( letpos  = strchr( dup_lset, *word++ ) ) != NULL )
				*letpos = XOUT;     //As long as letter contained...
      else
         if( ( letpos = strchr( dup_lset, WILDCARD ) ) != NULL ) 
            *letpos = XOUT;  //Or wildcard character...

			else
				{ error_flag = FALSE; break; } //test fails (not contained)
			}

		return( error_flag );
}

/*************************************************************/
void getword( char *letter_set )
{

	char	l_set [ MAXLEN ],
		word [ MAXLEN ],
		tempstr [ MAXLEN + 1 ],
		targetfile [ MAXLEN ],
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ],
  msg [ WD ],
   *ppos;

	FILE *fptr,
		*tfile;
	int fnamelen,
     i;
	long wcount = 0L;

	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
//   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   strcpy ( l_set, letter_set );
	   strcat ( letter_set, CR );

	   /*   Create name of file to store derived words in   */
	   /*********************************************************/
	   fnamelen = strlen( l_set );
	   if( fnamelen  > FILENAME_MAXLEN )
		  fnamelen = FILENAME_MAXLEN;
	   strncpy( targetfile, l_set, fnamelen );
	   *( targetfile + fnamelen ) = NULL;
	   //NULL-terminate string, so strcat works, ha, ha.

      for( i = 0; i < fnamelen; i++ )
         if( *( targetfile + i ) == WILDCARD )
             *( targetfile + i ) = FILLCHAR;


//    if( ( ppos = strchr( targetfile, '?' ) ) != NULL ) 
//          *ppos = '0';
//           strcpy( targetfile, "wildcard" );

//    ppos = targetfile;
//    while( *ppos != NULL )
//       if( *ppos == '?' )
//          {
//          *ppos = FILLCHAR;
//          ppos++;
//          printf( "\7\7\7\7" );  /******DEBUG******/
//          }

	   strcat( targetfile, FILE_SUFFIX );
	   /*********************************************************/

	   if( !( fptr = fopen( Wordfile, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open Wordfile!" );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, BUFFERSIZE * 2 ) )
         exit ( FILE_OPENING_ERROR );  //Extra buffering.

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to save words in!" );
		 exit ( FILE_OPENING_ERROR + 1 );
		 }
      if( setvbuf( tfile, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR );  //Extra buffering.


	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will take a few seconds \n" );
	   printf( "Please be patient...\n\n" );
	   printf( "Now searching 100,000+ word file and writing file of valid anagrams.\n\n" );
	   /*****************************************/





	   sprintf( tempstr, "Words anagrammed from: %s\n", strupr( l_set ) );
	   center( tempstr );
	   fprintf( tfile, double_bar );
      fprintf( tfile, CR );
	   fprintf( tfile, tempstr );
	   fprintf( tfile, double_bar );
	   fprintf( tfile, CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( wordtest( letter_set, word ) )
			   {
			   fprintf( tfile, "%s", word );
			   wcount++;
			   }
		  /*******************************************/

      if( wcount == INCREMENT )
          strcpy( msg, "word" );
      else
          strcpy( msg, "words" );

		  fprintf( tfile, bar );
      fprintf( tfile, CR );
		  sprintf( tempstr, "%ld %s can be anagrammed from %s.",
				 wcount, msg, l_set );
		  center( tempstr );		      
		  fprintf( tfile, tempstr );
		  fprintf( tfile, "\n\n" );

		  center( ad );
		  fprintf( tfile, ad );

		  fcloseall();

		  sprintf( tempstr,
				 "The file %s has %ld %s anagrammed from %s\7.",
				 targetfile, wcount, msg, l_set );
		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );
    printf( CR CR );

}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}
