/**************************************************************************/
/*                             1DIF Utility                               */
/*                                                                        */
/*                For use with 1DIF Scrab**e variant                      */
/*                                                                        */
/*                                 M\Cooper                               */
/*                          3425 Chestnut Ridge Rd.                       */
/*                        Grantsville, MD 21536-9801                      */
/*                        --------------------------                      */
/*                        Email:  thegrendel@aol.com                      */
/*                                                                        */
/*                $2.00 to register the entire WORDY package              */
/*                                                                        */
/**************************************************************************/

#include <conio.h>
#include "srch.h"


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 8
#define CR "\n"
#define FILE_SUFFIX ".1df"
#define MAXLEN 40
#define LINE_LEN 80
#define MAXFILENAMELEN 40
#define NOARGS 1
#define INCREMENT 1
#define SINGLE 1
#define SPACE ' '
#define WILDCARD '?'
#define FILLCHAR '_'

#define BUFFERSIZE 8192

   char ad[] =
"1DIF utility by M\\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536-9801";

typedef enum { FALSE, TRUE } Boolean;

void getword( char *lset, int differences_allowed, char *file_name );
void center( char *strng );
Boolean wordtest( char *letterset, char *word, int differences );

/**************************************************************************/

void main( int argc, char **argv )
{

   char letterset [MAXLEN],
        filename [MAXFILENAMELEN];
   int differences = 1; //Assume one (standard for 1DIF game),
                        // unless specified otherwise.

      if( argc == NOARGS )
         {
         clrscr();
         printf( "Enter a word to 1DIF ... " );
         gets( letterset );
         differences = 1;
         strcpy( filename, Wordfile ); //Std. file
         }
      else
         if( argc == NOARGS + 1 )
           {
           strcpy( letterset, *( argv + 1 ) );
           strcpy( filename, Wordfile ); //Std. file
           differences = 1;
           }
      else
         if( argc == NOARGS + 2 )
           {
           strcpy( letterset, *( argv + 1 ) );
           differences = atoi( *( argv + 2 ) );
           strcpy( filename, Wordfile ); //Std. file
           if( differences >= strlen( letterset ) || differences == 0 )
               differences = 1;
           }
       else
         {
         strcpy( letterset, *( argv + 1 ) );
         differences = atoi( *(argv + 2 ) );
         strcpy( filename, *( argv + 3 ) );  //Specified file name.
         if( differences >= strlen( letterset ) || differences == 0 )
             differences = 1;
         }

       getword( letterset, differences, filename );
}



Boolean wordtest( char *letterset, char *word, int differences )
{
   char *dset;
   register char *letpos;
   register int diff;

      if( strlen( letterset) != strlen( word) )
         return( FALSE );

      dset = letterset;
      diff = 0;

      while( *word && *dset )
         {
         if( *dset == *word || *dset == WILDCARD )
             ;  //As long as letter-match, just advance.
         else
             diff++;

             dset++;
             word++;
          }

      if( diff == differences ) /******DEBUG was <= ********/
          return( TRUE ) ;
      else
          return( FALSE );
}

/*************************************************************/

void getword( char *letter_set, int differences, char *filename )
{

	char	l_set [ MAXLEN ],
		word [ MAXLEN ],
		tempstr [ MAXLEN + 1 ],
		targetfile [ MAXLEN ],
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ],
   msg2 [ MAXLEN ],
   *ppos;

	FILE *fptr,
		*tfile;
	int fnamelen,
     i;
	long wcount = 0L;

	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
    printf( "\n" );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   strcpy ( l_set, letter_set );
	   strcat ( letter_set, CR );

	   /*   Create name of file to store derived words in   */
	   /*********************************************************/
	   fnamelen = strlen( l_set );
	   if( fnamelen  > FILENAME_MAXLEN )
		  fnamelen = FILENAME_MAXLEN;
	   strncpy( targetfile, l_set, fnamelen );
	   *( targetfile + fnamelen ) = NULL;
	   //NULL-terminate string, so strcat works, ha, ha.

      for( i = 0; i < fnamelen; i++ )
         if( *( targetfile + i ) == WILDCARD )
             *( targetfile + i ) = FILLCHAR;

	   strcat( targetfile, FILE_SUFFIX );
	   /*********************************************************/

	   if( !( fptr = fopen( filename, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file %s!\n", filename );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, BUFFERSIZE * 2 ) )
         exit ( FILE_OPENING_ERROR );  //Extra buffering.

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to save words in!" );
		 exit ( FILE_OPENING_ERROR + 1 );
		 }
      if( setvbuf( tfile, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR );  //Extra buffering.


	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will a few seconds...\n" );
	   printf( "Please be patient.\n\n" );
	   printf(
    "Now searching file %s and writing 1DIF file for %s\n\n",
    filename, letter_set ); 

	   /*****************************************/





	   sprintf( tempstr, "Word(s) DIFFed from: %s\n", strupr( l_set ) );
	   center( tempstr );
	   fprintf( tfile, double_bar );
      fprintf( tfile, CR );
	   fprintf( tfile, tempstr );
	   fprintf( tfile, double_bar );
	   fprintf( tfile, CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( wordtest( letter_set, word, differences ) )
			   {
			   fprintf( tfile, "%s", word );
			   wcount++;
			   }
		  /*******************************************/

      if( wcount == SINGLE )
          strcpy( msg2, "word" );
      else
          strcpy( msg2, "words" );

		  fprintf( tfile, bar );
      fprintf( tfile, CR );
		  sprintf( tempstr, "%ld %s can be 1DIFFed from %s.",
				 wcount, msg2, l_set );
		  center( tempstr );		      
		  fprintf( tfile, tempstr );
		  fprintf( tfile, "\n\n" );

		  center( ad );
		  fprintf( tfile, ad );

		  fcloseall();

		  sprintf( tempstr,
				 "The file %s has %ld %s 1DIFFed from %s\7.",
				 targetfile, wcount, msg2, l_set );
		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );
    printf( CR );

}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}
