/**************************************************************************/
/*                             Reformat Utility					    */
/*														    */
/*                                 M\Cooper						    */
/*                        3425 Chestnut Ridge Rd. 					    */
/*                        Grantsville, MD 21536-9801				    */
/*                        --------------------------				    */
/*                        Email:  thegrendel@aol.com				    */
/*                                                                        */
/*                $2.00 to register the entire WORDY package	         */
/*														    */	
/*      Reformats the files created by the pattern matching utilities     */
/*                  so that they print in  columns of 5.                  */
/*                                                                        */
/**************************************************************************/


#include <stdio.h>
#include <conio.h>


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 8
#define CR "\n"
#define MAXLEN 82
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '
#define MAXWORDLEN 20
#define COLUMNS 5

void reformat( char *fname );
void center( char *strg );

char ad[] =
"REFORMAT utility by M\\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536";



typedef enum { FALSE, TRUE } Boolean;

void main( int argc, char **argv )
{

   char filename[ MAXLEN ];

	 if( argc == NOARGS )
	    {
	    clrscr();
	    puts("Enter a FILENAME to reformat... ");
	    gets( filename );
	    }
	 else
	    strcpy( filename, *( argv + 1 ) );

	 reformat( filename );
}




/*************************************************************/
void reformat( char *filename )
{

	char	word [ MAXLEN ],
		tempstr [ MAXLEN + 3 ],
		targetfile [ MAXLEN ],
		tempfilename [ MAXWORDLEN ] = "tmp$$$.$$$",
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ];

	FILE *fptr,
		*tfile;
	long wcount = 1L;

	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
	   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   /*   Create name of temp file to store derived words in  */
	   /*********************************************************/
	   strcpy( targetfile, tempfilename );
	   /*********************************************************/

	   if( !( fptr = fopen( filename, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to reformat!" );
		 exit( FILE_OPENING_ERROR );
		 }

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open temp working file!" );
		 exit ( FILE_OPENING_ERROR + 1 );
		 }

	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "Reformatting file %s.\n", filename );
	   printf( "It may take a few seconds, depending on file length.\n\n" );
	   /*****************************************/


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( strlen( word ) <= MAXWORDLEN )
			   {
			   *( word + strlen( word ) -1 ) = NULL;  //Gets rid of CR

			   fprintf( tfile, "%-15s", word );

			   if( !( wcount % COLUMNS ) && wcount > COLUMNS - 1 )
				  fprintf( tfile, CR );
//			   else
//				  fprintf( tfile, "\t" );

			   wcount++;
			   }
			else
			   fprintf( tfile, "\n%s", word );

		  /*******************************************/

		  fcloseall();

		  remove( filename );
		  rename( targetfile, filename );

		  sprintf( tempstr,
				 "The file %s has been reformatted.", filename );
		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );

}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}
