#include "global.h"
#include "config.h"
#include "mbuf.h"
#include "netuser.h"
#include "socket.h"
#include "usock.h"
#include "ax25.h"
#include "tcp.h"
#include "nr4.h"

/* Convert a socket (address + port) to an ascii string of the form
 * aaa.aaa.aaa.aaa:ppppp
 */
char *
psocket(void *p)		/* Pointer to structure to decode */
{
#if	defined(AX25) || defined(NETROM)
	char tmp[AXBUF];
#endif
	static char buf[30];
	union sp sp;

	sp.p = p;

	switch(sp.sa->sa_family) {
/*
	case AF_LOCAL:
		break;
*/
	case AF_INET: {
		struct socket sock;
		sock.address = sp.in->sin_addr.s_addr;
		sock.port = sp.in->sin_port;
		return pinet(&sock);
	  }
#ifdef	AX25
	case AF_AX25:
		sprintf(buf,"%s on %s",
			pax25(tmp,sp.ax->ax25_addr),
			*sp.ax->iface ? sp.ax->iface : "???");
		break;
#endif
#ifdef	NETROM
	case AF_NETROM:
		sprintf(buf,"%s @ ",pax25(tmp,sp.nr->nr_addr.user));
		strcat(buf,pax25(tmp,sp.nr->nr_addr.node));
		break;
#endif
	}
	return buf;
}

/* Return ASCII string giving reason for connection closing */
char *
sockerr(int s)		/* Socket index */
{
	struct usock *up;

	if((up = itop(s)) == NULLUSOCK){
		return Badsocket;
	}
	switch(up->type){
	case TYPE_TCP:
		if(up->cb.tcb != NULLTCB)
			return NULLCHAR;						/* nothing wrong */
		return Tcpreasons[up->errcodes[0]];
#ifdef	AX25
	case TYPE_AX25I:
		if(up->cb.ax25 != NULLAX25)
			return NULLCHAR;						/* nothing wrong */
		return Ax25reasons[up->errcodes[0]];
#endif
#ifdef	NETROM
	case TYPE_NETROML4:
		if(up->cb.nr4 != NULLNR4CB)
			return NULLCHAR;						/* nothing wrong */
		return Nr4reasons[up->errcodes[0]];
#endif
	default:
		errno = EOPNOTSUPP;							/* not yet, anyway */
		return NULLCHAR;
	}
}

/* Get state of protocol. Valid only for connection-oriented sockets. */
char *
sockstate(int s)		/* Socket index */
{
	struct usock *up;

	if((up = itop(s)) == NULLUSOCK){
		return NULLCHAR;
	}
	if(up->cb.p == NULLCHAR){
		errno = ENOTCONN;
		return NULLCHAR;
	}
	switch(up->type){
	case TYPE_TCP:
		return Tcpstates[up->cb.tcb->state];
#ifdef	AX25
	case TYPE_AX25I:
		return Ax25states[up->cb.ax25->state];
#endif
#ifdef	NETROM
	case TYPE_NETROML4:
		return Nr4states[up->cb.nr4->state];
#endif
	default:
		/* Datagram sockets don't have state */
		errno = EOPNOTSUPP;
		return NULLCHAR;
	}
}

