#ifndef	_SLIP_H
#define _SLIP_H

#ifndef _GLOBAL_H
#include "global.h"
#endif

#define SLIP_MAX 		5		/* Maximum number of slip channels */

/* SLIP definitions */
#define	FR_END			0300	/* Frame End */
#define	FR_ESC			0333	/* Frame Escape */
#define	T_FR_END		0334	/* Transposed frame end */
#define	T_FR_ESC		0335	/* Transposed frame escape */

/* Slip protocol control structure */
struct slip {
	struct iface *iface;
	char escaped;				/* Receiver State control flag */
#define	SLIP_FLAG		0x01
#define	SLIP_VJCOMPR	0x02
	struct mbuf *rbp;			/* Head of mbuf chain being filled */
	struct mbuf *rbp1;			/* Pointer to mbuf currently being written */
	char *rcp;					/* Write pointer */
	int16 rcnt;					/* Length of mbuf chain */
	struct mbuf *tbp;			/* Transmit mbuf being sent */
	int16 errors;				/* Receiver input errors */
	int type;					/* Protocol of input */
	int (*send)(int,struct mbuf *);	/* Routine to send mbufs */
	int (*get)(int);			/* Routine to fetch input chars */
	struct iface *kiss[16];		/* multiport kiss AX25 only - G1EMM */
};

extern struct slip Slip[];

/* In slip.c: */
void asy_rx __ARGS((int dev,void *p1,void *p2));
int slip_raw __ARGS((struct iface *iface,struct mbuf *data));
int slip_send __ARGS((struct mbuf *bp,struct iface *iface,int32 gateway,int prec,int del,int tput,int rel));

#endif	/* SLIP_ALLOC */
