#include <stdio.h>
#include "global.h"
#include "config.h"
#ifdef NETROM
#include "mbuf.h"
#include "netrom.h"
#include "nr4.h"
#include "trace.h"

/* Display NET/ROM network and transport headers */
void
netrom_dump(FILE *fp,struct mbuf **bpp,int check)
{
	char src[AXALEN], dest[AXALEN], tmp[AXBUF], tmp1[AXBUF], thdr[NR4MINHDR];
	char space[] = "         ";
	int i;

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;
	/* See if it is a routing broadcast */
	if(uchar(*(*bpp)->data) == NR3NODESIG) {
		(void)PULLCHAR(bpp);		/* Signature */
		pullup(bpp,tmp,ALEN);
		tmp[ALEN] = '\0';
		trprintf(fp,"NET/ROM Routing: %s\n",tmp);
		for(i = 0;i < NRDESTPERPACK;i++) {
			if (pullup(bpp,src,AXALEN) < AXALEN)
				break;
			trprintf(fp,"%20s",pax25(tmp,src));
			pullup(bpp,tmp,ALEN);
			tmp[ALEN] = '\0';
			trprintf(fp,"%8s",tmp);
			pullup(bpp,src,AXALEN);
			trprintf(fp,"%16s",pax25(tmp,src));
			tmp[0] = PULLCHAR(bpp);
			trprintf(fp,"%7u\n",uchar(tmp[0]));
		}
		return;
	}
	/* Decode network layer */
	pullup(bpp,src,AXALEN);
	pullup(bpp,dest,AXALEN);
	i = PULLCHAR(bpp);

	trprintf(fp,"NET/ROM: %s->%s ttl %d\n",
		pax25(tmp,src),pax25(tmp1,dest),i);

	/* Read first five bytes of "transport" header */
	pullup(bpp,thdr,NR4MINHDR);
	switch(thdr[4] & NR4OPCODE){
 	case NR4OPPID:	/* network PID extension */
		if (thdr[0] == NRPROTO_IP && thdr[1] == NRPROTO_IP) {
 			ip_dump(fp,bpp,check) ;
			return;
		}
 		else
			trprintf(fp,"%sprotocol family %x, proto %x",
				space,uchar(thdr[0]),uchar(thdr[1])) ;
 		break ;
	case NR4OPCONRQ:	/* Connect request */
		i = PULLCHAR(bpp);
		pullup(bpp,src,AXALEN);
		pullup(bpp,dest,AXALEN);
		trprintf(fp,"%sconn rqst: ckt %d/%d wnd %d %s@%s",
			space,
			uchar(thdr[0]), uchar(thdr[1]),i,
			pax25(tmp,src),pax25(tmp1,dest));
		break;
	case NR4OPCONAK:	/* Connect acknowledgement */
		i = PULLCHAR(bpp);
		trprintf(fp,"%sconn ack: ur ckt %d/%d my ckt %d/%d wnd %d",
			space,
			uchar(thdr[0]), uchar(thdr[1]),
			uchar(thdr[2]), uchar(thdr[3]), i);
		break;
	case NR4OPDISRQ:	/* Disconnect request */
		trprintf(fp,"%sdisc: ckt %d/%d",
			space,
			uchar(thdr[0]),uchar(thdr[1]));
		break;
	case NR4OPDISAK:	/* Disconnect acknowledgement */
		trprintf(fp,"%sdisc ack: ckt %d/%d",
			space,
			uchar(thdr[0]),uchar(thdr[1]));
		break;
	case NR4OPINFO:	/* Information (data) */
		trprintf(fp,"%sinfo: ckt %d/%d txseq %d rxseq %d",
			space,
			uchar(thdr[0]), uchar(thdr[1]),
			uchar(thdr[2]), uchar(thdr[3]));
		break;
	case NR4OPACK:	/* Information acknowledgement */
		trprintf(fp,"%sinfo ack: ckt %d/%d txseq %d rxseq %d",
			space,
			uchar(thdr[0]),uchar(thdr[1]),
			uchar(thdr[2]), uchar(thdr[3]));
		break;
	default:
		trprintf(fp,"%sunknown transport type %d",space,thdr[4] & 0x0f) ;
		break;
	}
	if(thdr[4] & NR4CHOKE)
		trprintf(fp," CHOKE");
	if(thdr[4] & NR4NAK)
		trprintf(fp," NAK");
	if(thdr[4] & NR4MORE)
		trprintf(fp," MORE");
	trprintf(fp,"\n");
}

#endif /* NETROM */