#include <stdio.h>
#include <string.h>
#include "global.h"
#include "mbuf.h"
#include "socket.h"
#include "session.h"
#include "proc.h"
#include "netuser.h"
#include "commands.h"
#include "tty.h"

int
dofinger(int argc,char **argv,void *p)
{
	struct sockaddr_in sock;
	char *cp;
	int i;
	struct mbuf *bp;
	struct session *sp;

	/* Allocate a session descriptor */
	if((sp = newsession(argv[1],FINGER,SWAP)) == NULLSESSION){
		tputs(Nosess);
		return 1;
	}
	sp->ttystate.echo = sp->ttystate.edit = 0;
	sp->flowmode = Cooked;
	sock.sin_family = AF_INET;
	sock.sin_port = IPPORT_FINGER;

	for(i = 1; i < argc; i++) {
		if((cp = strchr(argv[i],'@')) == NULLCHAR) {
			tprintf("%s: local names not supported\n",argv[i]);
			continue;
		}
		*cp++ = '\0';

		tprintf("%s@%s -- Resolving %s... ",argv[i],cp,cp);

		if((sock.sin_addr.s_addr = resolve(cp)) == 0){
			tprintf(Badhost,cp);
			continue;
		}
		if((sp->s = socket(AF_INET,SOCK_STREAM,0)) == -1){
			tputs(Nosocket);
			break;
		}
		sockmode(sp->s,SOCK_ASCII);
		tprintf("Trying %s...",psocket((struct sockaddr *)&sock));

		if(connect(sp->s,(char *)&sock,SOCKSIZE) != -1) {
			tputs("\n");
			usprintf(sp->s,"%s\n",argv[i]);
			usflush(Curproc->output);
			while(recv_mbuf(sp->s,&bp,0,NULLCHAR,0) > 0) {
				send_mbuf(Curproc->output,bp,0,NULLCHAR,0);
			}
		}
	}
	keywait(NULLCHAR,1);
	freesession(sp);
	return 0;
}
