/* Definitions of various files, spool directories, etc
 * especially for a PC (under MS-DOS/DR-DOS)
 */
#include <io.h>
#include <fcntl.h>
#include "global.h"
#include "config.h"
#include "files.h"
#include "socket.h"

char *EtcRoot		= "/etc";
char *SpoolRoot		= "/spool";					/* spool 'root' */

char *BBSwrkdir		= "/bbs";
char *Alias 		= "/alias";					/* the alias file */
char *Dfile 		= "/domain.txt";			/* Domain cache */
char *Fdir 			= "/finger";				/* Finger info directory */

char *Startup 		= "/wnos.rc";				/* Initialization file */
char *Ftpdir  		= "/public/upload";			/* */

char *Mailqdir 		= "/mqueue";				/* Outgoing mail spool */
char *Mailspool 	= "/mail";					/* Incoming mail */
char *Routeqdir 	= "/rqueue";				/* queue for router */
char *Rewritefile 	= "/rewrite";				/* Address rewrite file */
char *Signature 	= "/signatur";				/* Mail signature file directory */
char *News    		= "/news";		  			/* Top of NeWs file system */
char *Active  		= "/active";				/* Active article file */
char *Pointer 		= "/pointer";
/* char *NInfo         = "/xinfo";  */
char *Nhelp   		= "/help";
char *History 		= "/history";
char *Forward 		= "/junk";
char *Poll    		= "/poll";

char *Axroutefile 	= "/axroute.dat";			/* AX25 routes */
char *Arproutefile	= "/arproute.dat";			/* ARP entries */
char *Iproutefile 	= "/iproute.dat";   		/* IP route entries */
#ifdef NETROM
char *Nrroutefile 	= "/nrroute.dat";			/* NET/ROM routes */
#endif

char Eol[] = "\r\n";
#define	SEPARATOR	"/"

static char roott[MAXPATH];

/* Concatenate root, separator and arg strings into a malloc'ed output
 * buffer, then remove repeated occurrences of the separator char
 */
static char * near
strcatdup(char *a,char *b)
{
	int index = 0;

	char *p1, *p2, *cp, *r,
	  *out = mxalloc(strlen(roott) + strlen(SEPARATOR) + strlen(a) + strlen(b) + 2);

	while((cp = strchr(a,'\\')) != NULLCHAR) {
		*cp = '/';
	}
	if(b != "") {
		sprintf(out,"%s%s",b,a);
	} else {
		sprintf(out,"%s%s%s",roott,SEPARATOR,a);
	}
	/* Remove any repeated occurrences of the separator char */
	if(out[1] == ':') {
		index = 2;
	}
	p1 = p2 = &out[index];
	r = &roott[index];

	while(*p2 != '\0') {
		*p1++ = *p2++;
		while(*p2 == p2[-1] && *p2 == *r) {
			p2++;
		}
	}
	*p1 = '\0';

	return out;
}

/* Establish a root directory other than the default. Can only be called
 * once, at startup time
 */
void
initroot(char *root)
{
	strcpy(roott,(root != NULLCHAR) ? root : "");

	EtcRoot = strcatdup(EtcRoot,"");			/* must be the first! */
	SpoolRoot = strcatdup(SpoolRoot,"");		/* must be the second! */

    BBSwrkdir = strcatdup(BBSwrkdir,"");
    Alias = strcatdup(Alias,EtcRoot);
    Dfile = strcatdup(Dfile,EtcRoot);
	Fdir = strcatdup(Fdir,"");

	Startup = strcatdup(Startup,EtcRoot);
    Ftpdir = strcatdup(Ftpdir,"");

	Mailqdir = strcatdup(Mailqdir,SpoolRoot);
	Mailspool = strcatdup(Mailspool,SpoolRoot);
	Routeqdir = strcatdup(Routeqdir,SpoolRoot);
	Rewritefile = strcatdup(Rewritefile,SpoolRoot);
	Signature = strcatdup(Signature,SpoolRoot);

	News = strcatdup(News,SpoolRoot);
	Active = strcatdup(Active,News);
	Pointer = strcatdup(Pointer,News);
/*    NInfo = strcatdup(NInfo,News); */
	Nhelp = strcatdup(Nhelp,News);
	History = strcatdup(History,News);
	Forward = strcatdup(Forward,News);
	Poll = strcatdup(Poll,News);

	Axroutefile = strcatdup(Axroutefile,EtcRoot);
	Arproutefile = strcatdup(Arproutefile,EtcRoot);
	Iproutefile = strcatdup(Iproutefile,EtcRoot);
#ifdef NETROM
	Nrroutefile = strcatdup(Nrroutefile,EtcRoot);
#endif
}

unsigned int _tmpnum = 0;

/*----------------------------------------------------------------------*
 * low-level routine used by tmpnam, fixed to use TEMP env. variable    *
 *----------------------------------------------------------------------*/
static char *pascal
__nmkname(char *tmpname,unsigned tmpnum)
{
	char *tmpdir, *p;
	static char staticname[MAXPATH];

	if(tmpname == NULL) {
		tmpname = staticname;
	}
	if((p = getenv("TEMP")) == NULL) {			/* get tempdir name */
		p = "";
	}
	tmpdir = p;

	if(*p != '\0') {
		p += strlen(p) - 1;					/* point to last character */
	}
	sprintf(tmpname,"%s%sTMP%u.TMP",
		tmpdir,
		(*p != '/' && *p != '\\') ? "\\" : "",
		tmpnum);

	return tmpname;
}

/*-----------------------------------------------------------------------*
 * new tmpnam function.                                                  *
 * calls above routine to generate the name, but                         *
 * is otherwise the same as the tmpnam() in the library.                 *
 *-----------------------------------------------------------------------*/
char *
__tmpnam (char *name,int num)
{
	if(num == 0) {
		do {
			if(_tmpnum == 0xffff) {
				_tmpnum = 2;
			} else {
				++_tmpnum;
			}
			name = __nmkname(name,_tmpnum);
		} while(access(name,0) != -1);
	} else {
	  name = __nmkname(name,num);
	}
	return name;
}

/*-----------------------------------------------------------------------*
 * tmpfile() to circumvent the FIXUP Overflow error of the Turbo C++     *
 * linker.                               DK5DC                           *
 *-----------------------------------------------------------------------*/
FILE *
Tmpfile(int s,int t)
{
	char maxname[MAXPATH];
	FILE *fp;

	__tmpnam(maxname,0);                    /* make the name             */

	fp = Fopen(maxname,"w+b",s,t);        /* return FILE *               */
	fp->istemp = _tmpnum;

	return fp;
}

int
Fclose(FILE *fp)
{
	if(fp->istemp) {
		char maxname[MAXPATH];
		int ret;

		__tmpnam(maxname,fp->istemp);
		fp->istemp = 0;
		ret = fclose(fp);
		unlink(maxname);
		return(ret);
	}
	return(fclose(fp));
}

/* main file-opening routine
 * options: s = socketnumber, if given an error msg is printed to the socket
 * returncode: NULLFILE if error; filepointer success
 */
FILE *
Fopen(char *name,char *mode,int s,int t)
{
	FILE *fp = NULLFILE;

	if(name == NULLCHAR || mode == NULLCHAR || chkbaddoschars(name)) {
		goto err;
	}
	if((fp = fopen(name,mode)) == NULLFILE) {
		if(s) {
			usprintf(s,"503 Fatal error FILE %s\n",name);
		}
		if(t) {
err:
			tprintf("Can't open %s: %s\n",name,sys_errlist[errno]);
		}
	}
	return fp;
}

/* create lockfile */
int
mlock(char *dir,char *id)
{
	int fd;
	char lockname[MAXPATH];

	sprintf(lockname,"%s/%s.lck",dir,id);

	if((fd = open(lockname,O_WRONLY|O_EXCL|O_CREAT,0600)) == -1) {
		return -1;
	}
	close(fd);
	return 0;
}

/* remove lockfile */
int
rmlock(char *dir,char *id)
{
	char lockname[MAXPATH];

	sprintf(lockname,"%s/%s.lck",dir,id);

	return(unlink(lockname));
}

int
chkbaddoschars(char *name)
{
	char *cp;
	static char badchars[] = "\"[]|<>+=;,?!";

	while((cp = strchr(name,'\\')) != NULLCHAR) {
		*cp = '/';
	}
	/* Check for characters illegal in MS-DOS file names */
	for(cp = badchars; *cp != '\0'; cp++) {
		if(strchr(name,*cp) != NULLCHAR) {
			/* wrong char in filename */
			return 1;
		}
	}
	return 0;
}
