#ifndef _CONFIG_H
#define _CONFIG_H

/* Software options */
#define SERVERS         1               /* general include of ALL (!!) servers */
#define MAILBOX         1               /* Include SM0RGV mailbox server */
#define TRACE           1               /* Include packet tracing code */
#undef  POP             1               /* POP protocol */
#undef  NNTP            1               /* Include NNTP Network News Protocol */
#undef  CONVERS         1               /* conversd implementation - DB3FL */
#undef  LINK            1               /* enables conversd links - DB3FL */
#define AXIP            1               /* AX25/IP encapsulation */
#undef	LZW             1               /* LZW compression */
#define UDP             1               /* UDP protocol implementation - G6DHU */
#define DNS             1               /* Domain/Name server */
#define ENH             1               /* enables enhanced DOMAIN options */
#define DAMA_S          1               /* DAMA slave code - DL1BKE */
#define MODEM           1               /* support for Modems on slip lines */

/* Hardware config */
#define NSESSIONS       8       /* Number of interactive clients */
#define DEFNSOCK        60              /* Default number of sockets */
#define MTHRESH         12288   /* Default memory threshold */
#define NROWS           25              /* Number of rows on screen */
#define NCOLS           80              /* Number of cols on screen */
#define NIBUFS          7               /* Number of interrupt buffers */
#define IBUFSIZE        2048    /* Size of interrupt buffers */
#define ESCAPE          1               /* Allow Unix style escape on PC */

/* Hardware configuration */
#define ARCNET          1       /* ARCnet via PACKET driver */
#undef  PC_EC           1               /* 3-Com 3C501 Ethernet controller */
#define SLIP            1               /* Serial line IP */
#define KISS            1               /* KISS TNC code */
#undef  HS              1               /* High speed (56kbps) modem driver */
#undef  HAPN            1               /* Hamilton Area Packet Network driver code */
#undef  EAGLE           1               /* Eagle card driver */
#define PACKET          1       /* FTP Software's Packet Driver interface */
#undef  PC100           1               /* PAC-COM PC-100 driver code */
#undef  NRS             1               /* NET/ROM async interface */
#undef  NETROM          1       /* NET/ROM network support */
#define DRSI            1               /* DRSI PCPA slow-speed driver */
#define SCC             1       /* PE1CHL generic scc driver */
#define ASY             1               /* Asynch driver code */
#undef  SLFP            1               /* SLFP packet driver class supported */
#undef  VANESSA         1       /* Vanessa Board (HB9RWM) */

#if defined(NRS)
#undef  NETROM
#define NETROM          1               /* NRS implies NETROM */
#endif

#if (defined(HS)||defined(NETROM)||defined(KISS)||defined(HAPN)||defined(EAGLE)||defined(PC100)||defined(AXIP))
#undef  AX25
#define AX25            1               /* AX.25 subnet code */
#endif

#if (defined(ARCNET) || defined(SLFP))
#undef  PACKET
#define PACKET          1               /* FTP Software's Packet Driver interface */
#endif

#if (defined(PC_EC) || defined(PACKET))
#undef  ETHER
#define ETHER           1               /* Generic Ethernet code */
#endif

#if defined(ENH)
#undef  DNS
#define DNS                     1               /* Enhanced DOMAIN options requires DNS */
#endif

#if defined(DNS)
#undef  UDP
#define UDP                     1               /* Domain Server requires UDP */
#endif

#endif  /* _CONFIG_H */

