#include <stdio.h>
#include "global.h"
#include "config.h"
#include "socket.h"
#include "session.h"
#include "commands.h"
#include "remote.h"
#include "tcp.h"			/* for kick() */
#include "files.h"
#include "dirutil.h"
#include "clients.h"
#include "ftp.h"
#include "smtp.h"

#ifdef DNS
#include "domain.h"
#endif

#ifdef LZW
#include "lzw.h"
#endif

#ifdef CONVERS
#include "convers.h"
#endif

#ifdef POP
#include "pop.h"
#endif

#ifdef NNTP
#include "nntp.h"
#endif

static int CLoginwait = 0;
struct Server *Server = NULLSERVER;


/* Attempt to log in the remote system, which is specified by 'host' */
int16
cli_login(int16 protocol,void *ccb)
{
  FILE *fp;
  char cp[LINELEN];
  int16 perms = 1;

  semwait(&CLoginwait,1);

  sprintf(cp,"%s/%s.cfg",EtcRoot,tcp_port(protocol));

  if((fp = Fopen(cp,READ_TEXT,0,1)) != NULLFILE) {
	int def = FALSE;
	char *def_arg2 = NULLCHAR, *def_arg3 = NULLCHAR, *def_arg4 = NULLCHAR;
	char arg1[40], arg2[40], arg3[40], arg4[40];

	for( ; ;) {
	  memset(cp,0,LINELEN);

	  fgets(cp,LINELEN,fp);

	  /* Comment line */
	  if(*cp == '#') {
		continue;
	  }
	  *arg1 = '\0';
	  *arg2 = '\0';
	  *arg3 = '\0';
	  *arg4 = '\0';

	  /* there must be at least 3 arguments ... */
	  sscanf(cp,"%s %s %s %s",arg1,arg2,arg3,arg4);

	  if(strcmp(arg1,"default") == 0) {
		if(def_arg2) xfree(def_arg2);
		if(def_arg3) xfree(def_arg3);
		if(def_arg4) xfree(def_arg4);
		if(arg2) def_arg2 = strxdup(arg2);
		if(arg3) def_arg3 = strxdup(arg3);
		if(arg4) def_arg4 = strxdup(arg4);
		def = TRUE;
	  } else {
		switch(protocol) {
		  case IPPORT_FTP: {
			struct ftpcli *ftp = ccb;

			if(strcmp(arg1,ftp->buf) == 0) {
			  ftp->username = strxdup(arg2);
			  ftp->password = strxdup(arg3);
			  goto found;
			}
			if(feof(fp)) {
			  if(def == TRUE) {
				ftp->username = strxdup(def_arg2);
				ftp->password = strxdup(def_arg3);
				goto found;
			  }
			  perms = 0;
			  goto found;
			}
			break;
		  }
#ifdef POP
		  case IPPORT_POP: {
			struct Server *pop = ccb;

			if(strcmp(arg1,pop->name) == 0) {
				pop->arg1 = strxdup(arg2);
				pop->arg2 = strxdup(arg3);
				pop->arg3 = strxdup(arg4);
				goto found;
			}
			if(feof(fp)) {
			  if(def == TRUE) {
				pop->arg1 = strxdup(def_arg2);
				pop->arg2 = strxdup(def_arg3);
				pop->arg3 = strxdup(def_arg4);
				goto found;
			  }
			  perms = 0;
			  goto found;
			}
			break;
		  }
#endif
#ifdef notusedyet
		  case IPPORT_TTYLINK:
		  case IPPORT_TELNET: {
			struct telnet *telcli = ccb;

			if(stricmp(arg1,telcli->username) == 0) {
			  telcli->username = strxdup(arg2);
			  telcli->password = strxdup(arg3);
			  goto found;
			}
			if(feof(fp)) {
			  if(def == TRUE) {
				telcli->username = strxdup(def_arg2);
				telcli->password = strxdup(def_arg3);
				goto found;
			  }
			  perms = 0;
			  goto found;
			}
			break;
		  }
#endif
#ifdef CONVERS
		  case IPPORT_XCONVERS:
		  case IPPORT_CONVERS:
#endif
		  case IPPORT_ECHO:
		  case IPPORT_DISCARD:
		  case IPPORT_SMTP:
		  case IPPORT_FINGER:
#ifdef DNS
		  case IPPORT_DOMAIN:
#endif
#ifdef UDP
		  case IPPORT_REMOTE:
#endif
#ifdef NNTP
		  case IPPORT_NNTP:
#endif
		  {
			goto found;
		  }
		}
		if(feof(fp)) {
		  perms = 0;
		  goto found;
		}
	  }
	}
found:
	Fclose(fp);

	if(def_arg2) xfree(def_arg2);
	if(def_arg3) xfree(def_arg3);
	if(def_arg4) xfree(def_arg4);
  }
  semrel(&CLoginwait);

  /* Finally return the permission flag */
  return perms;
}


struct Server *
addserver(int16 protocol,char *host)
{
	struct Server *np = NULLSERVER;
	int32 addr;

	if((addr = resolve(host)) == 0) {
		tprintf(Badhost,host);
	} else {
		for(np = Server; np != NULLSERVER; np = np->next) {
			if(np->address == addr && np->protocol == protocol) {
				return np;
			}
		}
		if(np == NULLSERVER) {
			np = mxallocw(sizeof(struct Server));
			np->name = strxdup(host);
			np->address = addr;
			np->busy = FALSE;
			np->protocol = protocol;

			np->next = Server;
			Server = np;
		}
	}
	return np;
}

struct Server *
dropserver(int16 protocol,char *host)
{
	struct Server *np, *npprev = NULLSERVER;
	int32 addr;

	if((addr = resolve(host)) == 0) {
		tprintf(Badhost,host);
	} else {
		for(np = Server; np != NULLSERVER; npprev = np, np = np->next) {
			if(np->address == addr && np->protocol == protocol) {
				if(np->busy) {
					tprintf("Entry for %s is active\n",inet_ntoa(np->address));
					return NULLSERVER;
				}
				if(npprev != NULLSERVER) {
					npprev->next = np->next;
				} else {
					Server = np->next;
				}
				xfree(np->name);
				if(np->arg1) xfree(np->arg1);
				if(np->arg2) xfree(np->arg2);
				if(np->arg3) xfree(np->arg3);
				if(np->arg4) xfree(np->arg4);
				xfree(np);
			}
		}
	}
	return NULLSERVER;
}

void
listserver(int16 protocol,char *host,char *title)
{
	struct Server *np;

	tprintf("Address          Status   %s\n",(*host == 'x') ? "" : title);

	for(np = Server; np != NULLSERVER; np = np->next) {
		if(*host == 'x' || np->protocol == protocol) {
			tprintf("%-17s%-9s",
			  inet_ntoa(np->address),
			  np->busy ? "Busy" : "Idle");
			switch(protocol) {
			case IPPORT_POP:
				tprintf("%-10s%s",
					np->arg1 ? np->arg1 : "",
					np->arg2 ? np->arg2 : "");
				break;
			case IPPORT_NNTP:
				tputs(np->arg1);
				break;
			}
			tputs("\n");
		}
	}
	return;
}
