/* @(#) $Header: bbs.h,v WNOS_1.2 92/11/06 12:04:13 deyke Exp $ */
#ifndef _BBS_H
#define _BBS_H

#ifndef _GLOBAL_H
#include "global.h"
#endif

#define LEN_BID         13
#define LEN_SUBJECT     50
#define LEN				40

#define NORMAL		0
#define DELETED		1
#define PRIVATE		2
#define NEWS		4
#define BULLETIN	8

struct userinfo {
  char name[30];				/* name of user */
  char mybbs[30]; 				/* home mailbox */
  int32 time;					/* last time logged in */
  int32 seq;					/* last msg listed */
};

struct user {
  struct userinfo *info;
  int s;						/* socket index */
  char *name;                   /* login name of user */
  char errors;					/* error count */
  char level;					/* user level */
#define USER        	0
#define BOX        		1
#define ROOT        	2
#define CLOSED			4
  int sid;                      /* System IDentifier for forward */
#define	MBX_SID		  	0x01	/* Got any SID */
#define	MBX_RLI_SID	  	0x02	/* This is an RLI BBS, disconnect after F> */
#define MBX_HIER_SID  	0x04	/* The BBS supports "hierarchical routing */
								/* designators." */
#define MBX_MID_SID	  	0x08	/* The BBS supports Message IDs on P mail */
								/* Space here for others, currently not of */
								/* interest to us. */
  char *line;					/* input line pointer */
};
#define NULLUSER (struct user *)0

struct index {
  int32 size;
  int32 date;
  int32 mesg;
  char lifetime_h;
  char lifetime_l;
  char flag;
  char bid[LEN_BID];
  char subject[LEN_SUBJECT];
  char to[LEN];
  char at[LEN];
  char from[LEN];
  char from_at[LEN];
};

struct strlist {
  struct strlist *next;
  char *str;
};

struct mail {
  char from[LEN];
  char from_at[LEN];
  char to[LEN+LEN];
  char subject[LEN_SUBJECT];
  char bid[LEN_BID];
  char mid[LEN_BID+10];
  char newsgroup[LINELEN];
  char flag;
  int32 date;
  int lifetime;
  struct strlist *head;
  struct strlist *tail;
};

struct dir_entry {
  struct dir_entry *left, *right;
  int count;
  char to[LEN];
};

int dombbs __ARGS((int argc,char **argv,void *p));
int recv_from_mail_or_news __ARGS((FILE *data,char *from, char *to));

/* used for ax25 store&forward */
int dofnic __ARGS((int argc,char **argv,void *p));
int dofinfo __ARGS((int argc,char **argv,void *p));
int dofkick __ARGS((int argc,char **argv,void *p));

#endif /* _BBS_H */
