
#include <afxwin.h>
#include <afxcoll.h>
#include <iostream.h>
#include <strstrea.h>

#include <stdio.h>
#include <string.h>

#include "wmlookup.h"


////////////////////////////////////////
//
// Serializable Message Structure
//

IMPLEMENT_SERIAL(CMessages, CObject, 0) 


void CMessages::Serialize( CArchive& archive)
{
	CObject::Serialize( archive ) ;
	
	if (archive.IsStoring() )
	{
		archive << messageText ;
	}
	else
	{
		archive >> messageText ;
	}
}
////////////////////////////////////////
//
// Dialog Code
//

BEGIN_MESSAGE_MAP(CDlgLookUp, CDialog)
	ON_WM_CLOSE()
	ON_COMMAND(IDOK,OnOK) 
	ON_COMMAND(IDCANCEL, OnCancel) 
END_MESSAGE_MAP()

BOOL CDlgLookUp::bRegistered = FALSE ;

CDlgLookUp::CDlgLookUp()
{
	pMap = NULL ;
	
	if (!bRegistered)
	{
	 bRegistered = RegisterMyClass() ;	
	}
	
	Create(MAKEINTRESOURCE(100)) ;
} 

CDlgLookUp::~CDlgLookUp()
{
	delete pMap ;
}

BOOL CDlgLookUp::RegisterMyClass() {
	WNDCLASS wndclass;
	 
	wndclass.style          = 0;
			  
	// Let's use DefDlgProc for our dialog's Window Procedure, we
	// don't need to modify any of the behavior anyway.
	   wndclass.lpfnWndProc    = DefDlgProc;
	   wndclass.cbClsExtra     = 0 ;
									
	// This field MUST be set to DLGWINDOWEXTRA, or this class we're
   // registering won't work properly with our dialog boxes.
	   wndclass.cbWndExtra     = DLGWINDOWEXTRA ;
															
	// Use the app's instance.  AfxGetInstanceHandle() gets this for
	// us nicely.
	   wndclass.hInstance      = AfxGetInstanceHandle();
																
	// Load our custom icon.  
		wndclass.hIcon          = ::LoadIcon (AfxGetInstanceHandle(), "WMLOOKUP_ICON") ;

   // Use an arrow cursor for kicks
		wndclass.hCursor        = ::LoadCursor (NULL, IDC_ARROW) ;
	   wndclass.hbrBackground  = COLOR_WINDOW + 1 ;
		wndclass.lpszMenuName   = NULL ;
						
	// Make up a unique name for our dialog class.  This same name must
   // be used in our dialog box template to force the dialog box to
	// use this new class.
	   wndclass.lpszClassName  = "WMLOOKUPCLASS";
													 
   return ::RegisterClass(&wndclass);
}
															
  

BOOL CDlgLookUp::OnInitDialog()
{
	CFile archiveFile ;
	
	if( archiveFile.Open("wmlookup.jnk", CFile::modeRead ) )
	{
		CArchive theInArchive(&archiveFile, CArchive::load) ;
		theInArchive >> pMap ;
		theInArchive.Close() ;
		archiveFile.Close() ;
	}
	else
	{

		int ret = MessageBox("Cannot find file WMLOOKUP.JNK.\n Should I create it?",
						"WmLookUp", MB_YESNO | MB_ICONQUESTION ) ;
					
		pMap = new CMapWordToOb ;
		
		buildMap() ;

		if (ret == IDYES)
		{
			// Create the file WMLOOKUP.JNK
			archiveFile.Open("wmlookup.jnk", CFile::modeWrite | CFile::modeCreate );
	
			CArchive theOutArchive(&archiveFile, CArchive::store) ;
			theOutArchive << pMap ;
			theOutArchive.Close() ;
			archiveFile.Close() ;
		}
	}
	
	fileListBox() ;
	return TRUE;
}

void CDlgLookUp::OnCancel()
{
	delete this ;
}

afx_msg void CDlgLookUp::OnOK()
{
	UINT messageId ;

	// Is Message Id Hex or Decimal
		BOOL bDec = DecimalCheck().GetCheck() ;
	
	// Get Message Id
		if ( DecimalCheck().GetCheck() )
		{
			// Decimal Value
			BOOL bRet ;
			messageId = GetDlgItemInt(idMessageID, &bRet, FALSE ) ;
			if (!bRet)
			{
				MessageBox("Invalid Message Id.","WM LookUp", MB_OK | MB_ICONEXCLAMATION) ;
				return ;
			}
		}
		else
		{
			// Hex Value
			char  text[20] ;
			if( GetDlgItemText(idMessageID, text, sizeof(text)) == 0 )
			{
				MessageBox("Invalid Message Id.","WM LookUp", MB_OK | MB_ICONEXCLAMATION) ;
				return ;
			}
			
			istrstream astrstr(text) ;  
			astrstr >> hex >> messageId ;
			if (astrstr.fail() )
			{
				MessageBox("Invalid Message Id.","WM LookUp", MB_OK | MB_ICONEXCLAMATION) ;
				return ;
			}
			
		}
		
	// Find Message Text
	
		//*** CString *pstr ;
		CMessages *pMessage ;
		if (pMap->Lookup(messageId, (CObject *&)pMessage) )
		{
			// Display Message Text
			MessageTextList().SelectString(-1, pMessage->messageText) ;
		}
		else
		{
			MessageTextList().SelectString(-1, lpszNotFound ) ;
			MessageBeep(0) ;
		}
}


/////////////////////////////////////////////////////////////////////////////
void CDlgLookUp::fileListBox() 
{
		// Turn off listbox updating
		int stops = (LOWORD(GetDialogBaseUnits()) / 4 ) * 2 * 30 ;
		MessageTextList().SetTabStops(1, &stops ) ;
		MessageTextList().SetRedraw(FALSE) ;
		MessageTextList().AddString(lpszNotFound) ;

		char tempbuf[80] ;
		CMessages *message ;
		WORD messageId ;
		POSITION pos ;
		for( pos = pMap->GetStartPosition() ; pos != NULL ; /**/)
		{
			  pMap->GetNextAssoc(pos, messageId, (CObject*&)message) ;

			// Add to listbox
				wsprintf(tempbuf,"%s\t0x%04x",
								(LPCSTR)message->messageText, messageId) ;

				MessageTextList().AddString(tempbuf) ;
				
			}
					
	// Turn on listbox updating
		MessageTextList().SetRedraw(TRUE) ;



}
/////////////////////////////////////////////////////////////////////////////
// buildMap --- Reads in the Windows.h file and builds a CMapWordToString 
//					 with it.  The information could have been directly placed 
//					 into the listbox, however, we wanted to play a little with
//					 the MFC collections.
//
BOOL CDlgLookUp::buildMap()
{
	
	// Put these into class
		char hdrName[180] ;
		char match[250] ;
		wsprintf(match,"#define %s%%s 0x%%x",msgType) ;
		
		_searchenv("windows.h", "INCLUDE", hdrName) ;
		if ( !(*hdrName) )
		{
			MessageBox("Cannot Find File.", "WM LookUp", MB_OK | MB_ICONEXCLAMATION ) ;
			return FALSE ;
		}
		
	// Open File
		CStdioFile f;
		if (!f.Open(hdrName,	CFile::modeRead | CFile::typeText) )
								
		{
			#ifdef _DEBUG
				afxDump << "File could not be opened " << "\r\n" ;
			#endif
			return FALSE ;
		}
	
	const UINT LLENGTH = 200 ;	
	char buf[LLENGTH] ;

	char messageText[40] ;
	WORD messageId ;
	int count ;

	while ( f.ReadString( buf, LLENGTH) )
	{
		// Blow it all off and use scanf...
		
			count = sscanf(buf, match ,&messageText ,&messageId ) ;
			if ( count != 0 )
			{
					// Put into data structure
						CMessages *pMessage = new CMessages ;
						pMessage->messageText = CString(msgType) + CString(messageText) ; 
						pMap->SetAt(messageId, pMessage) ;
				
			}
	}

	return TRUE ;
	
}
/////////////////////////////////////////////////////////////////////////////
// Application class
//
class CTheApp : public CWinApp
{
public:
	virtual BOOL InitInstance();
};

CTheApp anApp;

BOOL CTheApp::InitInstance()
{
	m_pMainWnd = new CDlgLookUp() ;
	m_pMainWnd->ShowWindow(m_nCmdShow) ;
	m_pMainWnd->UpdateWindow() ;
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
