Declare Function GetProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%)
Global Const WM_USER = &H400
Global Const LB_RESETCONTENT = WM_USER + 5
Global Const PIXEL = 3

Sub AddNames (I As Integer)
    Form1.File2.Path = Form1.Dir2.List(I)
    For J = 0 To Form1.File2.ListCount - 1
        Form1.List1.AddItem Form1.File2.List(J) + Chr$(9) + Chr$(9) + Format$(Dirs)
    Next J
End Sub

Sub CallUpPBrush (DName$, FName$)
If Right$(DName$, 1) <> "\" Then DName$ = DName$ + "\"
OldMousePointer = Screen.MousePointer
Screen.MousePointer = 11
If (form2.DestinationPic.ScaleWidth <> Form1.Picture1.ScaleWidth) Or (form2.DestinationPic.ScaleHeight <> Form1.Picture1.ScaleHeight) Then
   Resp% = MsgBox("Do you want to start Paintbrush with the scaled image in the clipboard ready for pasting to create a new file?", 32 + 4)
   If Resp% = 6 Then
      Clipboard.Clear
      Clipboard.SetData form2.DestinationPic.Image
      T% = Shell("pbrush", 1)
      Screen.MousePointer = OldMousePointer
      Exit Sub
   End If
End If
If (Right$(FName$, 4) <> ".bmp") Then
   Resp% = MsgBox(UCase$(FName$) + " is not a .BMP file and can't be directly changed in Paintbrush." + Chr$(13) + Chr$(13) + "Do you want to start Paintbrush with the image in the clipboard ready for pasting to create a new file?", 32 + 4)
   If Resp% = 6 Then
      Clipboard.Clear
      Clipboard.SetData Form1.Picture1.Image
      T% = Shell("pbrush", 1)
   End If
   'MsgBox "Sorry!  Not a BMP file."
Else
   T% = Shell("pbrush " + DName$ + FName$, 1)
End If
Screen.MousePointer = OldMousePointer

End Sub

Sub ClearListBox (Ctrl As Control)
  hWndOld% = GetFocus()
  tempE% = Ctrl.Enabled
  tempV% = Ctrl.Visible
  Ctrl.Enabled = True
  Ctrl.Visible = True

  Ctrl.SetFocus
  X = SendMessage(GetFocus(), LB_RESETCONTENT, 0, 0&)
  Ctrl.Enabled = tempE%
  Ctrl.Visible = tempV%
  Suc% = PutFocus(hWndOld%)
End Sub

Sub DottedLine ()
form2.DestinationPic.DrawStyle = 0
form2.DestinationPic.DrawMode = 13
form2.DestinationPic.DrawWidth = 1

form2.DestinationPic.ForeColor = &HFFFFFF
form2.DestinationPic.Line (0, 0)-(form2.DestinationPic.Width - 3, 0)
form2.DestinationPic.Line (form2.DestinationPic.Width - 3, 0)-(form2.DestinationPic.Width - 3, form2.DestinationPic.Height - 3)
form2.DestinationPic.Line (0, form2.DestinationPic.Height - 3)-(form2.DestinationPic.Width - 3, form2.DestinationPic.Height - 3)
form2.DestinationPic.Line (0, 0)-(0, form2.DestinationPic.Height - 3)


form2.DestinationPic.DrawStyle = 2
form2.DestinationPic.ForeColor = 0
form2.DestinationPic.Line (0, 0)-(form2.DestinationPic.Width - 3, 0)
form2.DestinationPic.Line (form2.DestinationPic.Width - 3, 0)-(form2.DestinationPic.Width - 3, form2.DestinationPic.Height - 3)
form2.DestinationPic.Line (0, form2.DestinationPic.Height - 3)-(form2.DestinationPic.Width - 3, form2.DestinationPic.Height - 3)
form2.DestinationPic.Line (0, 0)-(0, form2.DestinationPic.Height - 3)
End Sub

Sub DragPictureTo (X As Integer, Y As Integer, Shift As Integer)
If gDrawing Then Exit Sub
gDrawing = True

dwRop& = &HCC0020
If Form1.TileChecked.Value Then
   Tiling = True
Else
   Tiling = False
End If

'to dest from source
If Shift Then
  Ratio = Form1.Picture1.Width / Form1.Picture1.Height
  If X < Ratio * Y Then Y = X / Ratio
  If Ratio * Y < X Then X = Y * Ratio
End If

If X < 6 Then X = 6
If Y < 6 Then Y = 6
'If Not Tiling Then
'   dX = (X - Form2.DestinationPic.Width) \ 2
'   dY = (Y - Form2.DestinationPic.Height) \ 2
'   Form2.DestinationPic.Width = Form2.DestinationPic.Width + dX * 2
'   Form2.DestinationPic.Left = Form2.DestinationPic.Left - dX
'   Form2.DestinationPic.Height = Form2.DestinationPic.Height + dY * 2
'   Form2.DestinationPic.Top = Form2.DestinationPic.Top - dY
'Else
   form2.DestinationPic.Width = X
   form2.DestinationPic.Height = Y
'End If

If Metafile Then
   form2.DestinationPic.AutoSize = False
   form2.DestinationPic.Picture = Form1.Picture1.Picture
Else
   T% = DoEvents()
   T% = StretchBlt%(form2.DestinationPic.hDC, 0, 0, X - 1, Y - 1, Form1.Picture1.hDC, 0, 0, Form1.Picture1.Width, Form1.Picture1.Height, dwRop&)
   T% = DoEvents()
End If
'Form1.Picture1.Width = Form2.DestinationPic.Width
'Form1.Picture1.Height = Form2.DestinationPic.Height
'Form1.Picture1.ScaleWidth = Form2.DestinationPic.ScaleWidth
'Form1.Picture1.ScaleHeight = Form2.DestinationPic.ScaleHeight
'T% = BitBlt%(Form2.DestinationPic.hDC, Form2.DestinationPic.Left, Form2.DestinationPic.Top, X, Y, Form1.Picture1.hDC, Form1.Picture1.Left, Form1.Picture1.Top, dwRop&)
gDrawing = False
End Sub

Sub File1DClick ()
DName$ = Form1.File1.Path
Call CallUpPBrush(DName$, (Form1.File1.FileName))
End Sub

Sub FillList ()
Form1.Command2.Visible = False
Form1.Label1.Visible = True
ClearListBox Form1.List1

On Error Resume Next
Form1.Dir2.Path = Form1.Drive1.Drive + "\"
If Err <> 0 Then
   On Error Resume Next
   Form1.Drive1.Drive = SavedDrive$
   Form1.Dir2.Path = SavedDrive$ + "\"
End If
On Error GoTo 0
SavedDrive$ = Form1.Drive1.Drive
Dirs = 1
DirName(Dirs) = Form1.Dir2.Path
AddNames (-1)    'was 1
CheckingDir = 0
While CheckingDir < Dirs
   If CheckingDir Mod 10 = 0 Then
      Form1.Label1.Caption = Format$(CheckingDir) + " / " + Format$(Dirs)
      T% = DoEvents()
   End If
   CheckingDir = CheckingDir + 1
   On Error Resume Next
   Form1.Dir2.Path = DirName(CheckingDir)
   On Error GoTo 0
   For I = 0 To Form1.Dir2.ListCount - 1
      Dirs = Dirs + 1
      DirName(Dirs) = Form1.Dir2.List(I)
      AddNames (I)
   Next I

Wend


Form1.Label1.Caption = ""
Form1.Label1.Visible = False
Form1.Command2.Enabled = False
Form1.Command2.Visible = True
If Form1.List1.ListCount > 0 Then Form1.List1.ListIndex = 0

End Sub

Function FindItem (Lst As Control, a$) As Integer
Dim U As Integer
Dim L As Integer
Dim I As Integer
U = Lst.ListCount
L = 0
I = 0
If U = 0 Then
   FindItem = -1
   Exit Function
End If
Do
   If U < L Then
      'Lst.ListIndex = I + 1'set .ListIndex to nearest match
      FindItem = -1
      Exit Function
   End If

   I = (L + U) / 2
   If a$ = Lst.List(I) Then
      Lst.ListIndex = I  'Found. Set ".ListIndex" accordingly
      FindItem = I
      Exit Function
   Else
      If a$ > Lst.List(I) Then
         L = I + 1
      Else
         U = I - 1
      End If
   End If
Loop
End Function

Sub GetBackgroundColor ()
   lpDefault$ = "0 0 0" + String$(256, " ")
   lpRS$ = "0 0 0" + String$(256, " ")
   T% = GetProfileString%("colors", "Background", lpDefault$, lpRS$, 256)
   SP1Pos = InStr(lpRS$, " ")
   R$ = Left$(lpRS$, SP1Pos - 1)
   GB$ = Mid$(lpRS$, SP1Pos + 1, 255)
   SP1Pos = InStr(GB$, " ")
   G$ = Left$(GB$, SP1Pos - 1)
   B$ = Mid$(GB$, SP1Pos + 1, 255)
   bgCol& = RGB(Val(R$), Val(G$), Val(B$))
   form2.BackColor = bgCol&

End Sub

Sub GetNameAndDir (T$, FName$, DName$)
FName$ = Left$(T$, InStr(T$, Chr$(9)) - 1)
DName$ = DirName(Val(Mid$(T$, InStr(T$, Chr$(9)) + 2, 255)))
'If Right$(DName$, 1) <> "\" Then DName$ = DName$ + "\"
End Sub

Sub List1DClick ()
Call GetNameAndDir((Form1.List1.List(Form1.List1.ListIndex)), FName$, DName$)
Call CallUpPBrush(DName$, FName$)
End Sub

Sub PositionOutline ()
If Form1.ResizableChecked.Value Then
   form2.DestinationPic.Left = LBWidth% - 1
   form2.DestinationPic.Top = LBHeight% - 1
   form2.DestinationPic.BorderStyle = 1
Else
   form2.DestinationPic.BorderStyle = 0
End If
form2.Picture1.Left = form2.DestinationPic.Width - form2.Picture1.Width + form2.DestinationPic.Left
form2.Picture1.Top = form2.DestinationPic.Height - form2.Picture1.Height + form2.DestinationPic.Top
'Form2.DestinationPic.Line (0, 0)-(Form2.DestinationPic.Width, 0)
'Beep
'Form2.Line x
'
'Form2.DestinationPic.BorderStyle = 0
End Sub

Sub ShowPicture (D$, F$)
Form1.Picture1.AutoRedraw = True
Form1.Picture1.Cls
form2.DestinationPic.AutoRedraw = True
form2.DestinationPic.Cls
On Error Resume Next
If Right$(D$, 1) = "\" Then
   Form1.Picture1.Picture = LoadPicture(D$ + F$)
Else
   Form1.Picture1.Picture = LoadPicture(D$ + "\" + F$)
End If
If Right$(F$, 4) = ".wmf" Then
   Metafile = True
Else
   Metafile = False
End If

If Err <> 0 Then MsgBox "Can't load that picture."
On Error GoTo 0
form2.DestinationPic.AutoSize = True
form2.DestinationPic.Picture = Form1.Picture1.Picture
form2.DestinationPic.AutoSize = False
T% = DoEvents()
form2.Picture1.Left = form2.DestinationPic.Width - form2.Picture1.Width + form2.DestinationPic.Left
form2.Picture1.Top = form2.DestinationPic.Height - form2.Picture1.Height + form2.DestinationPic.Top
'Form2.DestinationPic.Line (0, 0)-(Form2.DestinationPic.Width, 0)
'Beep
'Call DottedLine
End Sub

Sub WallPaper ()

OldMousePointer = Screen.MousePointer
Screen.MousePointer = 11

'Assign information of the destination bitmap. Note that BitBlt() requires coordinates in pixels.

form2.DestinationPic.ScaleMode = PIXEL
form2.ScaleMode = PIXEL
nWidth% = form2.DestinationPic.ScaleWidth
nHeight% = form2.DestinationPic.ScaleHeight

'Assign information of the source bitmap.
hSrcDC% = form2.DestinationPic.hDC
XSrc% = 0: YSrc% = 0

'Assign the SRCCOPY constant to the raster operation.
dwRop& = &HCC0020
HorzCenter% = form2.ScaleWidth / 2
VertCenter% = form2.ScaleHeight / 2
If Form1.TileChecked.Value = 0 Then
   LBWidth% = HorzCenter% - nWidth% / 2
   LBHeight% = VertCenter% - nHeight% / 2
   UBWidth% = HorzCenter% + nWidth% / 2 - 1
   UBHeight% = VertCenter% + nHeight% / 2 - 1
   
   form2.ForeColor = form2.BackColor

   hDestDC% = form2.hDC
   form2.FillColor = form2.BackColor
   Suc% = PatBlt(hDestDC%, 0, 0, form2.ScaleWidth, form2.ScaleHeight, &HF00021)
   form2.DestinationPic.Left = LBWidth%
   form2.DestinationPic.Top = LBHeight%
Else
   LBWidth% = 0
   LBHeight% = 0
   UBWidth% = form2.ScaleWidth
   UBHeight% = form2.ScaleHeight
'End If

X% = LBWidth%
Y% = LBHeight%
For I% = 1 To 1
   If I% = 1 Then
      form2.AutoRedraw = -1
      hDestDC% = form2.hDC
   Else
      form2.AutoRedraw = -1
      hDestDC% = form2.hDC
   End If
   If (nHeight% > 0) And (nWidth% > 0) Then
      While Y% < UBHeight%
         While X% < UBWidth%
         Suc% = BitBlt(hDestDC%, X%, Y%, nWidth%, nHeight%, hSrcDC%, XSrc%, YSrc%, dwRop&)
         X% = X% + nWidth%
         Wend
         X% = LBWidth%
         Y% = Y% + nHeight%
      Wend
   Else
      form2.Cls
      form2.Print "?!"
   End If
Next I%
End If

form2.Refresh
Screen.MousePointer = OldMousePointer
End Sub

