#include "VecLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

BitSetRef::BitSetRef(Byte* BP, int BitOffset)
  {
    P=BP+size_t(BitOffset/8);
    M=Byte(1<<int(BitOffset%8));
  }

//.parse

ByteVector::ByteVector(File& F)
  {
    Extra=DefaultVectorExtra;
    if (F.CurPos()>F.Size())
      {
        Len=0;
        Alloc=Extra;
        P = VecNew(Alloc);
      }
    else
      {
        F.ReadThing(Len);
        if (Len)
          {
            Alloc=Len+Extra;
            P =VecNew(Alloc);
            if (Len)
              {
                F.Read(P,int(Len));
              }
          }
      }
  }

//.parse

long ByteVector::Sum()
  {
    long I;
    long A=0;
    For(I,Len) A+=*PtrInc(P,I);
    return A;
  }

//.parse

long ByteVector::Index(Byte SearchByte, long StartIndex)
  {
    if (StartIndex>=Len) return(VecObjNotFound);
    long I=StartIndex;
    while ((I<Len) && ((*PtrInc(P,I))!=SearchByte)) I++;
    if (I==Len) return(VecObjNotFound);
    else return(I);
  }

//.parse

ByteVector ByteVector::From(long Index)
  {
    ByteVector BV;
    if (Len>Index) BV=At(Index,Len-Index);
    return BV;
  }

//.parse

ByteVector ByteVector::After(long Index)
  {
    ByteVector BV;
    if (Len>(Index+1)) BV=At(Index+1,Len-Index-1);
    return BV;
  }

//.parse

Bool ByteVector::operator==(const ByteVector& B)
  {
    if (Len != B.Len) return False;
    if (P==B.P) return True;
    long I;
    For(I,Len)
        if ((*PtrInc(P,I))!=(*PtrInc(B.P,I))) return False;
    return True;
  }

//.parse

void ByteVector::Delete(long Index,long Length)
  {
    if (Length<1) return;
    if (Index<0) Index=0;
    if (Index+Length>=Len) Len=Index;
    else
      {
        Len-=Length;
        long I;
        for(I=Index;I<Len;I++) *PtrInc(P,I)=*PtrInc(P,I+Length);
      }
  }

//.parse

void ByteVector::Clip(long NewSize)
  {
    if (NewSize<Len) Len=NewSize;
  }

//.parse

void ByteVector::Assign(const ByteVector& BV)
  {
    if (P == BV.P) return;  // they're the same object
    Len = BV.Len;
    if (Len > Alloc)
      {
        FreeMemory();
        Alloc = Len+Extra;
        P = VecNew(Alloc);
      }
    BigMemCopy(P,BV.P,Len);
  }

//.parse

ByteVector::ByteVector(const ByteVector& B)
  {
    Extra=DefaultVectorExtra;
    Len = B.Len;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    BigMemCopy(P,B.P,Len);
  }

//.parse

ByteVector::ByteVector(void* B, long Length)
  {
    Extra=DefaultVectorExtra;
    Len = Length;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    BigMemCopy(P,B,Len);
  }

//.parse

void ByteVector::WriteTo(File& F)
  {
    F.WriteThing(Len);
    if (Len)
      {
        F.Write(P,size_t(Len));
      }
  }

//.parse

Byte* VecNew(long Quan)
  {
    Byte* B;
    B=(Byte*)farmalloc(Quan);
    if (B==NULL) FatalError("vector out of memory");
    return B;
  }

//.parse

Bool BigVectorJump=True;

void ByteVector::MinimizeMemory()
  {
    Bool Temp=BigVectorJump;
    BigVectorJump=False;
    ReNew(Len);
    BigVectorJump=Temp;
  }

//.parse

void ByteVector::ReNew(long NewCapacity)  // replaces ANSI-C realloc
  {
    P=(Byte*)farrealloc(P,NewCapacity);
    if (P==NULL)
      {
        Byte huge* X=(Byte huge*)farmalloc(NewCapacity);
        if (X==NULL)
            FatalError("vector out of memory: "+Str(NewCapacity));
        BigMemCopy(X,P,Len);
        farfree(P);
        P=X;
      }
    Alloc=NewCapacity;
  }

long ByteVector::ReAlloc(long NewCapacity)
  {
    if (NewCapacity < Len) NewCapacity = Len;
    if (Alloc != NewCapacity) ReNew(NewCapacity);
    return Alloc;
  }

//.parse

void ByteVector::Insert(const ByteVector& B,long Index)
  {
    *this=Before(Index)+B+From(Index);
  }

void ByteVector::Insert(Byte B,long Index)
  {
    *this=Before(Index)+B+From(Index);
  }

void ByteVector::Clear(Byte B)
  {
    long I;
    For(I,Alloc) *PtrInc(P,I)=B;  // other funcs depend on clearing to alloc
  }

//.parse

#define ParenGuts if (I>=Len) return 0; return (*PtrInc(P,I));

Byte ByteVector::At(long I) {ParenGuts}
Byte ByteVector::operator()(long I) {ParenGuts}

void ByteVector::FreeMemory()
  {
    farfree(P);
  }

ByteVector::ByteVector()
  {
    Extra=DefaultVectorExtra;
    Len = 0;
    Alloc = Extra;
    P = VecNew(Alloc);
  }

//.parse

ByteVector::ByteVector(int B)
  {
    Extra=DefaultVectorExtra;
    Len = 1;
    Alloc = Extra+1;
    P = VecNew(Alloc);
    P[0]=Byte(B);
  }

//.parse

ByteVector::ByteVector(int B1,int B2)
  {
    Extra=DefaultVectorExtra;
    Len = 2;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    P[0]=Byte(B1);
    P[1]=Byte(B2);
  }

//.parse

ByteVector::ByteVector(int B1,int B2,int B3)
  {
    Extra=DefaultVectorExtra;
    Len = 3;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    P[0]=Byte(B1);
    P[1]=Byte(B2);
    P[2]=Byte(B3);
  }

//.parse

ByteVector::ByteVector(int B1,int B2,int B3,int B4)
  {
    Extra=DefaultVectorExtra;
    Len = 4;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    P[0]=Byte(B1);
    P[1]=Byte(B2);
    P[2]=Byte(B3);
    P[3]=Byte(B4);
  }

//.parse

ByteVector::ByteVector(int B1,int B2,int B3,int B4,int B5)
  {
    Extra=DefaultVectorExtra;
    Len = 5;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    P[0]=Byte(B1);
    P[1]=Byte(B2);
    P[2]=Byte(B3);
    P[3]=Byte(B4);
    P[4]=Byte(B5);
  }

//.parse

ByteVector::ByteVector(int B1,int B2,int B3,int B4,int B5,int B6)
  {
    Extra=DefaultVectorExtra;
    Len = 6;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    P[0]=Byte(B1);
    P[1]=Byte(B2);
    P[2]=Byte(B3);
    P[3]=Byte(B4);
    P[4]=Byte(B5);
    P[5]=Byte(B6);
  }

//.parse

ByteVector::ByteVector(int B1,int B2,int B3,int B4,int B5,int B6,int B7)
  {
    Extra=DefaultVectorExtra;
    Len = 7;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    P[0]=Byte(B1);
    P[1]=Byte(B2);
    P[2]=Byte(B3);
    P[3]=Byte(B4);
    P[4]=Byte(B5);
    P[5]=Byte(B6);
    P[6]=Byte(B7);
  }

//.parse

ByteVector::ByteVector(int B1,int B2,int B3,int B4,int B5,int B6,int B7,int B8)
  {
    Extra=DefaultVectorExtra;
    Len = 8;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    P[0]=Byte(B1);
    P[1]=Byte(B2);
    P[2]=Byte(B3);
    P[3]=Byte(B4);
    P[4]=Byte(B5);
    P[5]=Byte(B6);
    P[6]=Byte(B7);
    P[7]=Byte(B8);
  }

//.parse

ByteVector::ByteVector(int B1,int B2,int B3,int B4,int B5,int B6,int B7,
    int B8,int B9)
  {
    Extra=DefaultVectorExtra;
    Len = 9;
    Alloc = Extra+Len;
    P = VecNew(Alloc);
    P[0]=Byte(B1);
    P[1]=Byte(B2);
    P[2]=Byte(B3);
    P[3]=Byte(B4);
    P[4]=Byte(B5);
    P[5]=Byte(B6);
    P[6]=Byte(B7);
    P[7]=Byte(B8);
    P[8]=Byte(B9);
  }

//.parse

void ByteVector::CopyTo(void* Dest, long Bytes)
  {
    if (Bytes>Len) Bytes=Len;
    BigMemCopy(Dest,P,Bytes);
  }

void ByteVector::CopyFrom(void* Source, long Bytes)
  {
    if (Alloc<Bytes)
      {
        FreeMemory();
        Alloc=Bytes+Extra;
        P=VecNew(Alloc);
      }
    Len=Bytes;
    BigMemCopy(P,Source,Bytes);
  }

//.parse

void ByteVector::operator+=(const ByteVector& BV)
  {
    if (Alloc <= Len + BV.Len) ReAlloc(Len+BV.Len+Extra);
    BigMemCopy(PtrInc(P,Len),BV.P,BV.Len);
    Len += BV.Len;
  }

ByteVector operator+(Byte B, const ByteVector& BV)
  {
    ByteVector V(B);
    V+=BV;
    return V;
  }

//.parse

ByteVector ByteVector::operator+(const ByteVector& B)
  {
    ByteVector BV=*this;
    BV+=B;
    return BV;
  }

ByteVector ByteVector::operator+(Byte B)
  {
    ByteVector BV=*this;
    BV+=B;
    return BV;
  }

//.parse

ByteVector ByteVector::operator()(long Index, long Length)
  {
    ByteVector B;
    if ((Index>=Len)||(Length==0)) return B;
    else if (Index+Length>Len) Length=Len-Index;
    B.ReAlloc(Length+Extra);
    B.Len=Length;
    BigMemCopy(B.P,PtrInc(P,Index),Length);
    return B;
  }

ByteVector ByteVector::At(long Index, long Length)
  {
    ByteVector B=operator()(Index,Length);
    return B;
  }

//.parse

Byte huge& ByteVector::Ref(long Index)
  {
    if (Index>=Alloc)
      {
        ReNew(Index+Extra);
        Len=Index+1;
      }
    else if (Index>=Len) Len=Index+1;
    Byte huge* BP=PtrInc(P,Index);
    return *BP;
  }

