#include <stdio.h>
#include <WBtrieve.h>
#include <WStr.h>

extern "C"
  {
    #include "turcbtrv.c"
  }

#pragma hdrstop

// copyright (c) 1993 Paul Wheaton

struct StatBuffer
  {
    FileSpec F;
    KeySpec K[10];
    char ACS[256];  // alternate collating sequence
  };

Btrieve::Btrieve(const char* FileName, int BiggestRecSize,int Mode)
  {
    int BufLen=1;
    Stat=BTRV(0,PosBlock,"",&BufLen,(char*)FileName,Mode);
    if (Stat!=0) FatalError("btopen "+Str(Stat));
    Closed=False;
    BuffyLen=BiggestRecSize;
    Buffy=new char[BuffyLen];
    if (Buffy==NULL) FatalError("btopenb "+Str(BuffyLen));
    LastKey=0;
    ClearArray(Keys);
    StatBuffer SB;
    int SBLen=sizeof(SB);
    char KeyBuffer[64];
    Stat=BTRV(15,PosBlock,(char*)&SB,&SBLen,KeyBuffer,0);
    if (Stat!=0) FatalError("btopens "+Str(Stat));
    int I;
    For(I,SB.F.NumIndexes) Keys[I]=&Buffy[SB.K[I].Pos-1];
  }

void Btrieve::Close()
  {
    if (!Closed)
      {
        int Dummy=0;
        BTRV(1,PosBlock,"",&Dummy,"",0);
        delete Buffy;
      }
  }

int Btrieve::GetFirst(int KeyNum)
  {
    int BL=BuffyLen;
    Stat=BTRV(12,PosBlock,Buffy,&BL,Keys[KeyNum],KeyNum);
    if (!((Stat==0)||(Stat==22))) BL=0;
    LastKey=KeyNum;
    return BL;
  }

int Btrieve::GetLast(int KeyNum)
  {
    int BL=BuffyLen;
    Stat=BTRV(13,PosBlock,Buffy,&BL,Keys[KeyNum],KeyNum);
    if (!((Stat==0)||(Stat==22))) BL=0;
    LastKey=KeyNum;
    return BL;
  }

int Btrieve::GetNext()
  {
    int BL=BuffyLen;
    Stat=BTRV(6,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetPrev()
  {
    int BL=BuffyLen;
    Stat=BTRV(7,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetE(int SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((int*)Keys[LastKey])=SearchVal;
    Stat=BTRV(5,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetE(const char* SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    strcpy((char*)Keys[LastKey],SearchVal);
    Stat=BTRV(5,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetE(long SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((long*)Keys[LastKey])=SearchVal;
    Stat=BTRV(5,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetG(int SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((int*)Keys[LastKey])=SearchVal;
    Stat=BTRV(8,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetG(const char* SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    strcpy((char*)Keys[LastKey],SearchVal);
    Stat=BTRV(8,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetG(long SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((long*)Keys[LastKey])=SearchVal;
    Stat=BTRV(8,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetGE(int SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((int*)Keys[LastKey])=SearchVal;
    Stat=BTRV(9,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetGE(const char* SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    strcpy((char*)Keys[LastKey],SearchVal);
    Stat=BTRV(9,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetGE(long SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((long*)Keys[LastKey])=SearchVal;
    Stat=BTRV(9,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetL(int SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((int*)Keys[LastKey])=SearchVal;
    Stat=BTRV(10,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetL(const char* SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    strcpy((char*)Keys[LastKey],SearchVal);
    Stat=BTRV(10,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetL(long SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((long*)Keys[LastKey])=SearchVal;
    Stat=BTRV(10,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetLE(int SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((int*)Keys[LastKey])=SearchVal;
    Stat=BTRV(11,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetLE(const char* SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    strcpy((char*)Keys[LastKey],SearchVal);
    Stat=BTRV(11,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

int Btrieve::GetLE(long SearchVal, int KeyNum)
  {
    int BL=BuffyLen;
    LastKey=KeyNum;
    *((long*)Keys[LastKey])=SearchVal;
    Stat=BTRV(11,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

Bool Btrieve::Update()
  {
    int BL=BuffyLen;
    Stat=BTRV(3,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    return (Stat==0);
  }

Bool Btrieve::Update(int RecLen)
  {
    int BL=RecLen;
    Stat=BTRV(3,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    return (Stat==0);
  }

Bool Btrieve::Insert(const void* Rec)
  {
    int BL=BuffyLen;
    Stat=BTRV(2,PosBlock,(Rec==NULL?Buffy:(char*)Rec),&BL,Keys[LastKey],LastKey);
    return (Stat==0);
  }

Bool Btrieve::Insert(const void* Rec,int Len)
  {
    int BL=Len;
    Stat=BTRV(2,PosBlock,(Rec==NULL?Buffy:(char*)Rec),&BL,Keys[LastKey],LastKey);
    return (Stat==0);
  }

void Btrieve::DelCur() // the last record loaded up is killed from the database
  {
    Stat=BTRV(4,PosBlock,Buffy,&BuffyLen,Keys[LastKey],LastKey);
  }

long Btrieve::Position()
  {
    long P;
    int PL=4;
    Stat=BTRV(22,PosBlock,(char*)&P,&PL,(char*)&P,0);
    return P;
  }

int Btrieve::GetDirect(long Pos)
  {
    *((long*)Buffy)=Pos;
    int BL=BuffyLen;
    Stat=BTRV(23,PosBlock,Buffy,&BL,Keys[LastKey],LastKey);
    if (!((Stat==0)||(Stat==22))) BL=0;
    return BL;
  }

static struct AlternateCollatingSequence
  {
    char Signature;
    char Name[8];
    char Seq[256];
  } ACS;

CreateBtrieveFile::CreateBtrieveFile(const char* FileName, int RecSize,
    int PageSize)
  {
    Name=FileName;
    F.RecLen=RecSize;
    F.PageSize=PageSize;
    F.PreAllocation=0;
    Closed=False;
    IncludeACS=False;
  }

void CreateBtrieveFile::Done()
  {
    if (!Closed)
      {
        Closed=True;
        F.Unused=0;
        F.Reserved=0;
        F.NumIndexes=int(K.Size());
        /*  the following chunk of code was used for debugging
        puts("\n\nCreating "+String(Name));
        puts("\n  rec len = "+Str(F.RecLen));
        puts("page size = "+Str(F.PageSize));
        puts("  indexes = "+Str(F.NumIndexes));
        String S="    flags = ";
        int I;
        For(I,16) S+=Str(F.Flags[I])+' ';
        puts(S);
        puts(" prealloc = "+Str(F.PreAllocation));
        For(I,F.NumIndexes)
          {
            Delay(1500);
            puts("\nIndex "+Str(I));
            puts("          pos = "+Str(K[I].Pos));
            puts("          len = "+Str(K[I].Len));
            String S="        flags = ";
            int J;
            For(J,16) S+=Str(K[I].Flags[J])+' ';
            puts(S);
            puts("extended type = "+Str(K[I].ExtendedType));
            puts("     null val = "+Str(K[I].NullValue));
          }
        */
        int BufSize1=16*(F.NumIndexes+1);
        int BufSize=BufSize1;
        if (IncludeACS) BufSize+=sizeof(ACS);
        char* Buf=new char[BufSize];
        memcpy(Buf,&F,16);
        memcpy(&Buf[16],&K[0],F.NumIndexes*16);
        if (IncludeACS) memcpy(&Buf[BufSize1],&ACS,sizeof(ACS));
        char PosBlock[128];
        int Status=BTRV(14,PosBlock,Buf,&BufSize,(char*)Name,0);
        if (Status!=0) FatalError("BT create "+Str(Status));
        delete(Buf);
      }
  }

void CreateBtrieveFile::SetFreeSpaceThreshold(int Percent)
  {
    if ((Percent==10)||(Percent==20)||(Percent==30))
      {
        if (Percent>=20)
          {
            F.Flags[7]=On;
            Percent-=20;
          }
        if (Percent==10) F.Flags[6]=On;
      }
  }

void CreateBtrieveFile::PreAllocatePages(int Pages)
  {
    if (Pages>0)
      {
        F.PreAllocation=Pages;
        F.Flags[2]=On;
      }
  }

void CreateBtrieveFile::DefineKey(int Pos, int Len, BtrieveKeyType BKT,
    Bool Duplicates, Bool Modifiable, int KeyNum)
  {
    KeySpec KS;
    KS.Pos=Pos+1;   // btrieve calls "1" the first byte
    KS.Len=Len;
    KS.NotUsed=0;
    KS.NullValue=0;
    KS.Reserved=0;
    KS.Flags[0]=Duplicates;
    KS.Flags[1]=Modifiable;
    KS.Flags[8]=True; // type is extended
    KS.ExtendedType=char((BKT==BKInt)?1:11);
    if (BKT==BKString)
      {
        ACS.Signature='\xac';
        strcpy(ACS.Name,"lower  ");
        int I;
        For(I,256) ACS.Seq[I]=I;
        for(I='A';I<='Z';I++) ACS.Seq[I]=I+32;
        KS.Flags[5]=True;
        IncludeACS=True;
      }
    K[KeyNum]=KS;
  }

