#ifndef WBaseIncluded
#define WBaseIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
// voice phone:  (406)543-7543
// modem phone:  (406)543-1144 (2400N81)
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <d4all.h>  // codebase stuff
#include <WStr.h>

class Field
  {
      F4FIELD* F;
    public:
      Field(F4FIELD* FF){F=FF;}
      void operator=(const char* St){f4assign(F,(char*)St);}
      void Assign(const char* St){f4assign(F,(char*)St);}
      operator const char*(){return f4str(F);}
      operator String() {return String(f4str(F));}
      String St() {return String(f4str(F));}

      void operator=(double D){f4assign_double(F,D);}
      void Assign(double D){f4assign_double(F,D);}
      operator double(){return f4double(F);}
      double D(){return f4double(F);}

      void operator=(int I){f4assign_int(F,I);}
      void Assign(int I){f4assign_int(F,I);}
      operator int(){return f4int(F);}
      int I(){return f4int(F);}

      void operator=(long L){f4assign_long(F,L);}
      void Assign(long L){f4assign_long(F,L);}
      operator long(){return f4long(F);}
      long L(){return f4long(F);}

      // void operator=(Bool B){f4assign_char(F,(B?'T':'F'));}
      void AssignBool(Bool B){f4assign_char(F,(B?'T':'F'));}
      // operator Bool(){return f4true(F);}
      Bool B(){return f4true(F);}

      void Blank(){f4blank(F);}
      const char* Name(){return f4name(F);}
  };

class dBase
  {
      D4DATA* D;  //  points to the data CodeBase keeps on this database
    public:
      dBase(const char* FileName);
      ~dBase()                              {d4close(D);}
      operator D4DATA*(){return D;}
      void Close()                          {d4close(D);}
      void Top()                            {d4top(D);}
      void Bottom()                         {d4bottom(D);}
      Bool bof()                            {return (d4bof(D)!=0);}
      Bool eof()                            {return (d4eof(D)!=0);}
        // "EOF" (vs. "eof") will not work due to conflict with ANSI lib "EOF"
      void Delete()                         {d4delete(D);}
      long RecNum()                         {return d4recno(D);}
      void GetRec(long R)                   {d4go(D,R);}
      Field F(const char* FieldName)        {return d4field(D,(char*)FieldName);}
      Field F(int FieldNum)                 {return d4field_j(D,FieldNum);}
      int FieldNum(const char* FieldName)   {return d4field_number(D,(char*)FieldName);}
      int NumFields()                       {return d4num_fields(D);}
      long NumRecs()                        {return d4reccount(D);}
      int Seek(const char* SearchText)      {return d4seek(D,(char*)SearchText);}
      Bool Skip(long Num=1)                   {return (d4skip(D,Num)==0);}
      void SetIndexTag(const char* TagName);
      void SetDefaultTag() {d4tag_default(D);}
      void AppendBlank() {d4append_blank(D);}
      double Percent() {return d4position(D);}
  };

#endif
