/* CoolWorx header -- Williams */
#ifndef CW_HEADER
#define CW_HEADER
#ifdef __cplusplus
extern "C" {
#endif

/*********************/
/* General functions */
BOOL WINAPI cw_Begin(HANDLE hInst);
BOOL WINAPI cw_BeginIcons(HANDLE,HICON,HICON);
void WINAPI cw_End(HANDLE hInst);
BOOL WINAPI cw_ModelessRegister(HWND,BOOL);
BOOL WINAPI cw_DialogProcess(LPMSG);
WORD WINAPI cw_Run(HWND w,HWND mdi,int nracc,LPHANDLE ary,
        BOOL idle);
#define CW_MESSAGE (WM_USER+2000)
#define CW_SDICREATE (CW_MESSAGE+0)
#define CW_IDLE (CW_MESSAGE+5)


/*********************/
/* Ribbon functions */
HWND WINAPI cw_Ribbon(LPCSTR id,HWND par,LONG param);
void WINAPI cw_SetRibbon(HWND,UINT id,LPCSTR s);
BOOL WINAPI cw_RibbonAdj(HWND,LPRECT );
BOOL WINAPI cw_RibbonInvAdj(HWND w,LPRECT r,BOOL vis,
  HWND stop);
void WINAPI cw_GetClientRect(HWND,LPRECT);
HWND WINAPI cw_GetRibbon(HWND w,LONG param);
void WINAPI cw_EnableCommand(HMENU,HWND,int,BOOL,BOOL);
/* Ribbon locations */
#define CWRIBBON_TOP 0
#define CWRIBBON_BOTTOM 1
#define CWRIBBON_RIGHT 2
#define CWRIBBON_LEFT 3
/* Ribbon style */
#define CWRIBBON_FOCUSOK 0x80000000L

/*********************/
/*    SDI support    */
HWND WINAPI cw_SDICreate(LPCSTR title,LPCSTR menu,
   HANDLE hInst,FARPROC cb,LPCSTR top,LPCSTR left,
   LPCSTR right,LPCSTR bot,LONG lParam);
LONG WINAPI cw_DefWindowProc(HWND,UINT,UINT,LONG);


/*********************/
/*  Editor support  */
BOOL WINAPI cw_EditSaveFile(HWND w,LPCSTR filename);
void WINAPI cw_EditStatus(HWND w,LONG where,HWND ed,
  int id,BOOL force);
void WINAPI cw_EditNew(HWND w);
BOOL WINAPI cw_EditOpen(HWND ed,LPCSTR fn,BOOL ro);
void WINAPI cw_EditGetSel(HWND w,LPSTR bf,int sz);
BOOL WINAPI cw_EditOpenFile(HWND,LPSTR,int);
void WINAPI cw_EditSetFont(HWND w,LPLOGFONT lfp);

/* Editor styles (use instead of WM_?SCROLL */
#define CE_HSCROLL 8
#define CE_VSCROLL 16

/**********************/
/* Status bar support*/
void WINAPI cw_StatusKeys(HWND w,LONG where,
        int cap,int num,int ins,int scr);
void WINAPI cw_ToggleKeyState(int key);
void WINAPI cw_StatusTime(HWND w,LONG where,int id);
void WINAPI _export cw_StatusHelp(HANDLE hInst,HWND sb,
  UINT pane,UINT id);
HWND WINAPI cw_CreateDialogIndirectParam(HANDLE hInst,
  const void FAR *tname,HWND parent,DLGPROC cb,
  LPARAM lParam);
HWND WINAPI cw_CreateDialogParam(HANDLE hInst,
  LPCSTR tname,HWND parent,DLGPROC cb,LPARAM lParam);

/* Substitute CreateDialog */
#define cw_CreateDialog(a,b,c,d,e) \
  cw_CreateDialogParam(a,b,c,d,0,e)
#define cw_CreateDialogIndirect(a,b,c,d,e) \
  cw_CreateDialogIndirectParam(a,b,c,d,0,e)


/*********************/
/*       Misc.       */
BOOL WINAPI cw_GetFilename(HWND w,LPSTR filename,int flen,
  LPCSTR title,int len,int how,LPCSTR filter,BOOL FAR *ro,
  BOOL usehelp);
/* Message for window that can init toolbars */
#define CW_INITTOOL (CW_MESSAGE+4)
/* Use help button on common dialogs */
#define CW_USEHELP 2

/**********************/
/*    Menu defines   */
#define CW_STDMENU (CW_MESSAGE+1)
#include "cwmenu.h"

#ifdef __cplusplus
}
#endif

#endif

