#
#  If you are using MSC 6.0 and/or the Windows 3.0 SDK,
#  un-comment one or more of the following:
#
# MSC6  = YES
# SDK30 = YES

# un-comment the following for debugging:
# DEBUG = YES

LINKER = link
AS     = masm
CC     = cl

CDEBUG = /Oxw /Ob2 /Gs
LDEBUG = 
!ifdef MSC6
CDEBUG = /Oxw /Gs
!endif
!ifdef DEBUG
CDEBUG = /Zi /Od
LDEBUG = /CO
!endif

.asm.obj:
!ifdef DEBUG
	$(AS) /ML /ZI $*;
!else
	$(AS) /ML $*;
!endif

OptS    = $(OPTIONS)
OPTIONS = /AM /Gw /DWINFRACT /c /Zpe $(CDEBUG)

.c.obj:
  $(CC) $(OPTIONS) $*.c

Optsize = $(CC) $(OptS) $*.c

all: winfract.hlp res

.rc.res:
		  rc -r $*.rc

winfract.hlp: winfract.rtf mathtool.rtf
	hc winfract

winfract.res: winfract.rc mathtool.rc mathtool.h coord.dlg winfract.h \
				  dialog2.h zoom.dlg
	rc -r winfract.rc

winfract.obj: winfract.c winfract.h

mathtool.obj: mathtool.c winfract.h mathtool.h

profile.obj: profile.c winfract.h

dialog.obj: dialog.c winfract.h fractint.h

dialog2.obj: dialog2.c winfract.h dialog2.h fractint.h

select.obj: select.c select.h

windos.obj: windos.c winfract.h fractint.h

windos2.obj: windos2.c fractint.h

wintext.obj: wintext.c

mainfrac.obj: mainfrac.c fractint.h

calcfrac.obj: calcfrac.c fractint.h fractype.h

fractals.obj: fractals.c fractint.h fractype.h

fractalp.obj: fractalp.c fractint.h fractype.h

fracsubr.obj: fracsubr.c fractint.h fractype.h

lorenz.obj: lorenz.c fractint.h fractype.h

testpt.obj: testpt.c fractint.h 

parser.obj: parser.c

jb.obj: jb.c fractint.h 

lsys.obj: lsys.c fractint.h 

lsysa.obj: lsysa.asm

prompts.obj : prompts.c fractint.h fractype.h

help.obj : help.c fractint.h helpdefs.h

cmdfiles.obj: cmdfiles.c fractint.h fractype.h

plot3d.obj: plot3d.c fractint.h 

3d.obj: 3d.c fractint.h 

loadfile.obj: loadfile.c fractint.h 

decoder.obj: decoder.c fractint.h 

encoder.obj: encoder.c fractint.h 

gifview.obj: gifview.c fractint.h 

tgaview.obj: tgaview.c fractint.h 

f16.obj: f16.c fractint.h 

line3d.obj: line3d.c fractint.h

miscres.obj: miscres.c fractint.h fractype.h

miscovl.obj: miscovl.c fractint.h

mpmath_c.obj: mpmath_c.c mpmath.h

fpu387.obj: fpu387.asm

fpu087.obj: fpu087.asm
	$(AS) /e /ML fpu087;

mpmath_a.obj: mpmath_a.asm

wgeneral.obj: wgeneral.asm

calcmand.obj: calcmand.asm

calmanfp.obj: calmanfp.asm
	$(AS) /e /ML calmanfp;

fracsuba.obj: fracsuba.asm

newton.obj: newton.asm
	$(AS) /e /ML newton;

winfract.exe: lorenz.obj parser.obj jb.obj testpt.obj miscres.obj \
	 plot3d.obj 3d.obj line3d.obj loadfile.obj decoder.obj mathtool.obj \
	 encoder.obj gifview.obj tgaview.obj f16.obj lsys.obj lsysa.obj \
	 mpmath_c.obj mpmath_a.obj fpu387.obj fpu087.obj cmdfiles.obj \
	 calcfrac.obj fractals.obj fractalp.obj fracsubr.obj newton.obj \
         calcmand.obj calmanfp.obj prompts.obj help.obj \
	 fracsuba.obj winfract.obj dialog.obj dialog2.obj select.obj \
	 winfract.def windos.obj windos2.obj miscovl.obj wintext.obj \
	 wgeneral.obj mainfrac.obj profile.obj
	 link $(LDEBUG) /NOE @winfract.lnk

res: winfract.res winfract.exe
!ifdef SDK30
	 rc -k winfract
!else
	 rc -k -30 winfract
!endif
