/*

	various dialog-box code - there's more in DIALOG2.C

*/

#include "windows.h"
#include "winfract.h"
#include "mathtool.h"
#include "fractint.h"
#include <string.h>
#include <math.h>
#include <stdio.h>
#include <sys\types.h>
#include <sys\stat.h>

extern HWND hwnd;                               /* handle to main window */
extern char szHelpFileName[];			/* Help file name*/
extern HANDLE hThisInst;

extern LPBITMAPINFO pDibInfo;
extern char huge *pixels;
extern LPLOGPALETTE pLogPal;

char far DialogTitle[128];

char FullPathName[128];
char FileName[128];
char OpenName[128];
char DefPath[128];
char DefSpec[13];
char DefExt[10];
BOOL OperCancelled;

OFSTRUCT OfStruct;			  /* information from OpenFile()     */
struct stat FileStatus; 		  /* information from fstat()	   */


/****************************************************************************

    FUNCTION: SaveAsDlg(HWND, unsigned, WORD, LONG)

    PURPOSE: Allows user to change name to save file to

    COMMENTS:

	This will initialize the window class if it is the first time this
	application is run.  It then creates the window, and processes the
	message loop until a PostQuitMessage is received.  It exits the
	application by returning the value passed by the PostQuitMessage.

****************************************************************************/

BOOL bSaveEnabled = FALSE;

extern int time_to_save;
extern int gif87a_flag;
int FileFormat = 0;
FARPROC lpStatusBox = NULL;
HWND hStatusBox;
char far StatusTitle[80];

BOOL FAR PASCAL StatusBoxProc(HWND hDlg, unsigned Msg, WORD wParam,
                LONG lParam)
{
   char PerStr[10];
   RECT Rect, TextRect;
   HWND hBar, hCancel;
   HDC hBarDC;
   unsigned Percent;

   switch(Msg)
   {
      case WM_INITDIALOG:
         SetWindowText(hDlg, StatusTitle);
         hCancel = GetDlgItem(hDlg, ID_CANCEL);
         SetFocus(hCancel);
         return(FALSE);

      case WM_CHAR:
         if(wParam == VK_RETURN || wParam == VK_ESCAPE)
            OperCancelled = TRUE;
         break;

      case WM_COMMAND:

         if(wParam == ID_CANCEL)
            OperCancelled = TRUE;
         break;

      case WM_USER:
         /* Invalidate Bar Window */
         hBar = GetDlgItem(hDlg, ID_PERCENT);
         GetClientRect(hBar, &TextRect);

         /* Calculate Percentage */
         hBarDC = GetDC(hBar);
         Percent = (unsigned)((lParam * 100) / wParam);
         if(Percent <= 100)
         {
            wsprintf(PerStr, "%d", Percent);
            strcat(PerStr, "%");

            /* Display Bar */
            Rect = TextRect;
            Rect.right = (unsigned)((((long)Percent) * Rect.right) / 100);
            Rect.top += 2;
            Rect.bottom -= 2;
            Rectangle(hBarDC, Rect.left, Rect.top, Rect.right, Rect.bottom);

            /* Display Percentage */
            DrawText(hBarDC, PerStr, lstrlen(PerStr), &TextRect,
                     DT_CENTER | DT_VCENTER | DT_SINGLELINE);
         }

         ReleaseDC(hBar, hBarDC);
         break;

      case WM_DESTROY:
         break;

      default:
         return(FALSE);
   }
   return(TRUE);
}

void OpenStatusBox(HWND hWnd, HANDLE hInst)
{
   if(lpStatusBox == NULL)
      lpStatusBox = MakeProcInstance(StatusBoxProc, hInst);
   hStatusBox = CreateDialog(hInst, "StatusBox", hWnd, lpStatusBox);
}

void CloseStatusBox(void)
{
   DestroyWindow(hStatusBox);
}

void UpdateStatusBox(unsigned long Partial, unsigned long Total)
{
   if(Total > 0xffff)
   {
      Total >>= 16;
      Partial >>= 16;
   }
   SendMessage(hStatusBox, WM_USER, (unsigned)Total, Partial);
}

void AddFormatExt(void)
{
   unsigned n;
   char *ExtStr;

   if(FileFormat == ID_BMP)
      ExtStr = ".BMP";
   else
      ExtStr = ".GIF";
   for(n = 0; FileName[n] && FileName[n] != '.'; n++);
   lstrcpy(&FileName[n], ExtStr);
}

void UpdateDefPath(HWND hDlg)
{
   unsigned char TempName[128];
   int n;

   GetDlgItemText(hDlg, IDC_EDIT, TempName, sizeof(TempName));
   for(n = lstrlen(TempName) - 1; n >= 0; n--)
   {
      if(TempName[n] == '\\')
      {
         HWND hEdit;

         lstrcpy(FileName, &TempName[n+1]);
         hEdit = GetDlgItem(hDlg, IDC_EDIT);
         SetWindowText(hEdit, FileName);
         TempName[n] = 0;
         DlgDirList(hDlg, TempName, NULL, IDC_PATH, 0x4010);
         GetDlgItemText(hDlg, IDC_PATH, DefPath, sizeof(FullPathName));
         break;
      }
   }
   if(n < 0)
      lstrcpy(FileName, TempName);
   FileName[8] = 0;
   AddFormatExt();
}


BOOL Check4Wildcards(hWnd, pSrc)
HWND hWnd;
PSTR pSrc;
{
    PSTR pTmp;

    if (!pSrc[0])
	return (FALSE); 	      /* Indicates no filename was specified */

    pTmp = pSrc;
    while (*pTmp) {			/* Searches the string for wildcards */
	switch (*pTmp++) {
	    case '*':
	    case '?':
		MessageBox(hWnd, "Wildcards not allowed.",
		    NULL, MB_OK | MB_ICONEXCLAMATION);
		return (FALSE);
	}
    }
    return(TRUE);
}

int FAR PASCAL SaveAsDlg(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
    unsigned char TempName[128];

    switch (message) {

	case WM_INITDIALOG:

	    SetDlgItemText(hDlg, ID_FILETITLE, DialogTitle);
            AddFormatExt();
            while(OpenFile(FileName, (LPOFSTRUCT) &OfStruct, OF_EXIST) >= 0)
               updatesavename(FileName);

	    EnableWindow(GetDlgItem(hDlg, IDOK), bSaveEnabled);

            if(FileFormat == 0)
               FileFormat = (gif87a_flag) ? ID_GIF87A : ID_GIF89A;
            CheckDlgButton(hDlg, FileFormat, 1);
            SetDlgItemText(hDlg, IDC_EDIT, FileName);
	    SetFocus(GetDlgItem(hDlg, IDC_EDIT));
            UpdateDefPath(hDlg);
            if(DefPath[0] == 0)
            {
               DlgDirList(hDlg, "*.*", NULL, IDC_PATH, 0x4010);
               GetDlgItemText(hDlg, IDC_PATH, DefPath, sizeof(FullPathName));
            }
	    SendDlgItemMessage(hDlg, IDC_EDIT, EM_SETSEL, 0,
		    MAKELONG(0, 0x7fff));

	    return (FALSE);		    /* FALSE since Focus was changed */

	case WM_COMMAND:
	    switch (wParam) {

            /* MCP 10-27-91, Update file format */
                case ID_GIF87A:
                case ID_GIF89A:
                case ID_BMP:
                   CheckDlgButton(hDlg, FileFormat, 0);
                   FileFormat = wParam;
                   CheckDlgButton(hDlg, FileFormat, 1);
                   gif87a_flag = (wParam == ID_GIF87A);
                   GetDlgItemText(hDlg, IDC_EDIT, FileName, 128);
                   AddFormatExt();
                   SetDlgItemText(hDlg, IDC_EDIT, FileName);
                   return(TRUE);

		case IDC_EDIT:

		    /* If there was previously no filename in the edit
		     * control, then the save control must be enabled as soon as
		     * a character is entered.
		     */

		    if (HIWORD(lParam) == EN_CHANGE && !bSaveEnabled)
  		       EnableWindow(GetDlgItem(hDlg, IDOK), bSaveEnabled = TRUE);
                    else if(HIWORD(lParam) == EN_KILLFOCUS)
                       UpdateDefPath(hDlg);

                    return (TRUE);

		case IDOK:

		   /* Get the filename from the edit control */

		    GetDlgItemText(hDlg, IDC_EDIT, TempName, 128);

		    /* If there are no wildcards, then separate the name into
		     * path and name.  If a path was specified, replace the
		     * default path with the new path.
		     */

                    UpdateDefPath(hDlg);
                    lstrcpy(FullPathName, DefPath);
                    if (FullPathName[0] != 0) {
                        char i;
                        i = FullPathName[lstrlen(FullPathName)-1];
                        if (i != '\\' && i != '/' && i != ':')
                            lstrcat(FullPathName,"\\");
                            }
                    lstrcat(FullPathName, FileName);
	            SetFocus(GetDlgItem(hDlg, IDC_EDIT));
                    SendDlgItemMessage(hDlg, IDC_EDIT, EM_SETSEL, 0,
		       MAKELONG(0, 0x7fff));
		    if (Check4Wildcards(hDlg, FullPathName)) {
                        if (OpenFile(FullPathName, (LPOFSTRUCT) &OfStruct,
                           OF_EXIST) >= 0)
                        {
                            char str[255];
                            
	                    sprintf(str, "Replace existing %s?", FullPathName);
	                    if (MessageBox(hDlg, str, "Save . . .",
		               MB_YESNO | MB_ICONQUESTION) == IDNO)
                               return(TRUE);
                        }

              	       /* Tell the caller a filename was selected */
		       EndDialog(hDlg, IDOK);
		       time_to_save = 1;
                       OperCancelled = FALSE;
                    }
		    return(TRUE);

		case IDCANCEL:

		    /* Tell the caller the user canceled the SaveAs function */

		    EndDialog(hDlg, IDCANCEL);
		    time_to_save = 0;
		    return (TRUE);
	    }
	    break;

    }
    return (FALSE);
}

/****************************************************************************

    FUNCTION: OpenDlg(HWND, unsigned, WORD, LONG)

    PURPOSE: Let user select a file, and return.  Open code not provided.

****************************************************************************/

HANDLE FAR PASCAL OpenDlg(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
    HANDLE hFile=1;	/* Temp value for return */
    char str[255];

    switch (message) {

	case WM_COMMAND:
	    switch (wParam) {

		case IDC_LISTBOX:
		    switch (HIWORD(lParam)) {
		        char str[255];

			case LBN_SELCHANGE:
			    /* If item is a directory name, append "*.*" */
			    if (DlgDirSelect(hDlg, str, IDC_LISTBOX))
				lstrcat(str, DefSpec);

			    SetDlgItemText(hDlg, IDC_EDIT, str);
			    SendDlgItemMessage(hDlg,
				IDC_EDIT,
				EM_SETSEL,
				NULL,
				MAKELONG(0, 0x7fff));
			    break;

			case LBN_DBLCLK:
			    goto openfile;
		    }
		    return (TRUE);

		case IDOK:
openfile:
		    GetDlgItemText(hDlg, IDC_EDIT, OpenName, 128);
		    if (strchr(OpenName, '*') || strchr(OpenName, '?')) {
			SeparateFile(hDlg, (LPSTR) str, (LPSTR) DefSpec,
			    (LPSTR) OpenName);
			if (str[0])
			    lstrcpy(DefPath, str);
			ChangeDefExt(DefExt, DefSpec);
			UpdateListBox(hDlg);
			return (TRUE);
		    }

		    if (!OpenName[0]) {
			MessageBox(hDlg, "No filename specified.",
			    NULL, MB_OK | MB_ICONHAND);
			return (TRUE);
		    }

		    AddExt(OpenName, DefExt);
		    lstrcpy(FileName, OpenName);

		    /* The routine to open the file would go here, and the */
		    /* file handle would be returned instead of NULL.		*/
		    EndDialog(hDlg, hFile);
		    return (TRUE);

		case IDCANCEL:
		    EndDialog(hDlg, NULL);
		    return (FALSE);
	    }
	    break;

	case WM_INITDIALOG:			   /* message: initialize    */
	    UpdateListBox(hDlg);
	    SetDlgItemText(hDlg, ID_FILETITLE, DialogTitle);
	    SetDlgItemText(hDlg, IDC_EDIT, DefSpec);
	    SendDlgItemMessage(hDlg,		   /* dialog handle	 */
		IDC_EDIT,			   /* where to send message  */
		EM_SETSEL,			   /* select characters      */
		NULL,				   /* additional information */
		MAKELONG(0, 0x7fff));		   /* entire contents	   */
	    SetFocus(GetDlgItem(hDlg, IDC_EDIT));
	    return (FALSE); /* Indicates the focus is set to a control */
    }
    return FALSE;
}

/****************************************************************************

    FUNCTION: UpdateListBox(HWND);

    PURPOSE: Update the list box of OpenDlg

****************************************************************************/

void UpdateListBox(hDlg)
HWND hDlg;
{
    char str[255];
    
    lstrcpy(str, DefPath);
    if (DefPath[0] != 0) {
        char i;
        i = DefPath[lstrlen(DefPath)-1];
        if (i != '\\' && i != '/' && i != ':')
           strcat(str,"\\");
        }
    lstrcat(str, DefSpec);
    DlgDirList(hDlg, str, IDC_LISTBOX, IDC_PATH, 0x4010);

    /* To ensure that the listing is made for a subdir. of
     * current drive dir...
     */
    if (!strchr (DefPath, ':'))
	DlgDirList(hDlg, DefSpec, IDC_LISTBOX, IDC_PATH, 0x4010);

    /* Remove the '..' character from path if it exists, since this
     * will make DlgDirList move us up an additional level in the tree
     * when UpdateListBox() is called again.
     */
    if (strstr (DefPath, ".."))
	DefPath[0] = '\0';

    SetDlgItemText(hDlg, IDC_EDIT, DefSpec);
}

/****************************************************************************

    FUNCTION: ChangeDefExt(PSTR, PSTR);

    PURPOSE: Change the default extension

****************************************************************************/

void ChangeDefExt(Ext, Name)
PSTR Ext, Name;
{
    PSTR pTptr;

    pTptr = Name;
    while (*pTptr && *pTptr != '.')
	pTptr++;
    if (*pTptr)
	if (!strchr(pTptr, '*') && !strchr(pTptr, '?'))
	    strcpy(Ext, pTptr);
}

/****************************************************************************

    FUNCTION: SeparateFile(HWND, LPSTR, LPSTR, LPSTR)

    PURPOSE: Separate filename and pathname

****************************************************************************/

void SeparateFile(hDlg, lpDestPath, lpDestFileName, lpSrcFileName)
HWND hDlg;
LPSTR lpDestPath, lpDestFileName, lpSrcFileName;
{
    LPSTR lpTmp;
    char  cTmp;

    lpTmp = lpSrcFileName + (long) lstrlen(lpSrcFileName);
    while (*lpTmp != ':' && *lpTmp != '\\' && lpTmp > lpSrcFileName)
	lpTmp = AnsiPrev(lpSrcFileName, lpTmp);
    if (*lpTmp != ':' && *lpTmp != '\\') {
	lstrcpy(lpDestFileName, lpSrcFileName);
	lpDestPath[0] = 0;
	return;
    }
    lstrcpy(lpDestFileName, lpTmp + 1);
    cTmp = *(lpTmp + 1);
    lstrcpy(lpDestPath, lpSrcFileName);
     *(lpTmp + 1) = cTmp;
    lpDestPath[(lpTmp - lpSrcFileName) + 1] = 0;
}

/****************************************************************************

    FUNCTION: AddExt(PSTR, PSTR);

    PURPOSE: Add default extension

***************************************************************************/

void AddExt(Name, Ext)
PSTR Name, Ext;
{
    PSTR pTptr;

    pTptr = Name;
    while (*pTptr && *pTptr != '.')
	pTptr++;
    if (*pTptr != '.')
	strcat(Name, Ext);
}

/****************************************************************************

    FUNCTION: CheckFileName(HWND, PSTR, PSTR)

    PURPOSE: Check for wildcards, add extension if needed

    COMMENTS:

	Make sure you have a filename and that it does not contain any
	wildcards.  If needed, add the default extension.  This function is
	called whenever your application wants to save a file.

****************************************************************************/

BOOL CheckFileName(hWnd, pDest, pSrc)
HWND hWnd;
PSTR pDest, pSrc;
{
    PSTR pTmp;
    char str[255];

    if (!pSrc[0])
	return (FALSE); 	      /* Indicates no filename was specified */

    pTmp = pSrc;
    while (*pTmp) {			/* Searches the string for wildcards */
	switch (*pTmp++) {
	    case '*':
	    case '?':
		MessageBox(hWnd, "Wildcards not allowed.",
		    NULL, MB_OK | MB_ICONEXCLAMATION);
		return (FALSE);
	}
    }

    AddExt(pSrc, DefExt);	     /* Adds the default extension if needed */

    if (OpenFile(pSrc, (LPOFSTRUCT) &OfStruct, OF_EXIST) >= 0) {
	sprintf(str, "Replace existing %s?", pSrc);
	if (MessageBox(hWnd, str, "SaveFile",
		MB_YESNO | MB_ICONEXCLAMATION) == IDNO)
	    return (FALSE);
    }
    strcpy(pDest, pSrc);
    return (TRUE);
}

/****************************************************************************

    FUNCTION: center_window(HWND, int, int)

    PURPOSE:  Center the specified window within client area of parent.
	      Works only with popups which all the ones we want seem to be.
	      This function should be called before first paint of window.

****************************************************************************/

void center_window(HWND hchild, int xadj, int yadj)
{
    RECT crect,prect;
    int i,cwidth,cheight;
    POINT center;
    GetWindowRect(hchild, &crect);
    GetClientRect(hwnd, &prect);   /* main Fractint window */
    cwidth  = crect.right - crect.left;
    cheight = crect.bottom - crect.top;
    center.x = (prect.right + prect.left) / 2;
    center.y = (prect.bottom + prect.top) / 2;
    ClientToScreen(hwnd, &center);
    if ((center.x += xadj - (cwidth  / 2)) < 0) center.x = 0;
    if ((center.y += yadj - (cheight / 2)) < 0) center.y = 0;
    if ((i = GetSystemMetrics(SM_CXSCREEN) - cwidth ) < center.x) center.x = i;
    if ((i = GetSystemMetrics(SM_CYSCREEN) - cheight) < center.y) center.y = i;
    MoveWindow(hchild, center.x, center.y, cwidth, cheight, FALSE);
}

void SaveBitmapFile(HWND hWnd, char *FullPathName)
{
   long TotalSize, Saved = 0, ImageSize, n;
   BITMAPFILEHEADER FileHeader;
   unsigned PalSize, BitCount;
   unsigned BlockSize = 10240;
   int hFile;
   char Temp[128];
   OFSTRUCT OfStruct;
   HANDLE hPal;
   RGBQUAD FAR *Pal;

   hFile = OpenFile(FullPathName, &OfStruct, OF_CREATE);
   if(hFile == NULL)
   {
FileError:
      wsprintf(Temp, "File I/O error while saving %s.", (LPSTR)FullPathName);
      MessageBox(hWnd, Temp, "File Error . . .", MB_OK | MB_ICONEXCLAMATION);

GeneralError:
      _lclose(hFile);
      OpenFile(FullPathName, &OfStruct, OF_DELETE);
      CloseStatusBox();
      return;
   }

   BitCount = pDibInfo->bmiHeader.biBitCount;
   if(BitCount != 24)
      PalSize = (1 << BitCount) * sizeof(RGBQUAD);
   else
      PalSize = 0;

   ImageSize = pDibInfo->bmiHeader.biSizeImage;
   FileHeader.bfType = 0x4d42; /* 'BM'; */
   FileHeader.bfSize = sizeof(FileHeader) +
                       pDibInfo->bmiHeader.biSize +
                       PalSize + ImageSize;
   TotalSize = FileHeader.bfSize;
   FileHeader.bfReserved1 = FileHeader.bfReserved2 = 0;
   FileHeader.bfOffBits = FileHeader.bfSize - ImageSize;
   Saved += _lwrite(hFile, (LPSTR)&FileHeader, sizeof(FileHeader));
   Saved += _lwrite(hFile, (LPSTR)pDibInfo, (int)pDibInfo->bmiHeader.biSize);
   if(PalSize)
   {
      hPal = GlobalAlloc(GMEM_FIXED, PalSize);
      Pal = (RGBQUAD FAR *)GlobalLock(hPal);
      if(Pal == NULL)
      {
         MessageBox(hWnd, "Insufficient Memory", "Memory Error . . .",
                          MB_ICONEXCLAMATION | MB_OK);
         goto GeneralError;
      }
      for(n = 0; n < (1 << BitCount); n++)
      {
         Pal[n].rgbRed   = pLogPal->palPalEntry[n].peRed;
         Pal[n].rgbGreen = pLogPal->palPalEntry[n].peGreen;
         Pal[n].rgbBlue  = pLogPal->palPalEntry[n].peBlue;
         Pal[n].rgbReserved = 0;
      }
      Saved += _lwrite(hFile, (LPSTR)Pal, PalSize);
      GlobalUnlock(hPal);
      GlobalFree(hPal);
   }
   UpdateStatusBox(Saved, TotalSize);
   keypressed();

   /* We should have saved enough bytes to reach the image offset.  If not,
      then there was an error. */
   if(Saved != FileHeader.bfOffBits)
      goto FileError;

   for(n = 0; n < (ImageSize - BlockSize); n += BlockSize)
   {
      if(_lwrite(hFile, (LPSTR)&pixels[n], BlockSize) != BlockSize)
         goto FileError;
      Saved += BlockSize;
      UpdateStatusBox(Saved, TotalSize);
      keypressed();
      if(OperCancelled)
      {
         MessageBox(hWnd, "File save cancelled.", "Save Cancelled", MB_OK);
         goto GeneralError;
      }
   }
   Saved += _lwrite(hFile, (LPSTR)&pixels[n], (int)(ImageSize - n));
   if(Saved != TotalSize)
      goto FileError;

   UpdateStatusBox(Saved, TotalSize);
   _lclose(hFile);
   CloseStatusBox();
}
