#############################################################################
#                                  EVENTS                                   #
#                                                                           #
# This robot demonstrates the basics of events, priorites, and debugging.   #
# Just follow the path of events and handlers to get the feel for events.   #
# Equally important is the demonstration of print() statements to trace     #
# what the robot is doing. This is a VERY important debugging               #
# technique. Especially when dealing with events, it can be difficult to    #
# determine what robot code is executing, and how it got there.             #
#                                                                           #
# NOTICE: In all the code below this:     flag == TRUE                      #
#         Could be replaces by this:      flag                              #
#                                                                           #
#                                                                           #
#                                                                           #
#   EXECUTION RESULTS                                                       #
#   ~~~~~~~~~~~~~~~~~                                                       #
#                                                                           #
#   Entering Event Robot                                                    #
#   Event group 1 not true yet                                              #
#   Called higher priority event group 1                                    #
#   1.0                                                                     #
#   Ending higher priority event group 1                                    #
#   Returned from event group 1                                             #
#   0.0                                                                     #
#   Event group 2 not true yet                                              #
#   Called lower priority event 2                                           #
#   1.0                                                                     #
#   0.0                                                                     #
#   1.0                                                                     #
#   Called higher priority event group 2                                    #
#   1.0                                                                     #
#   1.0                                                                     #
#   1.0                                                                     #
#   Called higher priority event group 1                                    #
#   1.0                                                                     #
#   Ending higher priority event group 1                                    #
#   Ending higher priority event group 2                                    #
#   Ending lower priority event group 2                                     #
#   Finally, called lowest priority event group 2                           #
#   0.0                                                                     #
#   0.0                                                                     #
#   1.0                                                                     #
#   Ending lowest priority event group 2                                    #
#   Returned from event group 2                                             #
#   0.0                                                                     #
#   0.0                                                                     #
#   0.0                                                                     #
#   Leaving Event Robot  <-- Only after robot is killed!                    #
#                                                                           #
#############################################################################
                                                      
Init
{
	Name( "Events" )
	Print( "Entering Event Robot" )
	

	flag1 = FALSE
	
	RegCustom( handler1, 1, flag1 == TRUE )
	RegCustom( handler2, 2, flag1 == TRUE )
	Print( "Event group 1 not true yet" )

	flag1 = TRUE
	Print( "Returned from event group 1" )
	Print( flag1 )
	
	flag2 = FALSE
	flag3 = FALSE
	flag4 = FALSE

	RegCustom( cascade1, 3, flag2 == TRUE and flag3 == TRUE )
	RegCustom( cascade2, 4, flag2 == TRUE or flag3 == TRUE )
	RegCustom( cascade3, 5, flag4 == TRUE )
	Print( "Event group 2 not true yet" )
	
	flag2 = TRUE
	Print( "Returned from event group 2" )
	Print( flag2 )
	Print( flag3 )
	Print( flag4 )
	
}

Handler1
{
	Print( "Called higher priority event group 1" )
	Print( flag1 )

	# Notice that ending the event here still
	# allows the rest of the handler to finish!
	flag1 = FALSE

	
	Print( "Ending higher priority event group 1" )
}

Handler2
{
	Print( "Called lower priority event group 1" )
	Print( "Ending lower priority event group 1" )
}

Cascade1
{
	Print( "Called higher priority event group 2" )
	Print( flag2 )
	Print( flag3 )
	Print( flag4 )
	
	# Watch this
	flag1 = TRUE
	Print( "Ending higher priority event group 2" )
	
	flag3 = FALSE
}

Cascade2
{

	Print( "Called lower priority event group 2" )
	
	# Note that Cascade3 is not called until later since
	# higher priority events are currently in control.
	flag4 = TRUE
	
	Print( flag2 )
	Print( flag3 )
	Print( flag4 )

	flag3 = TRUE

	Print( "Ending lower priority event group 2" )
	flag2 = FALSE
}

Cascade3
{
	Print( "Finally, called lowest priority event group 2" )
	Print( flag2 )
	Print( flag3 )
	Print( flag4 )

	flag4 = FALSE
	Print( "Ending lowest priority event group 2" )
}

Dead
{
	Print( "Leaving Event Robot" )
}