'Windows API calls
Declare Function FindWindow% Lib "USER" (ByVal lpClassName&, ByVal lpWindowName$)
Declare Function ShowWindow% Lib "USER" (ByVal hWnd%, ByVal nCmdShow%)

Sub Main ()

Dim Handle%, Class&, Title$, Nul%, HideShow%

Class = 0          'window Class to find; 0 for any
HideOrShow = 0     '0 to hide, 5 to show
Title = Command$   'retrieve the command line

'check to see if the SHOW parameter was passed
If UCase$(Left$(Title, 5)) = "/SHOW" Then
    ' show window instead of hiding it
    HideOrShow = 5
    'remove the SHOW parameter from the Title variable
    Title = Trim$(Right$(Title, Len(Title) - 5))
End If

If Title = "" Then  'the user did not pass a Title parameter
    MsgBox "You must pass the Title Text of the window you would like to hide or unhide.  For example:" + Chr$(13) + Chr$(13) + "WINHIDE Program Manager" + Chr$(13) + Chr$(13) + "will hide the Program Manager.  To unhide it, run WINHIDE like this:" + Chr$(13) + Chr$(13) + "WINHIDE /SHOW Program Manager", 64
Else
    'get the handle of the window with the matching title text
    Handle = FindWindow(Class, Title)
    
    '"Handle" is True if a window was found
    If Handle Then
        'show or hide the window
        Nul = ShowWindow(Handle, HideOrShow)
    Else
        'display a message if the window was not found
        MsgBox "Unable to locate and " + Switch(HideOrShow = 0, "hide", HideOrShow = 5, "show") + " the window:" + Chr$(13) + Chr$(13) + Title, 48
    End If

End If

End

End Sub

