/*
**	$id: ssvcid openfile.c 1.1 08/03/92 10:01 am$
**		This file contains the OpenFile dialog message handler.
**
**	(C) 1991-3 Larry Widing
*/
#include	<windows.h>
#include	<commdlg.h>
#include	<bwcc.h>
#include	<string.h>
#include	<sys/stat.h>
#include	<time.h>
#include	"bitmaps.h"
#include	"bmfile.h"
#include	"gif.h"
#include	"pcx.h"
#include	"bmmanip.h"
#include	"bminfo.h"
#include	"icnfile.h"
#include	"colors.h"

/*
**	Local variables
*/
static HBITMAP	helpBitmaps[3];


/*
** int						length of string list
** LoadFileFilter(
**   LPSTR buffer,		destination buffer for the filter list
**   int bufLen,			length of filter buffer
**   int id);				ID of filter string in string table
**
**    Load in a filter string for the Common File Dialogs from the application's
**	string table, and convert it into null terminated strings.
**
** Modification History:
** 07/22/92  LCW  Created
*/
int
LoadFileFilter(LPSTR buffer, int bufLen, int id)
{
	int	filterLen;
	char	seperator;

	filterLen = LoadString(AppInstance, id, buffer, bufLen);
	seperator = buffer[filterLen - 1];

	while (*buffer != '\0')
	{
		if (*buffer == seperator)
		{
         *buffer = '\0';
		}

		++buffer;
	}

	return filterLen;
}

/*
**	BOOL FAR PASCAL EXPORT		FALSE if common dialog handler should process message
**	OpenFileHook(
**	  HWND dlg,						Handle of diaog window
**	  UINT message,				Window's message being passed
**	  WPARAM wParam,				Word parameter
**	  LPARAM lParam);				Long parameter
**
**    Filter the messages being sent to the common file open dialog to support the following
**	extended functions:
**			Bitmapped buttons
**			Gray coloring
**			Display of file date, time, and size
**
** Modification History:
** 07/22/92  LCW  Created
*/
UINT CALLBACK EXPORT
OpenFileHook(HWND dlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	BOOL	rc = FALSE;
   int	i;

	switch (message)
	{
		case WM_COMMAND:
			if (wParam == 1152 && HIWORD(lParam) == EN_CHANGE
				&& SendDlgItemMessage(dlg, 1120, LB_GETSEL, 0, 0L) != -1)
			{
				char			*tmp;
        		struct stat	statbuf;
				char			name[256];

				GetDlgItemText(dlg, 1152, (LPSTR)name, sizeof(name));
				if (stat(name, &statbuf) == 0)
				{
					wsprintf(name, "%lu", statbuf.st_size);
					SetDlgItemText(dlg, 2000, name);

					tmp = ctime(&statbuf.st_atime);
					strncpy(name, tmp+11, 8);
					name[8] = '\0';
					SetDlgItemText(dlg, 2001, name);
					strncpy(name, tmp+4, 7);
					strncpy(name+7, tmp+20, 4);
					name[11] = '\0';
  	      	   SetDlgItemText(dlg, 2002, name);
				}
				else
				{
					SetDlgItemText(dlg, 2000, "");
					SetDlgItemText(dlg, 2001, "");
					SetDlgItemText(dlg, 2002, "");
				}
			}
			break;

		case WM_CTLCOLOR:
			switch (HIWORD(lParam))
			{
				case CTLCOLOR_BTN:
				case CTLCOLOR_SCROLLBAR:
				case CTLCOLOR_LISTBOX:
					break;

				case CTLCOLOR_DLG:
				case CTLCOLOR_EDIT:
				case CTLCOLOR_MSGBOX:
            case CTLCOLOR_STATIC:
					SetBkColor((HDC)wParam, RGB(192,192,192));
               SetTextColor((HDC)wParam, RGB(0,0,0));
            	return (BOOL)(HIWORD(lParam) == CTLCOLOR_DLG ? DialogBrush : GrayBrush);
			}
			break;

		case WM_INITDIALOG:
		{
			helpBitmaps[0] = LoadBitmap(AppInstance, MAKEINTRESOURCE(100));
			helpBitmaps[1] = LoadBitmap(AppInstance, MAKEINTRESOURCE(101));
			helpBitmaps[2] = LoadBitmap(AppInstance, MAKEINTRESOURCE(102));
			SendDlgItemMessage(dlg, 1038, BBM_SETBITS, 0,
				(LONG)(LPSTR)helpBitmaps);
			SetDlgItemText(dlg, 1038, "");

			break;
      }

		case WM_DESTROY:
			for (i = 0 ; i < 3 ; ++i)
         {
				if (helpBitmaps[i] != (HBITMAP)NULL)
				{
					DeleteObject(helpBitmaps[i]);
               helpBitmaps[i] = (HBITMAP)NULL;
				}
         }
         break;
   }

	return rc;
}

/*
** void
** OpenImageFile(HWND wnd);		handle of parent window
**
**    Open an image file using the common file dialogs.
**
** Modification History:
** 07/22/92  LCW  Created
*/
void
OpenImageFile(HWND wnd)
{
	HANDLE			handle;
	OPENFILENAME	ofn;
	char				fileTitle[256], filter[256];

	FileName[0] = '\0';

	/*
	**	Load in the file type ID string
	*/
	LoadFileFilter(filter, sizeof(filter), IDS_OPEN_FILTER);

	/*
	**	Initialize the OPENFILENAME structure
	*/
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = wnd;
   ofn.hInstance = AppInstance;
	ofn.lpstrFilter = filter;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = FileName;
	ofn.nMaxFile = sizeof(FileName);
	ofn.lpstrFileTitle = fileTitle;
	ofn.nMaxFileTitle = sizeof(fileTitle);
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrDefExt = ".BMP";
	ofn.lpTemplateName = MAKEINTRESOURCE(1536);
	ofn.lpfnHook = OpenFileHook;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST //| OFN_HIDEREADONLY
		| OFN_ENABLETEMPLATE | OFN_ENABLEHOOK | OFN_SHOWHELP;

	/*
	**	Open the file
	*/
	if (GetOpenFileName(&ofn))
	{
		HCURSOR	oldCursor;

		/*
		** attempt to load the specified file, after determining its type
		*/
		switch (ofn.nFilterIndex)
		{
			case 0:	/* .BMP */
			case 1:	/* .BMP */
			case 2:	/* .PCX */
         case 3:	/* .GIF */
				/*
				**	Load a bitmap image file
				*/
            oldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
				switch (ofn.nFilterIndex)
				{
					case 2:
						handle = ReadPcxFile(FileName);
						break;

					case 3:
						handle = ReadGifFile(FileName);
						break;

					default:
						handle = ReadBitmapFile(FileName);
                  break;
				}

				if (handle != (HBITMAP)NULL)
				{
					ClearHandles();
					DIBitmapHandle = handle;

					handle = CreateDibPalette(DIBitmapHandle);
					if (handle != (HPALETTE)NULL)
					{
                  DibPalette = handle;
					}
               InvalidateRect(wnd, NULL, TRUE);
				}
            SetCursor(oldCursor);
				break;

			case 4:
				/*
				**	Load an Icon
				*/
				handle = ReadIconFile(FileName);
				if (handle != (HICON)NULL)
				{
					ClearHandles();
					IconHandle = handle;
					InvalidateRect(wnd, NULL, TRUE);
				}
				break;
		}
	}
}

/*
** void
** SaveImageFile(HWND wnd);		handle of parent window
**
**    Save an image file using the common file dialogs.
**
** Modification History:
** 07/22/92  LCW  Created
*/
void
SaveImageFile(HWND wnd)
{
	HANDLE			handle;
	OPENFILENAME	ofn;
	char				fileTitle[256], filter[256];

	FileName[0] = '\0';

	/*
	**	Load in the file type ID string
	*/
	LoadFileFilter(filter, sizeof(filter), IDS_SAVEAS_FILTER);

	/*
	**	Initialize the OPENFILENAME structure
	*/
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = wnd;
   ofn.hInstance = AppInstance;
	ofn.lpstrFilter = filter;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = FileName;
	ofn.nMaxFile = sizeof(FileName);
	ofn.lpstrFileTitle = fileTitle;
	ofn.nMaxFileTitle = sizeof(fileTitle);
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrDefExt = ".BMP";
	ofn.lpTemplateName = MAKEINTRESOURCE(1536);
   ofn.lpfnHook = OpenFileHook; 
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY
		| OFN_ENABLETEMPLATE | OFN_ENABLEHOOK | OFN_SHOWHELP;

	/*
	**	Save the file
	*/
	if (GetSaveFileName(&ofn))
	{
		HCURSOR	oldCursor;

		/*
		** attempt to save the current bitmap, after determining its type
		*/
		extern int	FileSaveMode;

		switch (ofn.nFilterIndex)
		{
			case 0:
				FileSaveMode = 0;
				break;

			case 1:
			case 2:
			case 3:
				FileSaveMode = (int)ofn.nFilterIndex;
            break;
		}

		/*
		**	Attempt to save the bitmap
		*/
      oldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
		if (DIBitmapHandle == (HANDLE)NULL)
		{
			/*
			**	First, convert to a DIB
			*/
			handle = BitmapToDIB(BitmapHandle, FileSaveMode);
			if (handle != (HANDLE)NULL)
			{
				WriteBitmapFile(FileName, handle);
				GlobalFree(handle);
			}
		}
		else
		{
			WriteBitmapFile(FileName, DIBitmapHandle);
		}
      SetCursor(oldCursor);
	}
}

/*
**	Modification History
**	====================
**
**	$lgb$
** 02/10/92     Larry Widing   Initial Version.
** 08/03/92     Larry Widing   Added support for common file dialogs.
**	$lge$
*/
