/*
**	$id: ssvcid colors.c 1.1 08/03/92 10:01 am$
**		This file conatins the functions needed to perform the color
**	modification of a Device Independant Bitmap.
**
**	(C) 1991-3	Larry Widing
*/
#include	<windows.h>
#include	<dos.h>
#include	"bitmaps.h"
#include	"bmmanip.h"
#include	"colors.h"

/*
**	Local function prototypes
*/
static LPRGBQUAD	GetColors(HWND dlg);
static void			ReleaseColors(HWND dlg);
static int			SetColors(HWND dlg, LPRGBQUAD colors);
static void			ClearColors(HWND dlg);
#if	defined(__TSC__)
	#pragma	save
	#pragma	call(windows=>on)
#endif
BOOL FAR PASCAL EXPORT	ColorMapDialog(HWND, WORD, WORD, DWORD);
#if	defined(__TSC__)
	#pragma	restore
#endif

/*
**	Local variables
*/
const char	Property[] = "Colors";

BOOL FAR PASCAL EXPORT
ColorMapDialog(HWND dlg, WORD message, WORD wParam, DWORD lParam)
{
	int				nColors, i;
	int				ok = FALSE;
	HANDLE			handle;
	LPRGBQUAD		colors;
	LPBITMAPINFO	bmi;

	switch (message)
	{
		case WM_COMMAND:
			switch (wParam)
			{
				case IDOK:
					/*
					**	Save new color values
					*/
					colors = GetColors(dlg);
					if (colors != NULL)
					{
						bmi = (LPBITMAPINFO)GlobalLock(DIBitmapHandle);
						if (bmi != NULL)
						{
							nColors = DIBitmapColors(bmi);
							for (i = 0 ; i < nColors ; ++i)
							{
								bmi->bmiColors[i] = colors[i];
							}
							ok = TRUE;
							GlobalUnlock(DIBitmapHandle);

							/*
							**	Update DIB Logical Palette
							*/
							if (DibPalette != (HPALETTE)NULL)
							{
								DeleteObject(DibPalette);
							}
							DibPalette = CreateDibPalette(DIBitmapHandle);
						}
					}
					EndDialog(dlg, ok);
					break;

				case IDCANCEL:
					EndDialog(dlg, 0);
					break;

				case CLRD_RGBLIST:
					if (HIWORD(lParam) == LBN_SELCHANGE)
					{
						/*
						**	Update the edit controls
						*/
						colors = GetColors(dlg);
						if (colors != NULL)
						{
							i = (int)SendDlgItemMessage(dlg, CLRD_RGBLIST, LB_GETCURSEL, 0, 0L);
							if (i >= 0)
							{
								SetDlgItemInt(dlg, CLRD_RED, colors[i].rgbRed, FALSE);
								SetDlgItemInt(dlg, CLRD_GREEN, colors[i].rgbGreen, FALSE);
								SetDlgItemInt(dlg, CLRD_BLUE, colors[i].rgbBlue, FALSE);
							}
							ReleaseColors(dlg);
						}
					}
					break;

				case CLRD_RED:
				case CLRD_GREEN:
				case CLRD_BLUE:
					if (HIWORD(lParam) == EN_KILLFOCUS
						|| HIWORD(lParam) == EN_CHANGE)
					{
						/*
						**	Update any change in this value to the listbox entry
						*/
						colors = GetColors(dlg);
						if (colors != NULL)
						{
							i = (int)SendDlgItemMessage(dlg, CLRD_RGBLIST, LB_GETCURSEL, 0, 0L);
							if (i >= 0)
							{
								if (wParam == CLRD_RED)
									colors[i].rgbRed = GetDlgItemInt(dlg, CLRD_RED, NULL, FALSE);
								else if (wParam == CLRD_GREEN)
									colors[i].rgbGreen = GetDlgItemInt(dlg, CLRD_GREEN, NULL, FALSE);
								else
									colors[i].rgbBlue = GetDlgItemInt(dlg, CLRD_BLUE, NULL, FALSE);

								InvalidateRect(GetDlgItem(dlg, CLRD_RGBLIST), NULL, FALSE);
							}

							ReleaseColors(dlg);
						}
					}
//					else if (HIWORD(lParam) == EN_CHANGE)
//					{
//						/*
//						**	Reflect any change in the color box
//						*/
//					}
					break;
			}
			return TRUE;

		case WM_DRAWITEM:
		{
			LPDRAWITEMSTRUCT	draw = (LPDRAWITEMSTRUCT)lParam;
			int					item = draw->itemID;
			HBRUSH				hbr;
			char					tmp[30];

			if (draw->CtlID == CLRD_RGBLIST)
			{
				colors = GetColors(dlg);
				if (colors != NULL)
				{
					HPALETTE	oldPal = (HPALETTE)NULL;

					if (DibPalette != (HPALETTE)NULL)
					{
						oldPal = SelectPalette(draw->hDC, DibPalette, TRUE);
                  RealizePalette(draw->hDC);
					}

					if (draw->itemAction == ODA_DRAWENTIRE)
					{
						/* Erase the item */
						hbr = CreateSolidBrush(RGB(colors[item].rgbRed,
							colors[item].rgbGreen, colors[item].rgbBlue));
						if (hbr != (HBRUSH)NULL)
						{
							FillRect(draw->hDC, (LPRECT)&draw->rcItem, hbr);
							DeleteObject(hbr);
						}
					
						SetTextColor(draw->hDC, RGB(255 - colors[item].rgbRed,
							255 - colors[item].rgbGreen, 255 - colors[item].rgbBlue));
						SetBkMode(draw->hDC, TRANSPARENT);
						
						wsprintf((LPSTR)tmp, (LPSTR)"%d red, %d green, %d blue",
							colors[item].rgbRed, colors[item].rgbGreen,
							colors[item].rgbBlue);

						DrawText(draw->hDC, (LPSTR)tmp, -1, (LPRECT)&draw->rcItem,
							DT_VCENTER | DT_NOPREFIX | DT_SINGLELINE | DT_LEFT);

						/*
						** Do any outlining required by being the current focus
						*/
						if (draw->itemState & ODS_SELECTED)
						{
							DrawFocusRect(draw->hDC, (LPRECT)&draw->rcItem);
						}
         		}
         		else if (draw->itemAction == ODA_SELECT)
         		{
         			DrawFocusRect(draw->hDC, (LPRECT)&draw->rcItem);
         		}
         		
					if (oldPal != (HPALETTE)NULL)
					{
						SelectPalette(draw->hDC, oldPal, FALSE);
                  RealizePalette(draw->hDC);
					}

					ReleaseColors(dlg);
				}
			}
			break;
		}

		case WM_MEASUREITEM:
			/* Do nothing - let the default value be used */
			break;

		case WM_DESTROY:
			ClearColors(dlg);
			return TRUE;

		case WM_CTLCOLOR:
			switch (HIWORD(lParam))
			{
				case CTLCOLOR_BTN:
				case CTLCOLOR_SCROLLBAR:
				case CTLCOLOR_LISTBOX:
					break;

				case CTLCOLOR_DLG:
				case CTLCOLOR_EDIT:
				case CTLCOLOR_MSGBOX:
            case CTLCOLOR_STATIC:
					SetBkColor((HDC)wParam, RGB(192,192,192));
               SetTextColor((HDC)wParam, RGB(0,0,0));
            	return (BOOL)(HIWORD(lParam) == CTLCOLOR_DLG ? DialogBrush : GrayBrush);
			}
			break;

		case WM_INITDIALOG:
		{
			bmi = (LPBITMAPINFO)GlobalLock(DIBitmapHandle);
			if (bmi != NULL)
			{
				nColors = DIBitmapColors(bmi);
				handle = GlobalAlloc(GMEM_ZEROINIT | GMEM_MOVEABLE,
					sizeof(RGBQUAD) * nColors);
				if (handle != (HANDLE)NULL)
				{
					colors = (LPRGBQUAD)GlobalLock(handle);
					if (colors != NULL)
					{
						for (i = 0 ; i < nColors ; ++i)
						{
							colors[i] = bmi->bmiColors[i];
							SendDlgItemMessage(dlg, CLRD_RGBLIST, LB_ADDSTRING, -1,
								(LONG)i);
						}
						ok = SetColors(dlg, colors);

						if (!ok)
						{
							GlobalUnlock(handle);
						}
					}

					if (!ok)
					{
						GlobalFree(handle); 
					}
				}
				GlobalUnlock(DIBitmapHandle);
			}

			if (!ok)
			{
				ClearColors(dlg);
				EndDialog(dlg, 0);
			}
			break;
		}
	}

	return FALSE;
}

/*
**	Local functions for processing the Property list for storing the current
**	color set.
*/
static LPRGBQUAD
GetColors(HWND dlg)
{
	HANDLE		handle;
	LPRGBQUAD	colors = NULL;

	handle = GetProp(dlg, (LPSTR)Property);
	if (handle != (HANDLE)NULL)
	{
		colors = (LPRGBQUAD)GlobalLock(handle);
	}

	return colors;
}

static void
ReleaseColors(HWND dlg)
{
	HANDLE		handle;

	handle = GetProp(dlg, (LPSTR)Property);
	if (handle != (HANDLE)NULL)
	{
		GlobalUnlock(handle);
	}
}

static int
SetColors(HWND dlg, LPRGBQUAD colors)
{
	HANDLE	handle;
	int		rc = FALSE;

	handle = (HANDLE)LOWORD(GlobalHandle(FP_SEG(colors)));
	if (handle != (HANDLE)NULL)
	{
		ClearColors(dlg);
		if (SetProp(dlg, (LPSTR)Property, handle))
		{
			GlobalUnlock(handle);
			rc = TRUE;
		}
	}

	return rc;
}

static void
ClearColors(HWND dlg)
{
	HANDLE	handle;

	handle = RemoveProp(dlg, (LPSTR)Property);
	if (handle != (HANDLE)NULL)
	{
		GlobalFree(handle);
	}
}

/*
**	Modification History
**	====================
**
**	$lgb$
** 02/10/92     Larry Widing   Initial Version.
** 08/03/92     Larry Widing   
**	$lge$
*/
