/*
**	$id: ssvcid bminfo.c 1.1 11/12/91  8:38 am$
**		This file contains the information display function to let the user
**	know what is currently happening.
**
**	(C) 1991-3	Larry Widing
*/
#include	<windows.h>
#include	<string.h>
#include	<stdio.h>
#include	"bitmaps.h"
#include	"bmmanip.h"
#include	"icnfile.h"

/*
** void
** InfoDisplay(void);
**
**    This function displays a message box that lists what type of image is
**	currently loaded (icon, bitmap, nothing) and various attributes of that
**	object.
**
** Modification History:
** 09/13/91  LCW  Created
*/
void
InfoDisplay(void)
{
	char	text[500];

	text[0] = '\0';

	if (BitmapHandle != (HBITMAP)NULL)
	{
		/*
		**	Currently displaying a Windows bitmap
		*/
		BITMAP	bm;

		if (GetObject(BitmapHandle, sizeof(BITMAP), (LPSTR)&bm))
		{
			sprintf(text,
				"Windows Bitmap\n"
				"Size: %u by %u\n"
				"%u color planes\n"
				"%u bits per pixel",
				bm.bmWidth, bm.bmHeight, bm.bmPlanes, bm.bmBitsPixel);
		}
		else
		{
			strcpy(text, "Windows Bitmap\nUnable to access BITMAP structure");
		}
	}
	else if (DIBitmapHandle != (HANDLE)NULL)
	{
		/*
		**	Currently displaying a Device Independant Bitmap
		*/
		BITMAPINFO FAR	*bmi;

		bmi = (BITMAPINFO FAR *)GlobalLock(DIBitmapHandle);
		if (bmi != NULL)
		{
			if (bmi->bmiHeader.biSize == sizeof(BITMAPCOREHEADER))
			{
				BITMAPCOREINFO FAR *bci = (BITMAPCOREINFO FAR *)bmi;

				sprintf(text,
					"OS/2 Device Independant Bitmap\n"
					"Size: %u by %u\n"
					"Memory: %lu bytes\n"
					"%u color planes\n"
					"%u bits per pixel",
					bci->bmciHeader.bcWidth, bci->bmciHeader.bcHeight,
					GlobalSize(DIBitmapHandle),
					bci->bmciHeader.bcPlanes, bci->bmciHeader.bcBitCount);
			}
			else
			{
				sprintf(text,
					"Windows 3.0 Device Independant Bitmap\n"
					"Size: %lu by %lu\n"
					"Memory: %lu bytes\n"
					"%u color planes\n"
					"%u bits per pixel\n"
					"%u color entries used",
					bmi->bmiHeader.biWidth, bmi->bmiHeader.biHeight,
					GlobalSize(DIBitmapHandle),
					bmi->bmiHeader.biPlanes, bmi->bmiHeader.biBitCount,
					DIBitmapColors(bmi));

				switch (bmi->bmiHeader.biCompression)
				{
					case BI_RLE8:
						strcat(text, "\nCompressed with 8-bit Run Length Encoding");
						break;

					case BI_RLE4:
						strcat(text, "\nCompressed with 4-bit Run Length Encoding");
						break;
				}
			}
			GlobalUnlock(DIBitmapHandle);
		}
		else
		{
			strcpy(text, "Device Independant Bitmap\nUnable to lock resource");
		}
	}
	else if (IconHandle != (HICON)NULL)
	{
		/*
		**	Currently displaying a Icon
		*/
		sprintf(text,
			"Windows Icon\n"
			"Size: %u by %u\n"
			"%u colors\n"
			"%u icons in file",
			CurIcon.width, CurIcon.height, CurIcon.colorCount,
			CurIconFile.icoResourceCount);
	}

	if (text[0] != '\0')
	{
		/* Display the formatted text */
		MessageBox(MainWindow, (LPSTR)text, (LPSTR)"Bitmap Demo",
			MB_OK | MB_ICONINFORMATION | MB_TASKMODAL);
	}
}

/*
**	Modification History
**	--------------------
**	$lgb$
** 10/15/91     Larry Widing   Initial version for Win Tech Journal Article.
** 11/12/91     Larry Widing   Added memory usage to info display for DIBs.
**	$lge$
*/
