/* $change:Code cleanup, better comments.$ */
/*
**	$id: ssvcid bitmaps.c 1.3 08/03/92 10:00 am$
**		Main program for Bitmap and Icon File demo program.
**
**	(C) 1991-3 Larry Widing
*/

#include	<windows.h>
#include	<commdlg.h>
#include	<string.h>
#include	"bitmaps.h"
#include	"bmfile.h"
#include	"bmmanip.h"
#include	"bminfo.h"
#include	"icnfile.h"
#include	"colors.h"
#include	"print.h"
#include	"openfile.h"

/*
**	Global Variables
*/
HWND		MainWindow;			/* Handle to the application's main window */
HANDLE	AppInstance;		/* Handle to application's instance */
HANDLE	BwccLibrary;		/* Borland Custom Controls Library */
char		FileName[256];		/* Name of file returned by open file dialog */
HBITMAP	BitmapHandle;		/* Handle of currently loaded bitmap */
HICON		IconHandle;			/* Handle of currently loaded icon */
HDIB		DIBitmapHandle;	/* Handle of packed DI Bitmap */
HPALETTE	DibPalette;			/* Handle to palette for DI Bitmap */
int		FileSaveMode = 0;	/* 0 to save as a normal DIB, 1 for RLE, 2 for OS2 */
HBRUSH	DialogBrush;		/* background brush for dialogs */
HBRUSH	GrayBrush;			/* gray brush for control backgrounds */

const char	AppName[] = "Bitmaps";
const char	AboutDlg[] = "AboutBox";
const char	ColorDlg[] = "RgbColors";

/*
**	Local function prototypes
*/
BOOL					RegisterWindows(HANDLE, HANDLE);
BOOL					InitializeApplication(HANDLE, HANDLE *, int);
#if	defined(__TSC__)
	#pragma	save
	#pragma	call(windows=>on)
#endif
LONG FAR PASCAL EXPORT	MainWndProc(HWND, WORD, WORD, DWORD);
BOOL FAR PASCAL EXPORT	AboutBoxDialog(HWND, WORD, WORD, DWORD);
#if	defined(__TSC__)
	#pragma	restore
#endif

/*
** int PASCAL
** WinMain(
**   HANDLE AppInstance,
**   HANDLE hPrevInstance,
**   LPSTR lpCmdLine,
**   int nCmdShow);
**
**    Entry point from windows for this application.
**
** Modification History:
** 08/20/91  LCW  Created
*/
int PASCAL EXPORT
WinMain(HINSTANCE AppInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	MSG		msg;
	HANDLE	accelTable;

	/*
	**	Register main window class
	*/
	if (!RegisterWindows(AppInstance, hPrevInstance))
		return 1;

	/*
	**	Initialize main window, and application
	*/
	if (!InitializeApplication(AppInstance, &accelTable, nCmdShow))
		return 1;

	/*
	**	Force loading of BWCC DLL to register Borland Custom Control classes.
	*/
	BwccLibrary = LoadLibrary("BWCC.DLL");
	if (BwccLibrary == (HANDLE)NULL)
		return 1;

	/*
	**	Main Message Loop
	*/
	while (GetMessage((LPMSG)&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(MainWindow, accelTable, (LPMSG)&msg))
		{
			TranslateMessage((LPMSG)&msg);
			DispatchMessage((LPMSG)&msg);
		}
	}

	/*
	**	Release library and global brushes.
	*/
   FreeLibrary(BwccLibrary);
	if (DialogBrush)
		DeleteObject(DialogBrush);
	if (GrayBrush)
		DeleteObject(GrayBrush);

	return msg.wParam;
}

/*
** BOOL								// TRUE if successful, FALSE if an error occurred
** RegisterWindows(
**   HANDLE AppInstance,		// Application instance handle
**   HANDLE hPrevInstance);	// handle of previous instance of this application
**
**    Register window classes used in this application.
**
** Modification History:
** 08/20/91  LCW  Created
*/
BOOL
RegisterWindows(HANDLE AppInstance, HANDLE hPrevInstance)
{
	WNDCLASS	wclass;

	if (hPrevInstance)
		return TRUE;

	wclass.style = 0;
	wclass.lpfnWndProc = (WNDPROC)MainWndProc;
	wclass.cbClsExtra = 0;
   wclass.cbWndExtra = 0;
	wclass.hInstance = AppInstance;
	wclass.hIcon = LoadIcon(AppInstance, (LPSTR)AppName);
	wclass.hCursor = LoadCursor((HANDLE)NULL, IDC_ARROW);
	wclass.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE + 1);
	wclass.lpszMenuName = (LPSTR)AppName;
	wclass.lpszClassName = (LPSTR)AppName;

	if (!RegisterClass((LPWNDCLASS)&wclass))
	{
		char	title[64], msg[64];

		LoadString(AppInstance, IDS_ERROR_REGWNDW, (LPSTR)msg, sizeof(msg));
		LoadString(AppInstance, IDS_ERROR_TITLE, (LPSTR)title, sizeof(title));
		MessageBox((HWND)NULL, (LPSTR)msg, (LPSTR)title,
			MB_APPLMODAL | MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	return TRUE;
}

/*
** BOOL
** InitializeApplication(
**   HANDLE AppInstance,
**   HANDLE *accelTable,
**   int nCmdShow);
**
**    Initialize this application.  This involves loading the menu for the
**	main window, creating the main window, and loading the accelerator table
**	from the resource file.
**
** Modification History:
** 08/20/91  LCW  Created
*/
BOOL
InitializeApplication(HANDLE hInstance, HANDLE *accelTable, int nCmdShow)
{
	HMENU		menu;
	char		tmp[64], title[64];
	LOGBRUSH	br;
	HANDLE	resource;

	AppInstance = hInstance;

	GrayBrush = CreateSolidBrush(RGB(192,192,192));

	/*
	**	Create a dithered brush to emulate the Borland Dialog look.
	*/
	resource = FindResource(AppInstance, MAKEINTRESOURCE(1), RT_BITMAP);
	if (resource != (HANDLE)NULL)
	{
		br.lbStyle = BS_DIBPATTERN;
		br.lbColor = 0;
		br.lbHatch = (int)LoadResource(AppInstance, resource);
      LockResource((HANDLE)br.lbHatch);
		DialogBrush = CreateBrushIndirect(&br);

		UnlockResource((HANDLE)br.lbHatch);
      FreeResource((HANDLE)br.lbHatch);
	}

	/*
	**	Load application menu
	*/
	menu = LoadMenu(AppInstance, (LPSTR)AppName);

	/*
	**	Create the main window
	*/
	LoadString(AppInstance, IDS_MAIN_TITLE, (LPSTR)title, sizeof(title)); 
	MainWindow = CreateWindow((LPSTR)AppName, (LPSTR)title,
		WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, (HWND)NULL, menu, AppInstance, (LPSTR)NULL);

	if (MainWindow == (HWND)NULL)
	{
		LoadString(AppInstance, IDS_ERROR_OPENWNDW, (LPSTR)tmp, sizeof(tmp));
      LoadString(AppInstance, IDS_ERROR_TITLE, (LPSTR)title, sizeof(title));
		MessageBox((HWND)NULL, (LPSTR)tmp, (LPSTR)title,
			MB_APPLMODAL | MB_OK | MB_ICONSTOP);
		return FALSE;
	}

	ShowWindow(MainWindow, nCmdShow);
	*accelTable = LoadAccelerators(AppInstance, (LPSTR)AppName);

	BitmapHandle = (HBITMAP)NULL;
	IconHandle = (HICON)NULL;

	return TRUE;
}

/*
** void
** ClearHandles(void);
**
**    Delete any valid bitmap and/or icon handles.
**
** Modification History:
** 07/21/92  LCW  Created
*/
void
ClearHandles(void)
{
	if (DIBitmapHandle != (HANDLE)NULL)
	{
		if (DibPalette != (HPALETTE)NULL)
		{
			DeleteObject(DibPalette);
			DibPalette = (HPALETTE)NULL;
		}
		GlobalFree(DIBitmapHandle);
		DIBitmapHandle = (HANDLE)NULL;
	}

	if (BitmapHandle != (HBITMAP)NULL)
	{
		DeleteObject(BitmapHandle);
		BitmapHandle = (HBITMAP)NULL;
	}

	if (IconHandle != (HICON)NULL)
	{
		DestroyIcon(IconHandle);
		IconHandle = (HICON)NULL;
	}
}

/*
** LONG FAR PASCAL
** MainWndProc(
**   HWND wnd,				Handle of window
**   WORD message,		Message received from Windows
**   WORD wParam,			word parameter
**   DWORD lParam);		long parameter
**
**    Handle messages from the main window.
**
** Modification History:
** 09/06/91  LCW  Created
**	07/21/92  lcw	Modified to take advantage of the Common Dialog Functions of Windows 3.1
*/
LONG FAR PASCAL EXPORT
MainWndProc(HWND wnd, WORD message, WORD wParam, DWORD lParam)
{
	DLGPROC	pfn;
	HANDLE	handle;

	switch (message)
	{
		case WM_COMMAND:
			switch (wParam)
			{
				case IDM_FILE_OPEN:
					OpenImageFile(wnd);
               break;

				case IDM_FILE_SAVE:
					SaveImageFile(wnd);
					break;

				case IDM_FILE_EXIT:
					DestroyWindow(wnd);
					break;

				case IDM_FILE_ABOUT:
					pfn = (DLGPROC)MakeProcInstance((FARPROC)AboutBoxDialog, AppInstance);
					if (pfn != (DLGPROC)NULL)
					{
						DialogBox(AppInstance, (LPCSTR)AboutDlg, wnd, pfn);
						FreeProcInstance((FARPROC)pfn);
					}
					break;

				case IDM_EDIT_COPY:
					if (OpenClipboard(wnd))
					{
						int	fmt = 0;

						handle = (HANDLE)NULL;

						if (DIBitmapHandle != (HANDLE)NULL)
						{
							handle = CopyDIBitmap(DIBitmapHandle);
							fmt = CF_DIB;
						}
						else if (BitmapHandle != (HBITMAP)NULL)
						{
							handle = CopyBitmap(BitmapHandle);
							fmt = CF_BITMAP;
						}

						if (handle != (HANDLE)NULL)
						{
							EmptyClipboard();
							SetClipboardData(fmt, handle);
						}
						CloseClipboard();
					}
					break;

				case IDM_EDIT_PASTE:
					if (OpenClipboard(wnd))
					{
						HANDLE	handle;
						int		fmt = 0, fbmp = FALSE, fdib = FALSE;

						while ((fmt = EnumClipboardFormats(fmt)) != 0)
						{
							if (fmt == CF_BITMAP)
							{
								fbmp = TRUE;
							}
							if (fmt == CF_DIB)
							{
								fdib = TRUE;
							}
						}
						if (fdib)
						{
							fmt = CF_DIB;
						}
						else if (fbmp)
						{
							fmt = CF_BITMAP;
						}

						if (fmt != 0)
						{
							handle = GetClipboardData(fmt);
							if (fmt == CF_BITMAP)
							{
								HBITMAP	hbm;

								hbm = CopyBitmap(handle);
								if (hbm != (HBITMAP)NULL)
								{
									ClearHandles();
									BitmapHandle = hbm;
									InvalidateRect(wnd, NULL, TRUE);
								}
							}
							else if (fmt == CF_DIB)
							{
								HANDLE	hbm;

								hbm = CopyDIBitmap(handle);
								if (hbm != (HANDLE)NULL)
								{
									ClearHandles();
									DIBitmapHandle = hbm;

									handle = CreateDibPalette(DIBitmapHandle);
									if (handle != (HPALETTE)NULL)
									{
										DibPalette = handle;
									}
									InvalidateRect(wnd, NULL, TRUE);
								}
							}
						}

						CloseClipboard();
					}
					break;

				case IDM_INFO_ABOUT:
					InfoDisplay();
					break;

				case IDM_FILE_PRINT:
            	PrintImage(wnd, FALSE);
					break;

				case IDM_FILE_PRSETUP:
            	PrintImage(wnd, TRUE);
					break;

				case IDM_CONVERT_LOGICAL:
					handle = DibToBitmap(DIBitmapHandle);
					if (handle)
					{
						ClearHandles();
						BitmapHandle = handle;
						InvalidateRect(wnd, NULL, TRUE);
					}
					break;

				case IDM_CONVERT_DIB:
					if (BitmapHandle)
					{
						handle = BitmapToDIB(BitmapHandle, 0);
					}
					else
					{
						HBITMAP	hbm = DibToBitmap(DIBitmapHandle);

						if (hbm)
						{
							handle = BitmapToDIB(hbm, 0);
							DeleteObject(hbm);
						}
					}
					if (handle)
					{
						ClearHandles();
						DIBitmapHandle = handle;

						handle = CreateDibPalette(DIBitmapHandle);
						if (handle != (HPALETTE)NULL)
						{
							DibPalette = handle;
						}
						InvalidateRect(wnd, NULL, TRUE);
					}
					break;

				case IDM_CONVERT_RLE:
					if (BitmapHandle)
					{
						handle = BitmapToDIB(BitmapHandle, 1);
					}
					else
					{
						HBITMAP	hbm = DibToBitmap(DIBitmapHandle);

						if (hbm)
						{
							handle = BitmapToDIB(hbm, 1);
							DeleteObject(hbm);
						}
					}
					if (handle)
					{
						ClearHandles();
						DIBitmapHandle = handle;

						handle = CreateDibPalette(DIBitmapHandle);
						if (handle != (HPALETTE)NULL)
						{
							DibPalette = handle;
						}
						InvalidateRect(wnd, NULL, TRUE);
					}
					break;

				case IDM_CONVERT_OS2:
					if (BitmapHandle)
					{
						handle = BitmapToDIB(BitmapHandle, 2);
					}
					else
					{
						HBITMAP	hbm = DibToBitmap(DIBitmapHandle);

						if (hbm)
						{
							handle = BitmapToDIB(hbm, 2);
							DeleteObject(hbm);
						}
					}
					if (handle)
					{
						ClearHandles();
						DIBitmapHandle = handle;

						handle = CreateDibPalette(DIBitmapHandle);
						if (handle != (HPALETTE)NULL)
						{
							DibPalette = handle;
						}
						InvalidateRect(wnd, NULL, TRUE);
					}
					break;

				case IDM_CONVERT_COLORMAP:
//					if (DIBitmapHandle && !DibIsOs2(DIBitmapHandle))
					{
						DLGPROC	proc;

						proc = (DLGPROC)MakeProcInstance((FARPROC)ColorMapDialog, AppInstance);
						if (proc != (DLGPROC)NULL)
						{
							if (DialogBox(AppInstance, (LPCSTR)ColorDlg, wnd, proc))
							{
								/*
								**	Force a redraw of the image
								*/
								InvalidateRect(wnd, NULL, FALSE);
							}
							FreeProcInstance((FARPROC)proc);
						}
					}
					break;
			}
			break;

		case WM_PAINT:
		{
			HDC			hdc;
			PAINTSTRUCT	ps;

			hdc = BeginPaint(wnd, (LPPAINTSTRUCT)&ps);

			/*
			**	Draw the current bitmap or icon, if either one is loaded
			*/
			if (DIBitmapHandle != (HANDLE)NULL)
			{
				DrawDIBitmap(hdc, 0, 0, DIBitmapHandle, DibPalette);
			}
			else if (BitmapHandle != (HBITMAP)NULL)
			{
				DrawBitmap(hdc, 0, 0, BitmapHandle);
			}
			else if (IconHandle != (HICON)NULL)
			{
				DrawIcon(hdc, 0, 0, IconHandle);
			}

			EndPaint(wnd, (LPPAINTSTRUCT)&ps);
			break;
		}

		case WM_INITMENUPOPUP:
			if (HIWORD(lParam) == 0)
			{
				switch (LOWORD(lParam))
				{
					case 0:	/* File Menu */
						/*
						**	Enable bitmap saving and printing only if a bitmap is loaded
						*/
						if (BitmapHandle != (HBITMAP)NULL || DIBitmapHandle != (HANDLE)NULL)
						{
							EnableMenuItem((HMENU)wParam, IDM_FILE_SAVE, MF_ENABLED);
                     EnableMenuItem((HMENU)wParam, IDM_FILE_PRINT, MF_ENABLED);
						}
						else
						{
							EnableMenuItem((HMENU)wParam, IDM_FILE_SAVE, MF_GRAYED);
							EnableMenuItem((HMENU)wParam, IDM_FILE_PRINT, MF_GRAYED);
						}
						break;

					case 1:	/* Edit menu */
						/*
						**	Enable copy menu item if we have a bitmap to copy
						*/
						if (BitmapHandle != (HBITMAP)NULL
							|| DIBitmapHandle != (HANDLE)NULL)
						{
							EnableMenuItem((HMENU)wParam, IDM_EDIT_COPY, MF_ENABLED);
						}
						else
						{
							EnableMenuItem((HMENU)wParam, IDM_EDIT_COPY, MF_GRAYED);
						}

						/*
						**	Enable paste menu item if the clipboard has a bitmap to paste
						*/
						EnableMenuItem((HMENU)wParam, IDM_EDIT_PASTE, MF_GRAYED);
						if (OpenClipboard(MainWindow))
						{
							int	fmt = 0;

							while ((fmt = EnumClipboardFormats(fmt)) != 0)
							{
								if (fmt == CF_BITMAP || fmt == CF_DIB)
								{
									break;
								}
							}
							if (fmt != 0)
							{
								EnableMenuItem((HMENU)wParam, IDM_EDIT_PASTE, MF_ENABLED);
							}
							CloseClipboard();
						}
						break;

					case 2:	/* Information Menu */
						break;

					case 3:	/* Conversion Menu */
					{
						int	logical, dib, rle, os2;

						logical = dib = rle = os2 = MF_ENABLED;

						if (IconHandle)
						{
							logical = dib = rle = os2 = MF_GRAYED;
						}
						else if (BitmapHandle)
						{
							logical = MF_GRAYED;
						}
						else if (DIBitmapHandle)
						{
							if (DibIsOs2(DIBitmapHandle))
							{
								os2 = MF_GRAYED;
							}
							else if (DibIsCompressed(DIBitmapHandle))
							{
								rle = MF_GRAYED;
							}
							else
							{
								dib = MF_GRAYED;
							}
						}
						else
						{
							logical = dib = rle = os2 = MF_GRAYED;
						}

						EnableMenuItem((HMENU)wParam, IDM_CONVERT_LOGICAL, logical);
						EnableMenuItem((HMENU)wParam, IDM_CONVERT_DIB, dib);
						EnableMenuItem((HMENU)wParam, IDM_CONVERT_RLE, rle);
						EnableMenuItem((HMENU)wParam, IDM_CONVERT_OS2, os2);
						EnableMenuItem((HMENU)wParam, IDM_CONVERT_COLORMAP,
							(rle == MF_GRAYED || dib == MF_GRAYED) ? MF_ENABLED : MF_GRAYED);
						break;
					}
				}
			}
			break;

		case WM_DESTROY:
			ClearHandles();
			PostQuitMessage(0);
			break;

		default:
			return DefWindowProc(wnd, message, wParam, lParam);
	}

	return FALSE;
}

/*
** BOOL FAR PASCAL
** AboutBoxDialog(
**   HWND dlg,				Handle of dialog
**   WORD message,		Message received from Windows
**   WORD wParam,			word parameter
**   DWORD lParam);		long parameter
**
**    Handle the events related to the About Box.
**
** Modification History:
** 09/06/91  LCW  Created
*/
BOOL FAR PASCAL EXPORT
AboutBoxDialog(HWND dlg, WORD message, WORD wParam, DWORD lParam)
{
	switch (message)
	{
		case WM_COMMAND:
			switch (wParam)
			{
				case IDOK:
					EndDialog(dlg, 0);
					return TRUE;
			}
			break;

		case WM_CTLCOLOR:
			switch (HIWORD(lParam))
			{
				case CTLCOLOR_BTN:
				case CTLCOLOR_SCROLLBAR:
				case CTLCOLOR_LISTBOX:
					break;

				case CTLCOLOR_DLG:
				case CTLCOLOR_EDIT:
				case CTLCOLOR_MSGBOX:
            case CTLCOLOR_STATIC:
					SetBkColor((HDC)wParam, RGB(192,192,192));
               SetTextColor((HDC)wParam, RGB(0,0,0));
            	return (BOOL)(HIWORD(lParam) == CTLCOLOR_DLG ? DialogBrush : GrayBrush);
			}
			break;
	}

	return FALSE;
}

/*
** void
** ErrorBox(char *msg);		pointer to message to be displayed
**
**    This function displays a simple error message in a Windows message box
**	to inform the user of a problem.
**
** Modification History:
** 09/06/91  LCW  Created
*/
void
ErrorBox(char *msg)
{
	MessageBox(MainWindow, (LPSTR)msg, (LPSTR)AppName,
		MB_OK | MB_ICONSTOP | MB_TASKMODAL);
}

/*
**	Modification History
**	--------------------
**	$lgb$
** 10/15/91     Larry Widing   Initial version for Win Tech Journal Article.
** 11/12/91     Larry Widing   Added support for bitmap conversion.
** 02/10/92     Larry Widing   Added support for color alteration of the
**                             bitmap.
** 08/03/92     Larry Widing   Second upload to CompuServe.
**	$lge$
*/
