/* READINI.C */

#include <windows.h>
#include "paint.h"
#include "readini.h"
#include "str.h"

static int Handle = -1;  /* file handle */

/* read next char from *.INI file */

static int ReadNextChar(int Handle)
{int  Code;
 static char TheChar;
 Code = _lread(Handle, (LPSTR) &TheChar, 1);
 if(Code<=0) return -1;
 /* skip CRs */
 if(TheChar=='\r')
   {Code = _lread(Handle, (LPSTR) &TheChar, 1);
    if(Code<=0) return -1;
   }
 /* return EOL in lieu of LF */
 if(TheChar=='\n') return '\0';
 return (int) TheChar;
}

/* extract sub-string */

int IniExtract(LPSTR StringPtr, LPSTR KeyWordPtr, LPSTR ValuePtr)
{if(StringPtr[4] != '=') return FALSE;
 StringPtr[4] = '\0';
#if 0
     {char Temp[80];
      wsprintf((LPSTR)Temp,"<%s|%s>",StringPtr,KeyWordPtr);
      DisplayLine((LPSTR)Temp);
     }
#endif
 if(lstrcmpi(StringPtr,KeyWordPtr)==0)
   {lstrcpy((LPSTR)ValuePtr,(LPSTR) &StringPtr[5]);
#if 0
      {char Temp[80];
       wsprintf((LPSTR)Temp,"<%s>",ValuePtr);
       DisplayLine((LPSTR)Temp);
      }
#endif
    return TRUE;
   }
 StringPtr[4] = '=';
 return FALSE;
}

/* open *.INI file */

int IniOpen(LPSTR Filename)
{/* read FROM.INI file */
 Handle = _lopen(Filename, OF_READ|OF_SHARE_DENY_WRITE);
 if(Handle<0)
   {DisplayString("Cannot open ");
    DisplayLine((LPSTR) Filename);
    return FALSE;
   }
 return TRUE;
}

/* read next line from *.INI file */

int IniRead(LPSTR Buffer)
{int Code;
 int Count = 0;
 if(Handle==-1) return -1;
 /* extract each field */
 while(1)
   {Code = ReadNextChar(Handle);
    if(Code<0)
      {_lclose(Handle);
       Handle = -1;
       return -1;
      }
    /* add char to buffer */
    Buffer[Count++] = (char) Code;
    if((char)Code=='\0') return Count;
   }
}
