#include <io.h>
#include <stdio.h>

/*

   WhatIs by David S.P. 1995  -*- Public Domain -*-

   First arg in the command line is the filename/filepath to test

   Returned errorlevels:

   0  Cannot identify file
   1  Exe file                128 Exe file (maybe an SFX or compressed Exe)
   2  Rar                     129 Rar SFX
   3  Zip                     130 Zip SFX
   4  Arj                     131 Arj SFX
   5  Uc2                     132 Uc2 SFX
   6  Lzh/Lha/Ice             133 Lzh/Lha/Ice SFX

*/

typedef struct { char *Id, Len; } Types;

typedef struct { unsigned bytes,pages,items,head,min,max,
			  ss,sp,check,ip,cs,reloc,over;   } exe_head;

/* You can add as many archive formats as you want, but remember:

   - Signatures must be as large as possible beacuse short
     signatures (like the ones for Arj or Lzh) may be found
     in other files that are not archives.

   - Exe file must be the first format to search

   - Redefine TYPES and BUFFER to proper values

*/

char ExeId[]={ 'M', 'Z' },
     RarId[]={ 'R', 'a', 'r', '!', 0x1a, 0x07, 0x00 },
     ZipId[]={ 'P', 'K', 0x03, 0x04, },
     ArjId[]={ 0x60, 0xEA },
     Uc2Id[]={ 'U', 'C', '2', 0x1a },
     LzhId[]={ '-', 'l' };

Types Search[]={ { ExeId, 2 }, { RarId, 7 }, { ZipId, 4 },
		 { ArjId, 2 }, { Uc2Id, 4 }, { LzhId, 2 }   };

#define TYPES  6  // Number of formats
#define BUFFER 7  // Must be max value of Search.Len

int search_id ( FILE *fp )

{

char buffer[BUFFER],*p1,*p2;
register int a,c=1;

if (fread(buffer,1,BUFFER,fp)!=BUFFER) return -1;

for (a=0;a<TYPES,c;a++)
    { c=Search[a].Len;
      p1=Search[a].Id;
      p2=buffer;
      while (c && *p1==*p2) { p1++; p2++; c--; }
    }

return ((a==TYPES)?-1:a);

}

int exe_file ( FILE *fp )

{

int ret,try=200;
long size,total;
exe_head info;

fseek(fp,0,SEEK_SET);
fread(&info,1,sizeof(exe_head),fp);
size=(long)info.bytes-512L+(512L*(long)info.pages);
total=filelength(fileno(fp));

if (total<=size) return 1;

do { fseek(fp,size-1,SEEK_SET);
     size++;
     if ((ret=search_id(fp))!=-1) return (127+ret);
   } while (--try);

return (128);

}

int main ( int argc, char **argv )

{

FILE *fp;
int ret;

if (argc!=2) return 0;

if ((fp=fopen(argv[1],"rb"))==NULL) return 0;

if ((ret=search_id(fp))==1) ret=exe_file(fp);

fclose(fp);
return(ret);

}