
/* **************************************************************
 *
 *
 *      C W   :    P r o c  d u r e s
 * 
 *
 * **************************************************************** */


#include <windows.h>

#include "wftp.h"

int Ecris(const char *szFormat,...);


/* **************************************************************
 *    I n d i c a t e u r    D ' a v a n c e m e n t 
 *             P a r    Santanu Lahiri (winFTP)
 * **************************************************************/


extern HINSTANCE       hInst;             
static bRecv = FALSE;
static DWORD lFileSize=0;
static LONG lTotalBytes=0, lXferBytes=0;
static int  nPercentXfer;
static HWND hWndXfer=NULL;
static LPSTR szXferWnd = "XferWindow";


HPEN hPenDark;
HPEN hPenLight;
HBRUSH  hbrGray1;
int  nWndx=10;                // the x axis multiplier
int  nWndy=15;                // the y axis multiplier

LRESULT CALLBACK WndXferProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);


int nCwUnregisterClasses(void)
{
  UnregisterClass (szXferWnd, hInst);
return 0;
}


int nCwRegisterClasses(void)
{
WNDCLASS   wc;    // struct to define a window class

  hbrGray1 = CreateSolidBrush (RGB (192,192,192));
  memset(&wc, 0x00, sizeof(wc));
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInst;
  wc.hCursor = LoadCursor ((HINSTANCE) NULL, IDC_ARROW);
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = WndXferProc;
  wc.hIcon         = LoadIcon (hInst, IDI_APPLICATION);
  wc.hbrBackground = hbrGray1;
  wc.lpszMenuName  = NULL;      /* Menu Name is App Name */
  wc.lpszClassName = szXferWnd; /* Class Name is App Name */
  if (RegisterClass (&wc)==0) return -1;
return 0;
}


void CreateButtonPens()
{
  hPenDark  = CreatePen (PS_SOLID, 1, RGB (128,128,128));
  hPenLight = CreatePen (PS_SOLID, 1, RGB (224,224,224));
}

void DeleteButtonPens()
{
  DeleteObject (hPenDark);
  DeleteObject (hPenLight);
}


void BoxIt (HDC hDC, int left, int top, int width, int height, BOOL flag)
{
  POINT Pt;
  HPEN hPenOld;
  
  hPenOld = SelectObject (hDC, flag? hPenDark : hPenLight);
  MoveToEx (hDC, (left*nWndx)/4, ((top+height)*nWndy)/8, &Pt);
  LineTo (hDC, (left*nWndx)/4, (top*nWndy)/8);
  LineTo (hDC, ((left+width)*nWndx)/4, (top*nWndy)/8);
  if (flag) SelectObject (hDC,hPenLight); 
  else SelectObject (hDC,hPenDark);
  LineTo (hDC, ((left+width)*nWndx)/4, ((top+height)*nWndy)/8);
  LineTo (hDC, (left*nWndx)/4, ((top+height)*nWndy)/8);
  SelectObject (hDC, hPenOld);
}


void PaintXfer (HDC hDC)
{
  RECT rc;
  char szBuf[10];

  CreateButtonPens();
  SelectObject (hDC, GetStockObject (WHITE_BRUSH));
  Rectangle (hDC, (nWndx*20)/4, (nWndy*10)/8, (nWndx*122)/4, (nWndy*20)/8);
  rc.left = (nWndx*21)/4;  rc.right = (nWndx*(nPercentXfer+21))/4;
  rc.top  = (nWndy*11)/8;  rc.bottom= (nWndy*19)/8;
  FillRect (hDC, &rc, GetStockObject (GRAY_BRUSH));
  rc.right = (nWndx*121)/4;
  SetBkMode (hDC, TRANSPARENT);
  wsprintf (szBuf, "%d%%", nPercentXfer);
  DrawText (hDC, szBuf, lstrlen (szBuf), &rc, DT_CENTER | DT_VCENTER);
  SetBkMode (hDC, OPAQUE);
  BoxIt (hDC, 18, 8, 106, 14, FALSE);
  DeleteButtonPens();
}



void OnPaintXfer (HWND hWnd)
{
  HDC hDC;
  PAINTSTRUCT ps;
  
  hDC = BeginPaint (hWnd, &ps);
  PaintXfer (hDC);
  EndPaint (hWnd, &ps);
}

void SetXmitBytes (LONG lBytes)
{
  int nOld;
  
  lXferBytes = lBytes;
  if ((lTotalBytes==0)||(hWndXfer==NULL)) return;
  nOld = nPercentXfer;
  nPercentXfer = (int) ((lBytes*100)/lTotalBytes);
  if (nOld!=nPercentXfer) 
  {
    HDC hDC;
  
    hDC = GetDC (hWndXfer);
    PaintXfer (hDC);
    ReleaseDC (hWndXfer, hDC);
  }
}



LRESULT CALLBACK WndXferProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  switch (Msg)
  {
    case WM_GETMINMAXINFO: 
    {
      MINMAXINFO FAR *lpmmi=(MINMAXINFO FAR *) lParam;
      lpmmi->ptMaxSize.x = (nWndx*140)/4;
      lpmmi->ptMaxSize.y = (nWndy*45)/8;
      lpmmi->ptMaxTrackSize.x = (nWndx*140)/4;
      lpmmi->ptMaxTrackSize.y = (nWndy*45)/8;
      lpmmi->ptMinTrackSize.x = (nWndx*140)/4;
      lpmmi->ptMinTrackSize.y = (nWndy*45)/8;
    } break;
    case WM_PAINT: OnPaintXfer (hWnd); return 0L;
  }
  return (LRESULT) DefWindowProc (hWnd, Msg, wParam, lParam);
}

void CreateXferWindow()
{
  if (hWndXfer!=NULL) return;
  hWndXfer = CreateWindowEx ( WS_EX_TOPMOST, 
       szXferWnd, "",  WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_CAPTION,
       CW_USEDEFAULT, CW_USEDEFAULT, (nWndx*140)/4, (nWndy*40)/8, (HWND) NULL, 
       (HMENU) NULL, hInst,  NULL);
  if (hWndXfer==NULL) MessageBeep (65535u);
  lTotalBytes = 0L;
  lXferBytes  = 0L;
  nPercentXfer = 0L;
}


void DeleteXferWindow()
{
  if (hWndXfer==NULL) return;
  DestroyWindow (hWndXfer);
  lTotalBytes  = lXferBytes = 0l;
  nPercentXfer = 0;
  hWndXfer = NULL;
}

void SetXferWindowText (LPSTR lpStr)
{
  SetWindowText (hWndXfer, lpStr);
}


/* **************************************************************
 *    P r o c  d u r e s    
 * **************************************************************/


int PASCAL FAR  DLL_Work (HWND hParent, UINT Msg)
{
    FtpInit (hParent);
    FtpSetVerboseMode (TRUE, hParent, WM_USER+112);
    FtpLogin (HOST, USERID, PASSWD, hParent, Msg);
return 0;
}


int PASCAL FAR  DLL_Dir (HWND hParent, BOOL First, UINT Msg)
{ 
   if (First)
    {
       FtpCWD (".");
       FtpDir ("/tmp/dir/l*", "\\Z", TRUE, hParent, Msg);
    }
   else 
    {
       FtpCWD ("/");
       FtpDir ("", NULL, FALSE, hParent, Msg);
    }
return 0;
}

int PASCAL FAR  DLL_FT (HWND hParent, BOOL First, UINT Msg)
{ 
   if (First)
     { 
       bRecv = TRUE;
       FtpRecvFile ("/tmp/big.txt", "\\tmp\\big.txt", TYPE_I, TRUE, hParent, Msg);
     }
   else
       FtpSendFile ("\\tmp\\ftp.lst", "/users/Ark/tmp/ftp.lst", TYPE_A, FALSE, hParent, Msg);
 
   Ecris (First ? "Rception  big.txt" : "Envoi  ftp.lst");
   if (bRecv)
     {
       lFileSize = FtpGetFileSize ();
       if (lFileSize!=0) Ecris ("Taille fichier %ld", lFileSize);
       CreateXferWindow ();
       SetXferWindowText ("/tmp/big.txt");
       lTotalBytes = lFileSize;
       Ecris ("Reponse : [%s]", FtpDataPtr ()->ftp.szInBuf);
     }
return 0;
} 


int PASCAL FAR  DLL_End ()
{
    FtpCloseConnection ();
    FtpRelease ();
return 0;
}

