// wdjsrvc.c

#include <windows.h>

HANDLE  hDoneEvent = NULL, hThread = NULL;
DWORD   dwCurrentState;
SERVICE_STATUS_HANDLE  hService;

BOOL StartedAsService(LPSERVICE_TABLE_ENTRY);
BOOL NotifySCM(DWORD, DWORD, DWORD);
VOID WINAPI ServiceMain(DWORD, LPTSTR *);
VOID WINAPI ServiceHandler(DWORD);
DWORD WINAPI WorkerThread(LPVOID);


//-----------------------------------------------------------------
void main(void)
{
    DWORD ThreadId;
    SERVICE_TABLE_ENTRY ServiceTable[] = {
        {TEXT("WDJSrvc"), ServiceMain}, {NULL, NULL}
    };

    if (!StartedAsService(ServiceTable)) {
        // Didn't start as a service, run as a normal process
        hThread = CreateThread(0,0,WorkerThread,0,0,&ThreadId);
        if (hThread != NULL) {
            WaitForSingleObject(hThread, INFINITE);
        }
    }
}

//-----------------------------------------------------------------
VOID WINAPI ServiceMain(DWORD dwArgc, LPTSTR *lpszArgv)
{
   DWORD   ThreadId;

   if (!(hService = RegisterServiceCtrlHandler(
                        TEXT("WDJSrvc"), ServiceHandler)))
      return;

   NotifySCM(SERVICE_START_PENDING, 0, 1);

   if (!(hDoneEvent = CreateEvent(NULL, FALSE, FALSE, NULL)))
      return;

   if (!(hThread = CreateThread(0,0,WorkerThread,0,0,&ThreadId))) {
      CloseHandle(hDoneEvent);
      return;
   }

   NotifySCM(SERVICE_RUNNING, 0, 0);
   WaitForSingleObject(hDoneEvent, INFINITE);

   CloseHandle(hThread);
   CloseHandle(hDoneEvent);
   return;
}

//-----------------------------------------------------------------
VOID WINAPI ServiceHandler(DWORD fdwControl)
{
    // this service doesn't support pause-continue
    switch(fdwControl) {
        case SERVICE_CONTROL_STOP:
            NotifySCM(SERVICE_STOP_PENDING, 0, 1);
            SetEvent(hDoneEvent);
            NotifySCM(SERVICE_STOPPED, 0, 0);
            break;

        case SERVICE_CONTROL_INTERROGATE:
            NotifySCM(dwCurrentState, 0, 0);
            break;

        default:
            break;
    }
}

//-----------------------------------------------------------------
BOOL NotifySCM(DWORD State, DWORD ExitCode, DWORD Progress)
{
   SERVICE_STATUS ServiceStatus;

   ServiceStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
   ServiceStatus.dwCurrentState = dwCurrentState = State;
   ServiceStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP;
   ServiceStatus.dwWin32ExitCode = ExitCode;
   ServiceStatus.dwServiceSpecificExitCode = 0;
   ServiceStatus.dwCheckPoint = Progress;
   ServiceStatus.dwWaitHint = 5000;

   return SetServiceStatus(hService, &ServiceStatus);
}

//-----------------------------------------------------------------
DWORD WINAPI WorkerThread(LPVOID ThreadParam)
{
   while (TRUE) {
      Sleep(10000);
      MessageBeep(0);
   }
   return TRUE;
}

