// startsrv.c

#include "windows.h"

BOOL StartedAsService(LPSERVICE_TABLE_ENTRY ServiceTable)
{
    OSVERSIONINFO OsVerInfo;

    OsVerInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
    GetVersionEx(&OsVerInfo);
    if (OsVerInfo.dwPlatformId != VER_PLATFORM_WIN32_NT) {
        return FALSE;   // not NT - not started by SCM
    }

    // Attempt to connect to  the service control manager
    if (!StartServiceCtrlDispatcher(ServiceTable)) {
        if (GetLastError() ==
                ERROR_FAILED_SERVICE_CONTROLLER_CONNECT) {
            return FALSE;   // not started by SCM
        }
    }

    return TRUE;

} // IsStartedAsService


