#include "w16defs.h"
#include "w16ext.h"
#include <string.h>

#define APP_CLASS   "w16ext_class"
#define APP_NAME    "Win16 features"
#define APP_ABOUT   "How to inherit some special features " \
    "from Windows 95\nby Dino Esposito"
#define APP_HELPFILE "w16ext.hlp"

HANDLE happInst;       /* instance of the application   */
HWND   hwndMain;       /* handle of the main window     */

/* GetScreenRect() - obtain rectangle that covers screen.
 *
 * This function takes into account the size of the task tray.
 */
int GetScreenRect(RECT* Rect)
    {
    HWND    TaskTray;
    RECT    Screen = {0, 0, 0, 0};
    RECT    Available;
    Screen.right    = GetSystemMetrics(SM_CXSCREEN);
    Screen.bottom   = GetSystemMetrics(SM_CYSCREEN);
    Available       = Screen;
    TaskTray = FindWindow("Shell_TrayWnd", NULL);
    if(TaskTray != 0)
        {
        RECT TrayRect;
        GetWindowRect(TaskTray, &TrayRect);
        SubtractRect(&Available, &Screen, &TrayRect);
        }
    *Rect   = Available;
    return TRUE;
    }

// Module Private Functions
void MPF_OnContextMenu( WPARAM wParam, LPARAM lParam )
{
    HMENU hmenu = LoadMenu( happInst, "APP_CONTEXTMENU" );
    hmenu = GetSubMenu(hmenu,0);
    TrackPopupMenu( hmenu, TPM_LEFTALIGN, LOWORD(lParam),
        HIWORD(lParam), 0, (HWND)wParam, NULL );
    DestroyMenu( hmenu );
}

void MPF_OnDisplayChange( WPARAM wParam, LPARAM lParam )
{
    char szMsg[128];
    wsprintf( szMsg, "The display size is now changed to %d x %d x %d", LOWORD(lParam), HIWORD(lParam), wParam );
    MessageBox( hwndMain, szMsg, APP_NAME, MB_OK );
}

DWORD MPF_GetHelpTopic( UINT uiID )
{
    switch( uiID )
    {
        case IDOK: return 4;
        case IDC_TEXT: return 3;
        case IDI_ICON: return 2;
    }
   return 0;
}
LRESULT CALLBACK __export AppDlgProc( HWND hDlg, UINT uiMsg,
        WPARAM wParam, LPARAM lParam )
{
    static int siHelp=0;

    switch( uiMsg )
        {
        case WM_INITDIALOG:
            SetWindowLong( hDlg, GWL_EXSTYLE, GetWindowLong( hDlg, GWL_EXSTYLE )|WS_EX_CLIENTEDGE|WS_EX_CONTEXTHELP);
            SetWindowLong( hDlg, GWL_STYLE, GetWindowLong( hDlg, GWL_STYLE )|DS_3DLOOK );
            SetWindowPos( hDlg, GetParent(hDlg), 0,0,0,0,SWP_DRAWFRAME|SWP_NOSIZE|SWP_NOMOVE );
            SetFocus( hDlg );
            break;
        case WM_SYSCOMMAND:
            siHelp = (wParam==SC_CONTEXTHELP);
            DefWindowProc( hDlg, uiMsg, wParam, lParam );
            siHelp=0;
            return 1;
        case WM_HELP:
            if( siHelp )
                {
                LPHELPINFO lphi = (LPHELPINFO)lParam;
                WinHelp( hDlg, APP_HELPFILE, HELP_CONTEXTPOPUP,
                    MPF_GetHelpTopic((UINT)lphi->hItemHandle) );
                }
            else
                WinHelp( hDlg, APP_HELPFILE, HELP_CONTEXT, 5 );
            return 1;
        default:
            if( uiMsg==WM_COMMAND )
                EndDialog( hDlg, TRUE );
        }
    return 0L;
}


LRESULT CALLBACK __export AppWndProc( HWND hwnd, UINT uiMsg,
        WPARAM wParam, LPARAM lParam )
{
    switch( uiMsg )
        {
        case WM_COMMAND:
        switch( wParam )
            {
            case IDM_FILEDIALOG:
                return DialogBox( happInst, "DLG_TEST", hwnd,
                    (DLGPROC)AppDlgProc );
            case IDM_FILEEXIT:
                SendMessage( hwndMain, WM_CLOSE, 0, 0L );
                break;
            case IDM_HELPABOUT:
                MessageBox( hwndMain, APP_ABOUT, APP_NAME, MB_ICONINFORMATION|MB_OK );
                break;
            }
            break;
        case WM_LBUTTONDBLCLK:
            {
            RECT    Available;
            GetScreenRect(&Available);
            MoveWindow(hwndMain, Available.left, Available.top,
                Available.right-Available.left,
                Available.bottom-Available.top, TRUE);
            }
            break;
        case WM_HELP:
            WinHelp( hwndMain, APP_HELPFILE, HELP_CONTENTS, 0 );
            break;
        case WM_CONTEXTMENU:
            MPF_OnContextMenu(wParam, lParam);
            break;
        case WM_DEVICECHANGE:
            MessageBox( hwndMain, "Received a WM_DEVICECHANGE "
                "message", APP_NAME, MB_OK );
            break;
        case WM_DISPLAYCHANGE:
            MPF_OnDisplayChange(wParam, lParam);
            break;
        case WM_CLOSE:
            WinHelp( hwndMain, APP_HELPFILE, HELP_QUIT, 0 );
            break;
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
    }
    return DefWindowProc( hwnd, uiMsg, wParam, lParam );
}

#ifdef __BORLANDC__
#pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevious,
    LPSTR lpszCmdLine, int iCmdShow)
{
    MSG msg;

    happInst = hInstance;
    if( !hPrevious )
        {
        WNDCLASS wc;
        memset( &wc, 0, sizeof(WNDCLASS) );
        wc.style = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;
        wc.lpfnWndProc = (WNDPROC)AppWndProc;
        wc.hInstance = hInstance;
        wc.hbrBackground = (HBRUSH)(COLOR_BTNSHADOW+1);
        wc.lpszMenuName = "APP_MENU";
        wc.lpszClassName = APP_CLASS;
        RegisterClass( &wc );
        }

    hwndMain=CreateWindowEx(WS_EX_OVERLAPPEDWINDOW|WS_EX_TOOLWINDOW,
        APP_CLASS, APP_NAME, WS_OVERLAPPEDWINDOW, 0, 0, 400, 300,
        NULL, NULL, hInstance, NULL );
    ShowWindow( hwndMain, iCmdShow );
    UpdateWindow( hwndMain );
    while( GetMessage( &msg, NULL, NULL, NULL ) )
        {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
        }
    return msg.wParam;
}

