#include <windows.h>
#include <toolhelp.h>

/***********************************************************

GetCurrentHINSTANCE()

Title:          Get the HINSTANCE of the current process.
Return:         NULL if the HINSTANCE could not be found.
                Otherwise, handle to the current instance.
Description:    This function uses the ToolHelp functions
                GetCurrentTask and TaskFindHandle. 
                These only work on Windows 3.1 or later.
************************************************************/

HINSTANCE GetCurrentHINSTANCE ()
    {
    TASKENTRY   teInfo;
    HINSTANCE   hinstCurrent = NULL;

    // Required to initialize size of structure first.
    teInfo.dwSize = sizeof (TASKENTRY);

    if (TaskFindHandle (&teInfo, GetCurrentTask ()))
        {
        hinstCurrent =  teInfo.hInst;
        } // *if*

    return hinstCurrent;
    } // *GetCurrentHINSTANCE*

