//
// This program illustrates one of the problems
// STL implementors have had with Borland C++
// and VC++ 2.x.  The STL performs its own
// memory management, which means it allocates
// raw memory using its own routines, then
// creates objects in that memory using the new
// placement syntax.  When destroying objects,
// the STL has to perform explicit calls to the
// destructor.
//
// Unfortunately, Borland refuses to compile the
// destructor call on a built-in type, seen below
// when compiling the SixPack<int> declaration. Visual
// C++ compiles that properly, but fails on a user
// defined type!
//
// Compile from the command line:
//
//  bcc bug1095.cpp
//  bcc -DSKIP_INT bug1095.cpp  //Workaround
//  cl bug1095.cpp
//  cl /DSKIP_FOO bug1095.cpp   //Workaround
//

#include <stdlib.h>
#include <iostream.h>

template<class T>
class SixPack {
    protected :
        T *t;
    public :
        SixPack();
        ~SixPack();
};

void* operator new( size_t, void* p ) { return p; }

template<class T>
SixPack<T>::SixPack()
{
    t = (T*) malloc( 6 * sizeof( T ) );
    if ( t ) {
        for ( int i = 0 ; i < 6 ; i++ )
            new( t + i ) T( i );
    }
}

template<class T>
SixPack<T>::~SixPack()
{
    if ( t ) {
        for ( int i = 0 ; i < 6 ; i++ )
            ( t + i )->~T ();
        free( t );
    }
}

struct foo {
        int a;
        foo( int i ){ cout << "foo(" << ( a = i ) << ")\n"; }
        ~foo(){ cout << "~foo(" << a << ")\n"; }
};

main()
{
//
// Borland's downfall
//
#ifndef SKIP_INT
    SixPack<int> a;
#endif

//
// Microsoft's nemesis
//
#ifndef SKIP_FOO
    SixPack<foo> b;
#endif

    return 1;
}
