// zoomview.h : header file
// Implements Zooming functions in a CScrollView window
//
// Written by Brad Pirtle,
// CS:72450,1156, Internet:pirtle@qlogic.com
// Copyright 1994, QuickLogic Corp., all rights reserved.
// Version 1.0
#ifndef ZOOMVIEW_H
#define ZOOMVIEW_H

#include "zoombase.h"

////////////////////////////////////////////////////////////
// CZoomView view
class CZoomView : public CZoomBase
{
   DECLARE_DYNAMIC(CZoomView)

protected:
   CZoomView();
   virtual ~CZoomView();
#ifdef _DEBUG
   virtual void AssertValid() const;
#endif //_DEBUG

public:
   // Zooming modes
   typedef enum
      {MODE_ZOOMOFF, MODE_ZOOMIN, MODE_ZOOMOUT} ZoomMode_;
   void      SetZoomMode(ZoomMode_ zoomMode);
   ZoomMode_ GetZoomMode() {return m_zoomMode;};

   // Zoom drawing functions
   void      DrawBox(CDC &dc, CRect &rect, BOOL xor = TRUE);
   void      DrawLine(CDC &dc, const int &x1, const int &y1,
                      const int &x2, const int &y2,
                      BOOL xor = TRUE);
private:
   // Private member variables
   ZoomMode_ m_zoomMode;
   BOOL      m_bCaptured;
   CRect     m_ptDragRect;
   HCURSOR   m_hZoomCursor;

public:
   // Generated message map functions
   //{{AFX_MSG(CZoomView)
   afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
   afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
   afx_msg void OnMouseMove(UINT nFlags, CPoint point);
   afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
   afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest,
                            UINT message);
   //}}AFX_MSG
   DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
#endif
