// This program demonstrates a problem with Borland C++
// 5.0 and C++Builder 1.0. The new mutable keyword
// defined for the ANSI C++ standard is used to allow
// modification of members in an otherwise const object.
// In this case, the two members of a union nested in
// a class are defined as mutable, which means they
// should be mutable even in a const function.
//
// In the first class, the const function attempts
// to modify mutable members of an anonymous
// union.  In the second class, the same unions are
// now named, and the compiler is more than happy
// to allow modification of the members in a const
// member function.
//

class CompilerError
{
    public:
        void doStuff() const {
            n1 = 42;
            n2 = 42;
        }
        union {
            mutable int n1;
            mutable float f1;
        };
        mutable union {
            int n2;
            int f2;
        };
};

class WillCompile
{
    public:
        void doStuff() const {
           named_union_1.n1 = 42;
           named_union_2.n2 = 42;
        }
        union {
            mutable int n1;
            mutable float f1;
        } named_union_1;
        mutable union {
            int n2;
            float f2;
        } named_union_2;
};
