//
// dirsize.c
// Show disk usage of current directory
//
					// conditional defines/includes
#include <stdio.h>
#include <direct.h>
#include <string.h>
#ifdef _WIN32
#include <windows.h>
#include <io.h>
#define findfirstfile(x,y,z)	_findfirst(x,z)
#define findnextfile(x,y)		_findnext(x,y)
#define IS_FIND_ERROR(x)	(x == -1L)
#else 
#include <stdlib.h>
#include <dos.h>
typedef unsigned long       	DWORD;
typedef unsigned short      	WORD;
typedef char*          		PSTR;
typedef int		    	BOOL;
#define MAX_PATH		260
#define findfirstfile(x,y,z)	_dos_findfirst(x,y,z)
#define findnextfile(x,y)		_dos_findnext(y)
#define IS_FIND_ERROR(x)	(x != 0)
#endif // _WIN32
					// global and forward refs
static BOOL IsDirectory(PSTR pDir);
static DWORD GetDirectorySize(PSTR pDir);
static void FormatNumber(PSTR pNumStr, DWORD dwNum);
static char pDir[MAX_PATH];
	// displays the number of bytes in a directory
void main(int argc, char** argv) {
	DWORD dwSize;
	int nLen_1;
	printf("DirSize - by Peter D'Agostino, 1997\n");
						// get user input or use current directory
	if(argc > 1 && *argv[1] != 0) {		// if user input
		if(IsDirectory(argv[1]))		// chk if its a directory
			strcpy(pDir,argv[1]);	// copy it
		else {				// if not directory exit
			printf("\nInput not a recognized directory path\n");
			return;
		}
	}					// nothing input, use CWD
	else _getcwd(pDir,MAX_PATH);
						// format, remove trailing '\'
	nLen_1 = strlen(pDir)-1;
	if(pDir[nLen_1] == '\\') pDir[nLen_1] = '\0';
						// get directory size	
	dwSize = GetDirectorySize(pDir);	// put commas in number
	FormatNumber(pDir, dwSize);		// display and exit		
	printf("\nDirectory Size = %s Bytes\n",pDir);
}
	// return TRUE if string contains a valid directory path
static BOOL IsDirectory(PSTR pDir) {
#ifdef _WIN32
	DWORD dwRet = GetFileAttributes(pDir);
	return((dwRet!= 0xFFFFFFFF) &&
		   (dwRet & FILE_ATTRIBUTE_DIRECTORY));
#else
	WORD attrib;
	return ((!_dos_getfileattr(pDir,&attrib)) &&
			(attrib & _A_SUBDIR));
#endif
}
	// return the total bytes in passed directory
static DWORD GetDirectorySize(PSTR pDir) {
#ifdef _WIN32
	struct _finddata_t  c_file;
#else
	struct _find_t  c_file;
#endif
	char nextDir[MAX_PATH];		// sub-directory path
	DWORD dwSize = 0;			// return directory size
	long hf;					// handle to matching file(s)	
						// search for all files/types	
	strcat(pDir,"\\*.*");
	hf = (long)findfirstfile( pDir, 0x3F, &c_file );
	if(IS_FIND_ERROR(hf)) return dwSize;  // return zero on error
						// if its not the default subs
	if(c_file.name[0] != '.') {			// ck if its sub-directory
		if(c_file.attrib & _A_SUBDIR) {
			strcpy(nextDir,pDir);		// create path
			nextDir[strlen(pDir)-3]='\0';
			strcat(nextDir,c_file.name);	// recurse
			dwSize += GetDirectorySize(nextDir);
		}				// just a file, get size
		else dwSize += c_file.size;
	}					// continue search for rest
	while( findnextfile(hf, &c_file ) == 0 ) {
		if(c_file.name[0] != '.') {
			if(c_file.attrib & _A_SUBDIR) {
				strcpy(nextDir,pDir);
				nextDir[strlen(pDir)-3]='\0';
				strcat(nextDir,c_file.name);
				dwSize += GetDirectorySize(nextDir);
			}
			else dwSize += c_file.size;
		}
	}
	return dwSize;				// return size
}
	// insert commas to make reading large numbers easier
static void FormatNumber(PSTR pNumStr, DWORD dwNum) {
	char str[32];
	int n, m, i=0;				// transferred digit counter
						// get unformatted string
	sprintf(str,"%1lu",dwNum);
	n = strlen(str);				// length unformatted string
	m = (n-1)/3;				// # extra characters, i.e. commas
	pNumStr[m+n] = '\0';			// terminate string
	while(n--) {				// copy n string digits
		if(i==3) {			// 3 digits transferred, add a comma
			pNumStr[n+m] = ',';
			i = 0;			// reset digit counter
			m--;			// one less extra char
		}
		pNumStr[n+m] = str[n];		// copy digit
		i++;				// another digit transferred
	}
}
