/*
    File: generic.cpp
    Author: V.Ramachandran
    Date: April 20, 1996

    Displays window in full screen mode!
*/

#include "windows.h"
#include "generic.h"
#include "fullscr.h"

HINSTANCE hInst;
HWND hWnd;   


BOOL gbFullScreen = FALSE;


#ifdef __BORLANDC__
#pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, 
                                LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;

    if (!hPrevInstance)
    if (!InitApplication(hInstance))
        return (FALSE);

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    while (GetMessage(&msg,    NULL, NULL,    NULL)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return (msg.wParam);
}


BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASS  wc;

    wc.style = NULL;
    wc.lpfnWndProc = (WNDPROC)MainWndProc;
    wc.cbClsExtra = 0; 
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  "GenericMenu";
    wc.lpszClassName = "GenericWClass";

    return (RegisterClass(&wc));

}

/****************************************************************************/
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    hInst = hInstance;

    hWnd = CreateWindow(
        "GenericWClass",
        "Full Screen Sample Application",
        WS_OVERLAPPEDWINDOW,            // Window style.
        CW_USEDEFAULT,                  // x
        CW_USEDEFAULT,                  // y
        CW_USEDEFAULT,                  // cx
        CW_USEDEFAULT,                  // cy
        NULL,                           // Parent Handle
        NULL,                           // Menu or child id.
        hInstance,                      // hInstance
        NULL                            // NULL.
    );

    if (!hWnd)
        return (FALSE);

    HMENU Menu = CreateMenu();
    AppendMenu(Menu, MF_STRING, IDM_FULLSCREEN, "&Full Screen");

    SetMenu(hWnd, Menu);
    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);       
    return (TRUE);           

}

/*********************************************************************/
// MainWndProc - window procedure for the main window.
// Handles WM_COMMAND to toggle the full-screen mode
// Handles WM_GETMINMAXINFO for implementing full screen mode.
// Handles WM_KEYDOWN to check for Escape key in full screen mode.
/*********************************************************************/

long FAR PASCAL MainWndProc (HWND hWnd, UINT message, 
                        WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        case WM_COMMAND:
            if (wParam == IDM_FULLSCREEN) {
                gbFullScreen = !gbFullScreen;        // Toggle flag.
                SetFullScreen (hWnd, gbFullScreen);
            }
        break;

// If in full screen mode and user presses Escape, display window in 
// normal mode
        case WM_KEYDOWN:
            if ((wParam == VK_ESCAPE) && (GetFullScreenState (hWnd))) {
                gbFullScreen = FALSE;        // Back to normal mode!
                SetFullScreen (hWnd, gbFullScreen);
            }
            break;

// Handle this message to achieve full screen effect.
        case WM_GETMINMAXINFO:
            OnGetMinMaxInfo (hWnd, wParam, lParam);
            return 0;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        default:
            return DefWindowProc (hWnd, message, wParam, lParam);
    }
    return 0;
}

