/*----------------------------------------------------------------------------
PROJECT	config.exe
FILE	parser.cpp
HISTORY
	Tilakraj Roychoudhury 941018 Created
ABOUT
	A table driven parser to parse configuration files.
----------------------------------------------------------------------------*/
#include "iostream.h"
#include "stdio.h"
#include "string.h"
#include "ctype.h"

#include "config.h"
#include "parser.h"

//----------------------------------------------------------------------------
//GetNextToken
//
//Given a CR terminated line this function returns the next available
//token, skipping all preceeding white spaces.
//----------------------------------------------------------------------------
unsigned short GetNextToken( char* pszString, unsigned short &wPosition,
	char* pszToken  )
{
	// the different states of the Finite State Machine
	enum { GNT_WHITE_SPACE, GNT_ALPHA, GNT_NUM };

	unsigned short wState = GNT_WHITE_SPACE, fExit = 0;

	while ( ! fExit )
	{
		switch ( wState )
		{
			case GNT_WHITE_SPACE:
			// check if the string starts with a NULL
			if ( pszString[wPosition] == '\0' ) 
			{
				return 1 ;
			}
			// check for white space
			if ( ( iscntrl ( pszString[wPosition] ) )||
				( pszString[wPosition] == ' ') )
			{
				wPosition++;
				break;
			}
			// check for alphabetiacal characters.
			if ( isalnum ( pszString[wPosition] ) )
			{
				*pszToken++ = pszString[wPosition++];
				wState = GNT_ALPHA;
				break;
			}
			/*
			// check for numeric characters.
			if ( isdigit ( pszString[wPosition] ) )
			{
				*pszToken++ = pszString[wPosition++];
				wState = GNT_NUM;
				break;
			}
			*/
			// non alpha, non WS, non numeric;
			(*pszToken++ = pszString[wPosition++]);
			fExit=1;
			break;

			case GNT_ALPHA:
			if ( isalnum ( pszString[wPosition] ) )
				*pszToken++ = pszString[wPosition++];
			else
				fExit = 1;
			break;

			/*
			case GNT_NUM:
			if ( isdigit ( pszString[wPosition] ) )
				*pszToken++ = pszString[wPosition++];
			else
				fExit = 1;
			break;
			*/

			default :
			break;
			// wrong state : FSM screwed.
		}
	}
	*pszToken = '\0';
	return 0;
}

//----------------------------------------------------------------------------
//ParseLine 
//
//Implements the FSM to parse the line read from the configuration file.
//This functon is called once for each line.
//----------------------------------------------------------------------------
unsigned short ParseLine(char* szFileString, PCONFIG *ppCurrentConfig )
{
	PCONFIG	pConfig = *ppCurrentConfig;
	unsigned short	wIdx, wPosition=0;
	unsigned long dwResource;
	unsigned short	wResourceIndex, wState;
	char szToken [80];

	// the different states the Finite State machine can be.
	enum { TOKEN1, LOGICAL_DEVICE_NUMBER, LOGICAL_DEVICE_END,
		RESOURCE_EQUAL, RESOURCE_VALUE, RESOURCE_COMMA ,
		RESOURCE_DASH, RESOURCE_MEM_LENGTH, RESOURCE_COLON,
		RESOURCE_BITS };

	// at the begining of every line we initialize wState to this value.
	wState = TOKEN1;
	//cerr << '\n';
	while ( 1 )  // loop endlessly until carriage return or error
	{
		if (  GetNextToken ( szFileString, wPosition, szToken ) )
			break;
		//cerr << wState << '\t';
		switch ( wState )
		{
			case TOKEN1 :
			// check if the line begins with a '[' 
			if ( *szToken == '[' ) // Yes - a logical device number
			{
				dwLogicalDevice = 0xff;
				wState = LOGICAL_DEVICE_NUMBER; 
			}
			else // the first token should be a resource name
			{
				if ( dwLogicalDevice == 0xff )
					continue;
				wResourceIndex = 0xff;
				for ( wIdx = 0 ;
					wIdx < MAX_RESOURCE_TYPE ;
					wIdx ++ )
				{
					if ( stricmp (
					ParserTable[wIdx].szResourceName,
						szToken ) == 0 )
					{
						wResourceIndex = wIdx;
						break;
					}
					
				}

				if ( wResourceIndex == 0xff )
					return 1;
				wState = RESOURCE_EQUAL;
			}
			break;

			case LOGICAL_DEVICE_NUMBER  :
			if ( sscanf ( szToken, "%ld" , &dwLogicalDevice ) != 1 )
			{
				return 1;
			}
			wState = LOGICAL_DEVICE_END ; 
			break;

			case LOGICAL_DEVICE_END :
			if ( *szToken != ']' )
			{
				return 1;
			}
			// here we allocate another node in the link list
			pConfig = new  CONFIG ;

			// attach it to the tail of the existing list
			pConfig->Next = NULL;
			if ( *ppCurrentConfig )
			{
				(*ppCurrentConfig)->Next = pConfig;
			}
			*ppCurrentConfig = pConfig;

			// insert the logical device number into the structure
			pConfig->wLogicalDevice  =
				(unsigned short )dwLogicalDevice;
			pConfig->wNumIO = 0;
			pConfig->wNumIRQ = 0;
			pConfig->wNumDMA = 0;
			pConfig->wNumMEM = 0;
			wState = TOKEN1;
			break;

			case RESOURCE_EQUAL :
			if ( *szToken != '=' )
			{
				return 1;
			}
			wState = RESOURCE_VALUE;
			break;

			case RESOURCE_VALUE :
			if ( ParserTable[wResourceIndex].wResourceType ==
				TYPE_HEX )
			{
				if ( sscanf(szToken, "%lx", &dwResource ) != 1 )
					return 1;
			}
			else // the resource is a decimal value resource
			{
				if ( sscanf(szToken, "%lu", &dwResource ) != 1 )
					return 1;
			}
			switch ( ParserTable[wResourceIndex].wResourceID )
			{
				case ID_IO :
				if ( pConfig->wNumIO >
				ParserTable[wResourceIndex].wResourceCount )
					break;
			//	cerr << "\nIO : " << hex << dwResource <<"\t";
				pConfig->wIO[pConfig->wNumIO++] =
					(unsigned short)dwResource;
				wState = RESOURCE_COMMA;
				break;

				case ID_DMA :
				//cerr << "\nDMA : " << dec << dwResource <<"\t";
				pConfig->wDMA[pConfig->wNumDMA++]
					= (unsigned short)dwResource;
				wState = RESOURCE_COMMA;
				break;

				case ID_IRQ :
				//cerr << "\nIRQ : " << dec << dwResource <<"\t";
				pConfig->wIRQ[pConfig->wNumIRQ++]
					= (unsigned short)dwResource;
				wState = RESOURCE_COMMA;
				break;

				case ID_MEM :
				//cerr << "\nMEM : " << hex << dwResource <<"\t";
				pConfig->dwMEM[pConfig->wNumMEM]
					= dwResource;
				wState = RESOURCE_DASH;
				break;
			}
			break;

			case RESOURCE_DASH :
			if ( *szToken != '-' )
			{
				return 1;
			}
			wState = RESOURCE_MEM_LENGTH;
			break;

			case RESOURCE_MEM_LENGTH:
			if ( sscanf(szToken, "%lx", &dwResource ) != 1 )
			{
				return 1;
			}
			//cerr << "\nLength : " << hex << dwResource <<"\t";
			pConfig->dwLength[pConfig->wNumMEM]
				= dwResource;
			wState = RESOURCE_COLON;
			break;

			case RESOURCE_COLON:
			if ( *szToken != ':' )
			{
				return 1;
			}
			wState = RESOURCE_BITS;
			break;

			case RESOURCE_BITS:
			if ( sscanf ( szToken, "%lu", &dwResource ) != 1 )
			{
				return 1;
			}
			//cerr << "\nBITS : " << dec << dwResource <<"\t";
			pConfig->bBits[pConfig->wNumMEM++]
				= (unsigned char)dwResource;
			wState = RESOURCE_COMMA;
			break;


			case RESOURCE_COMMA :
			if ( *szToken != ',' )
			{
				return 1;
			}
			wState = RESOURCE_VALUE;
			break;
		}
	}

	return 0;
}

