#define OEMRESOURCE
#include <windows.h>
#include <windowsx.h>
#include <assert.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include "regress.h"
#include "regress.rh"

#if !(defined(__WIN32__) || defined(_WIN32))
#   define  EXPORT  __export
#else
#   define  EXPORT
#endif
#ifdef __BORLANDC__
#   pragma warn -eff    /* avoid false alarms from windowsx.h   */
#endif

static BOOL CALLBACK MainDialog(HWND, UINT, WPARAM, LPARAM);
static BOOL CALLBACK TestDialog(HWND, UINT, WPARAM, LPARAM);
extern int  GetAnswer(HWND, LPCSTR, LPCSTR, LPSTR, int);

#define MAX_NAME    (64)
#define MAX_VALUE   (BLREGR_MAX_VALUE)

#define NEW(type)   ((type*)malloc(sizeof(type)))
#define GROUPSEC    "___groups"
#define GLOBALSEC   "___options"

#define LBF_SHOWCHECK   (0x00010000L)   /* this is a cheklist   */
#define LBF_CHECK       (0x00020000L)   /* display a checkmark  */
#define LBF_RED         (0x00040000L)   /* display in red       */
#define LBF_YELLOW      (0x00080000L)   /* display in yellow    */
#define LBF_GREEN       (0x00100000L)   /* display in green     */

#define LBF_CLEAR       (0x10000000L)   /* clear the listbox    */
#define LBF_VALUE       (0x20000000L)   /* include "=value"     */
#define LBF_TESTFUNC    (0x40000000L)   /* look up func #       */

#define LBF_MASK        (0x0000FFFFL)   /* to store func#       */


static HINSTANCE    ModuleHandle;
static char         IniFile[MAX_NAME];
static char         CurGroup[MAX_NAME];
static char         CurTest[MAX_NAME];
static char         CurOption[MAX_NAME];
static void*        RunData;
static int          EditingGroup    = FALSE;
static int          EditingTest     = FALSE;
static int          EditingOptions  = FALSE;
static HWND         ParentDialog    = 0;
static HWND         OutputWindow    = 0;
static char         OutputFile[MAX_VALUE];


#define MAX_FUNCS   (256)
typedef struct  TRegFunc
    {
    BL_REGRFUNC Function;
    LPCSTR      Name;
    void*       CustomData;
    }           TRegFunc;
TRegFunc    Registry[MAX_FUNCS];
int         NRegistered = 0;

int     FindFunc(LPCSTR Name)
    {
    int     iFunc;
    for(iFunc = 0; iFunc < NRegistered; ++iFunc)
        if(!strcmpi(Name, Registry[iFunc].Name))
            return iFunc;
    return -1;
    }
int     BlRegrRegister(BL_REGRFUNC Func, LPCSTR Name, void* Custom)
    {
    int     Result  = FALSE;    /* assume failure */
    if(FindFunc(Name) == -1)
        {
        assert(NRegistered < MAX_FUNCS);
        Registry[NRegistered].Name          = strdup(Name);
        Registry[NRegistered].Function      = Func;
        Registry[NRegistered].CustomData    = Custom;
        ++NRegistered;
        Result                              = TRUE;
        }
    return Result;
    }

typedef struct  LBSEL
    {
    HWND        Listbox;
    int         Count;
    int*        Array;
    }           LBSEL;

LBSEL*      LbSelNew(HWND Listbox)
    {
    LBSEL*  Result = NEW(LBSEL);
    if(Result)
        {
        Result->Listbox = Listbox;
        Result->Count   = ListBox_GetSelCount(Listbox);
        Result->Array   = (int*)malloc(Result->Count*sizeof(int));
        ListBox_GetSelItems(Listbox, Result->Count, Result->Array);
        }
    return Result;
    }

void        LbSelGetName(LBSEL* Sel, int Which, LPSTR Buffer)
    {ListBox_GetText(Sel->Listbox, Sel->Array[Which], Buffer);}
int         NameGetInt(LPCSTR Section, LPCSTR Name)
    {return (int)GetPrivateProfileInt(Section, Name, 0, IniFile);}
int         NameGet(LPCSTR Section, LPCSTR Name, LPSTR Buffer)
    {
    return GetPrivateProfileString(Section, Name, "", Buffer,
                                   MAX_VALUE, IniFile);
    }
void        NameDelete(LPCSTR Section, LPCSTR Name)
    { WritePrivateProfileString(Section, Name, NULL, IniFile); }
void        NamesDelete(LPCSTR Section)
    { WritePrivateProfileString(Section, NULL, NULL, IniFile); }
void        NameAdd(LPCSTR Section, LPCSTR Name, LPCSTR Value)
    { WritePrivateProfileString(Section, Name, Value, IniFile);}
void        NameToListbox(LPCSTR Section, HWND ListBox, LPARAM Flags)
    {
    char    String[MAX_NAME+MAX_VALUE+1];
    char*   Buffer = (char*)malloc(4096);
    if(Buffer)
        {
        int     Clear   = (Flags & LBF_CLEAR) ? 1 : 0;
        char*   Rover   = Buffer;
        int     iGroup;
        GetPrivateProfileString(Section, NULL, "", Buffer,
                                4095, IniFile);
        if(Clear)
            ListBox_ResetContent(ListBox);
        for(iGroup = 0; *Rover; ++iGroup)
            {
            int     Index;
            if(!Clear && (Flags&LBF_VALUE))
                {
                char    Find[MAX_NAME];
                strcpy(Find, Rover);    strcat(Find, "=");
                Index   = ListBox_FindString(ListBox, -1, Find);
                if(Index != LB_ERR);
                    ListBox_DeleteString(ListBox, Index);
                }
            if(Flags & (LBF_VALUE|LBF_MASK))
                {
                char    Value[MAX_VALUE];
                NameGet(Section, Rover, Value);
                if(Flags & LBF_VALUE)
                    wsprintf(String, "%s=%s", Rover, Value);
                else
                    {
                    Flags  |= iGroup & LBF_MASK;
                    strcpy(String, Rover);
                    }
                }
            else
                strcpy(String, Rover);
            
            Index = ListBox_AddString(ListBox, String);
            ListBox_SetItemData(ListBox, Index, (LPARAM)Flags);
            Rover  += strlen(Rover)+1;
            }
        free(Buffer);
        }
    }

int     BlRegrInit(HINSTANCE Instance, LPCSTR Name)
    {
    extern int InitCheckList(HINSTANCE);
    InitCheckList(Instance);
    ModuleHandle    = Instance;
    lstrcpy(IniFile, Name);
    return TRUE;
    }

static void GetOptionsSection(char* Section)
    {
    if(EditingGroup)
        if(EditingTest)
            wsprintf(Section, "test_options_%s", CurTest);
        else
            wsprintf(Section, "group_options_%s", CurGroup);
    else
        strcpy(Section, GLOBALSEC);
    }
static void LoadOptions(HWND ListBox)
    {
    char    Section[MAX_NAME*2];
    /* First, load all global options */
    NameToListbox(GLOBALSEC, ListBox, LBF_CLEAR|LBF_RED|LBF_VALUE);
    if(EditingGroup)
        {
        wsprintf(Section, "group_options_%s", CurGroup);
        NameToListbox(Section, ListBox, LBF_YELLOW|LBF_VALUE);
        if(EditingTest)
            {
            wsprintf(Section, "test_options_%s", CurTest);
            NameToListbox(Section, ListBox, LBF_GREEN|LBF_VALUE);
            }
        }
    }

static void ListBox_SelectAll(HWND ListBox)
    {
    int     SelCount = ListBox_GetCount(ListBox);
    if(SelCount != LB_ERR)
        {
        int     i; 
        for(i = 0; i < SelCount; ++i)
            ListBox_SetSel(ListBox, TRUE, i);
        }
    }

static void MainDialogEnable(HWND Dialog, HWND Groups)
    {
    HWND    Combo = GetDlgItem(Dialog, ID_EDITTEST_CALLBACK);
    HWND    TestAll = GetDlgItem(Dialog, ID_MAIN_TESTALL);
    int     Count = ListBox_GetSelCount(Groups);
    EnableWindow(GetDlgItem(Dialog, ID_MAIN_TEST),
        Combo ? (ComboBox_GetCurSel(Combo) != CB_ERR) : Count > 0);
    EnableWindow(GetDlgItem(Dialog, ID_MAIN_EDIT), Count == 1);
    EnableWindow(GetDlgItem(Dialog, ID_MAIN_DELETE), Count > 0);
    if(TestAll)
        EnableWindow(TestAll, ListBox_GetCount(Groups) > 0);
    }

#if defined(__BORLANDC__)
    #pragma argsused
#endif
static BOOL MainDialogCommand(HWND Dialog, int ControlId,
                              HWND Control, UINT Notify)
    {
    HWND    Groups  = GetDlgItem(Dialog, ID_MAIN_GROUPS);

    if(ControlId == IDOK || ControlId == IDCANCEL)
        {
        EndDialog(Dialog, ControlId);
        return TRUE;
        }
    else if(ControlId == ID_MAIN_TEST
         || ControlId == ID_MAIN_TESTALL)
        {
        if(ControlId == ID_MAIN_TESTALL)
            ListBox_SelectAll(Groups);
        ParentDialog   = Dialog;
        DialogBox(ModuleHandle, "BlRegrTestOutput",
                  Dialog, TestDialog);
        }
    else if(ControlId == ID_MAIN_NEW)
        {
        const char* Request;
        char        Buffer[64];
        if(EditingOptions || EditingTest)
            Request = "Enter name for new option:";
        else
        Request = EditingGroup ? "Enter name for new test:"
                  : "Enter name for new group of tests:";
        Buffer[0]   = '\0';
        if(GetAnswer(Dialog, "New name", Request, Buffer, 64)
                    != IDCANCEL)
            {
            if(ListBox_FindString(Groups, -1, Buffer)!=LB_ERR)
                MessageBox(Dialog, "Duplicate name!",
                    "Error:", MB_OK);
            else
                {
                if(EditingOptions || EditingTest)
                    {
                    char*   Value;
                    char    Section[MAX_NAME];
                    GetOptionsSection(Section);
                    Value   = strchr(Buffer, '=');
                    if(Value)
                        *Value++    = '\0';
                    else
                        Value   = "";
                    NameAdd(Section, Buffer, Value);
                    LoadOptions(Groups);
                    }
                else
                    {
                    NameAdd(EditingGroup?CurGroup:GROUPSEC,
                            Buffer, "");
                    ListBox_AddString(Groups, Buffer);
                    }
                }
            }
        MainDialogEnable(Dialog, Groups);
        }
    else if(ControlId == ID_MAIN_DELETE)
        {
        int     i;
        LBSEL*  Sels = LbSelNew(Groups);
        for(i = Sels->Count-1; i >= 0; --i)
            {
            char    Name[MAX_NAME+MAX_VALUE];
            LbSelGetName(Sels, i, Name);
            ListBox_DeleteString(Groups, Sels->Array[i]);
            if(EditingOptions || EditingTest)
                {
                char    Section[MAX_NAME];
                GetOptionsSection(Section);
                if(strchr(Name, '='))
                    *strchr(Name, '=') = '\0';
                NameDelete(Section, Name);
                }
            else
                {
                NameDelete(EditingGroup?CurGroup:GROUPSEC, Name);
                NamesDelete(Name);
                }
            }
        if(EditingOptions || EditingTest)
            LoadOptions(Groups);
        free(Sels);
        MainDialogEnable(Dialog, Groups);
        }
    else if(ControlId == ID_MAIN_EDIT)
        {
        LBSEL*  Sels = LbSelNew(Groups);
        
        if(EditingOptions || EditingTest)
            {
            char    Prompt[MAX_NAME+64];
            char    Section[MAX_NAME];
            char    Value[MAX_VALUE];
            GetOptionsSection(Section);
            LbSelGetName(Sels, 0, CurOption);
            if(strchr(CurOption, '='))
                *strchr(CurOption, '=') = '\0';
            wsprintf(Prompt, "Enter new value for option %s:",
                     CurOption);
            NameGet(Section, CurOption, Value);
            if(GetAnswer(Dialog, "New value", Prompt, Value,
                         MAX_VALUE) != IDCANCEL)
                {
                NameAdd(Section, CurOption, Value);
                LoadOptions(Groups);
                }
            }
        else if(!EditingGroup)
            {
            LbSelGetName(Sels, 0, CurGroup);
            EditingGroup    = TRUE;
            DialogBox(ModuleHandle, "BlRegrEditGroup",
                      Dialog, MainDialog);
            EditingGroup    = FALSE;
            }
        else
            {
            LbSelGetName(Sels, 0, CurTest);
            EditingTest     = TRUE;
            DialogBox(ModuleHandle, "BlRegrTestEdit",
                      Dialog, MainDialog);
            EditingTest     = FALSE;
            }
        free(Sels);
        }
    else if(ControlId == ID_MAIN_OPTIONS)
        {
        EditingOptions  = TRUE;
        DialogBox(ModuleHandle, "BlRegrOptionEdit",
                  Dialog, MainDialog);
        EditingOptions  = FALSE;
        }
    else if(Notify == CBN_SELCHANGE
         && ControlId == ID_EDITTEST_CALLBACK)
        {
        char    Callback[MAX_NAME];
        int     Index;
        HWND    Combo   = GetDlgItem(Dialog, ID_EDITTEST_CALLBACK);
        Index   = ComboBox_GetCurSel(Combo);
        if(Index != CB_ERR)
            ComboBox_GetLBText(Combo, Index, Callback);
        else
            Callback[0] = '\0';
        NameAdd(CurGroup, CurTest, Callback);
        MainDialogEnable(Dialog, Groups);
        }
    else if(Notify == LBN_SELCHANGE)
        MainDialogEnable(Dialog, Groups);

    return FALSE;
    }

static BOOL CALLBACK MainDialog(HWND Dialog, UINT Message,
                                WPARAM wParam, LPARAM lParam)
    {
    switch(Message)
        {
        case    WM_INITDIALOG   :
            {
            char    Title[128];
            HWND    Groups = GetDlgItem(Dialog, ID_MAIN_GROUPS);
            if(EditingOptions || EditingTest)
                {
                if(EditingTest)
                    {
                    char    Callback[MAX_NAME];
                    int     iTest;
                    HWND    Combo   = GetDlgItem(Dialog,
                                            ID_EDITTEST_CALLBACK);
                    for(iTest = 0; iTest < NRegistered; ++iTest)
                        ComboBox_AddString(Combo,
                                           Registry[iTest].Name);
                    NameGet(CurGroup, CurTest, Callback);
                    iTest = ComboBox_FindString(Combo, -1, Callback);
                    if(iTest != CB_ERR)
                        ComboBox_SetCurSel(Combo, iTest);
                    }
                LoadOptions(Groups);
                }
            else
                NameToListbox(EditingGroup?CurGroup:GROUPSEC,
                              Groups, LBF_CLEAR);
            MainDialogEnable(Dialog, Groups);
            if(EditingOptions)
                {
                wsprintf(Title, "Edit %s options%s%s",
                    EditingTest?"test":
                        (EditingGroup?"group":"global"),
                    (EditingTest | EditingGroup)?": ":"",
                    EditingTest?CurTest:(EditingGroup?CurGroup:"")
                    );
                }
            else if(EditingTest)
                wsprintf(Title, "Edit test: %s", CurTest);
            else if(EditingGroup)
                wsprintf(Title, "Edit Group: %s", CurGroup);
            else
                strcpy(Title,(LPCSTR)lParam);
            SetWindowText(Dialog, Title);
            return TRUE; /* FALSE if you called SetFocus() */
            }
        HANDLE_MSG(Dialog, WM_COMMAND, MainDialogCommand);
        }
    return FALSE; /* FALSE == we did not process msg */
    }

int     BlRegrDialog(HWND Parent, LPCSTR Title, void* RunData_)
    {
    RunData     = RunData_;
    return DialogBoxParam(ModuleHandle, "BlRegrMain", Parent,
                          MainDialog, (LPARAM)Title);
    }

int     BlRegrOptionGet(LPCSTR OptionName, LPSTR Value_)
    {
    char    Section[MAX_NAME*2];
    char    Value[MAX_VALUE];
    char    Temp[MAX_VALUE];
    /* get global value first */
    NameGet(GLOBALSEC, OptionName, Value);
    /* get group value next */
    wsprintf(Section, "group_options_%s", CurGroup);
    NameGet(Section, OptionName, Temp);
    if(Temp[0])
        strcpy(Value, Temp);
    /* get test value last */
    wsprintf(Section, "Test_options_%s", CurTest);
    NameGet(Section, OptionName, Temp);
    if(Temp[0])
        strcpy(Value, Temp);
    if(Value_)
        strcpy(Value_, Value);
    return atoi(Value);
    }

static int AppendToFile(LPCSTR Filename, LPCSTR String)
    {
    int   Result = FALSE;   /* assume failure */
    HFILE File   = _lopen(Filename, OF_READWRITE|OF_SHARE_COMPAT);
    if(File == HFILE_ERROR)
        File    = _lcreat(Filename, 0);
    if(File != HFILE_ERROR)
        {
        /* seek to end */
        _llseek(File, 0, 2);
        _lwrite(File, String, strlen(String));
        _lclose(File);
        Result  = TRUE;
        }
    return Result;
    }

void    BlRegrOutput(LPCSTR Format, ...)
    {
    char*   Buffer  = (char*)malloc(4096);
    va_list Args;
    va_start(Args, Format);
    wvsprintf(Buffer, Format, Args);
    va_end(Args);
    if(NameGetInt(GLOBALSEC, "WindowOutput"))
        {
        Edit_SetSel(OutputWindow, (UINT)-1, (UINT)-1);
        Edit_ReplaceSel(OutputWindow, Buffer);
        }
    if(NameGetInt(GLOBALSEC, "FileOutput"))
        AppendToFile(OutputFile, Buffer);
    free(Buffer);
    }


#if defined(__BORLANDC__)
    #pragma argsused
#endif
static BOOL TestDialogCommand(HWND Dialog, int ControlId,
                              HWND Control, UINT Notify)
    {

    if(ControlId == IDOK || ControlId == IDCANCEL)
        {
        EndDialog(Dialog, ControlId);
        return TRUE;
        }
    else if(ControlId == ID_OUTPUT_CLRWIN)
        {
        Edit_SetSel(OutputWindow, 0, -1);
        Edit_ReplaceSel(OutputWindow, "");
        }
    else if(ControlId == ID_OUTPUT_CLRFILE)
        {
        HFILE File = _lcreat(OutputFile, 0);
        if(File != HFILE_ERROR)
            _lclose(File);
        }
    else if(ControlId == ID_OUTPUT_ENWIN)
        NameAdd(GLOBALSEC, "WindowOutput",
                Button_GetCheck(Control)?"1":"0");
    else if(ControlId == ID_OUTPUT_ENFILE)
        NameAdd(GLOBALSEC, "FileOutput",
                Button_GetCheck(Control)?"1":"0");
    else if(ControlId == ID_OUTPUT_FILENAME && Notify == EN_CHANGE)
        {
        Edit_GetText(GetDlgItem(Dialog, ID_OUTPUT_FILENAME),
                     OutputFile, MAX_VALUE);
        NameAdd(GLOBALSEC, "OutputFile", OutputFile);
        }
    else if(ControlId == ID_OUTPUT_RUN)
        {
        HWND    Tests   = GetDlgItem(Dialog, ID_OUTPUT_TESTS);
        LBSEL*  Sels    = LbSelNew(Tests);
        int     iTest;
        char*   Buffer  = (char*)malloc(4096);
        char    CurGroup_[MAX_NAME];

        strcpy(CurGroup_, CurGroup);    /* stack current group */
        GetPrivateProfileString(GROUPSEC, NULL, "", Buffer,
                4095, IniFile);
        for(iTest = 0; iTest < Sels->Count; ++iTest)
            {
            int         Success;
            int         iGroup;
            int         iFunc;
            char*       Rover = Buffer;
            char        Callback[MAX_NAME];

            /* establish group this test belongs to */
            iGroup   = (int)(ListBox_GetItemData(Tests, iTest)
                           &LBF_MASK);
            if(iGroup != 0x0000FFFFL)
                {
                while(iGroup-- > 0)
                    Rover   += strlen(Rover)+1;
                strcpy(CurGroup, Rover);
                }
            /* establish name of current test               */
            LbSelGetName(Sels, iTest, CurTest);

            /* get name of callback for this test           */
            NameGet(CurGroup, CurTest, Callback);

            iFunc   = FindFunc(Callback);
            if(iFunc < 0)
                {
                char    Message[64 + MAX_NAME*3];
                wsprintf(Message, "Callback '%s' not defined for "
                    "test '%s' in group '%s'",
                    Callback, CurTest, CurGroup);
                MessageBox(Dialog, Message, "Test run", MB_OK);
                }
            else
                {
                Success = Registry[iFunc].Function(RunData,
                    Registry[iFunc].CustomData);
                if(Success)
                    {
                    ListBox_SetSel(Tests, FALSE, iTest);
                    ListBox_SetItemData(Tests, iTest,
                                LBF_SHOWCHECK|LBF_CHECK);
                    }
                else
                    ListBox_SetItemData(Tests, iTest, LBF_RED);
                }
            }
        InvalidateRect(Tests, 0, TRUE);
        free(Sels);
        free(Buffer);
        }
    return FALSE;
    }

static BOOL CALLBACK TestDialog(HWND Dialog, UINT Message,
                                WPARAM wParam, LPARAM lParam)
    {
    switch(Message)
        {
        case    WM_INITDIALOG   :
            {
            HWND    TestList = GetDlgItem(Dialog, ID_OUTPUT_TESTS);
            OutputWindow    = GetDlgItem(Dialog, ID_OUTPUT_OUTWIN);
            Button_SetCheck(GetDlgItem(Dialog, ID_OUTPUT_ENFILE),
                NameGetInt(GLOBALSEC, "FileOutput"));
            Button_SetCheck(GetDlgItem(Dialog, ID_OUTPUT_ENWIN),
                NameGetInt(GLOBALSEC, "WindowOutput"));
            NameGet(GLOBALSEC, "OutputFile", OutputFile);
            SetDlgItemText(Dialog, ID_OUTPUT_FILENAME, OutputFile);
            if(EditingTest) /* if just running this one test */
                ListBox_AddString(TestList, CurTest);
            else if(EditingGroup)
                {
                char    Test[MAX_NAME];
                int     iSel;
                LBSEL*  Sels = LbSelNew(GetDlgItem(ParentDialog,
                                        ID_MAIN_GROUPS));
                for(iSel = 0; iSel < Sels->Count; ++iSel)
                    {
                    LbSelGetName(Sels, iSel, Test);
                    ListBox_AddString(TestList, Test);
                    }
                free(Sels);
                }
            else            /* else, we're in the main dialog   */
                {
                char    Group[MAX_NAME];
                int     iSel;
                LBSEL*  Sels = LbSelNew(GetDlgItem(ParentDialog,
                                        ID_MAIN_GROUPS));
                for(iSel = 0; iSel < Sels->Count; ++iSel)
                    {
                    LbSelGetName(Sels, iSel, Group);
                    NameToListbox(Group, TestList, LBF_SHOWCHECK);
                    }
                free(Sels);
                }
            ListBox_SelectAll(TestList);
            return TRUE; /* FALSE if you called SetFocus() */
            }

        HANDLE_MSG(Dialog, WM_COMMAND, TestDialogCommand);
        }

    return FALSE; /* FALSE == we did not process msg */
    }

/****************************************************************
 * simple question/answer dialog box                            *
 ****************************************************************/
static LPCSTR   Title_;
static LPCSTR   Question_;
static LPSTR   Answer_;
static int      BufSize_;


#if defined(__BORLANDC__)
    #pragma argsused
#endif
static BOOL ResponseDialogCommand(HWND Dialog, int ControlId,
                                  HWND Control, UINT Notify)
    {
    if(ControlId == IDOK || ControlId == IDCANCEL)
        {
        if(ControlId == IDOK)
            GetDlgItemText(Dialog, ID_RESPONSE_ANSWER,
                Answer_, BufSize_);
        EndDialog(Dialog, ControlId);
        return TRUE;
        }
    return FALSE;
    }

static BOOL CALLBACK ResponseDialog(HWND Dialog, UINT Message,
                                    WPARAM wParam, LPARAM lParam)
    {
    switch(Message)
        {
        case    WM_INITDIALOG   :
            {
            HWND    Edit = GetDlgItem(Dialog, ID_RESPONSE_ANSWER);
            SetDlgItemText(Dialog, ID_RESPONSE_QUESTION, Question_);
            SetDlgItemText(Dialog, ID_RESPONSE_ANSWER, Answer_);
            SetFocus(Edit);
            Edit_SetSel(Edit, 0, -1);
            SetWindowText(Dialog, Title_);
            return FALSE;
            }
        HANDLE_MSG(Dialog, WM_COMMAND, ResponseDialogCommand);
        }

    return FALSE; /* FALSE == we did not process msg */
    }
int     GetAnswer(HWND Parent, LPCSTR Title, LPCSTR Question,
                  LPSTR Answer, int BufSize)
    {
    Title_      = Title;
    Question_   = Question;
    Answer_     = Answer;
    BufSize_    = BufSize;
    return DialogBox(ModuleHandle, "BlRegrResponse", Parent,
        ResponseDialog);
    }


/****************************************************************
 * custom listbox code                                          *
 ****************************************************************/
#undef  max
#define max(a,b) ((a)>(b)?(a):(b))

WNDPROC lpfnOrig; /* Original list box wnd proc. */
char    szMod[] = "ChekList"; /* Module name. */
char    szFuncLo[] = "ChekListLo"; /* Property tags. */
char    szFuncHi[] = "ChekListHi";

/* Prototypes. */
void    DrawCheck(LPDRAWITEMSTRUCT, LPBITMAP, HBITMAP);
void    DrawListItem(LPDRAWITEMSTRUCT);
void    DrawString(LPDRAWITEMSTRUCT, LPBITMAP);
HWND    HwndGetList(HWND, UINT, UINT);

LRESULT CALLBACK EXPORT  LwParentProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK EXPORT  LwListProc(HWND, UINT, WPARAM, LPARAM);

int    InitCheckList(HINSTANCE hins)
    {
    WNDCLASS    wcs;

    GetClassInfo(NULL, "ListBox", &wcs);
    wcs.lpszClassName = szMod;
    wcs.hInstance = hins;
    lpfnOrig = wcs.lpfnWndProc;
    wcs.lpfnWndProc = LwListProc;
    return RegisterClass(&wcs);
    }

LRESULT CALLBACK EXPORT LwListProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
    {
    switch (wm)
        {
    default:
        break;

    case WM_CREATE: /* Subclass parent to intercept */
        {           /* owner draw messages. */
        LPCREATESTRUCT  lpcrs = (LPCREATESTRUCT)lParam;
        HWND            hwndParent = lpcrs->hwndParent;
        LONG            lpfn;

        if (GetProp(hwndParent, szFuncLo) == NULL)
            {
            lpfn = GetWindowLong(hwndParent,
              GWL_WNDPROC);
            SetProp(hwndParent, szFuncLo,
              (HANDLE)LOWORD(lpfn));
            SetProp(hwndParent, szFuncHi,
              (HANDLE)HIWORD(lpfn));
            SubclassWindow(hwndParent, LwParentProc);
            }

        /* Store bitmap to draw. */
        SetProp(hwnd, szMod,
          (HANDLE)(LONG)LoadBitmap(NULL, (LPCSTR)OBM_CHECK));
        }
        break;

    case WM_DESTROY:
        DeleteObject(RemoveProp(hwnd, szMod));
        break;
        }   /* End switch wm. */

    return CallWindowProc(lpfnOrig, hwnd, wm, wParam,
      lParam);
    }

LRESULT CALLBACK EXPORT LwParentProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
    {
    WNDPROC lpfn;

    lpfn = (WNDPROC)MAKELONG(GetProp(hwnd, szFuncLo),
      GetProp(hwnd, szFuncHi));

    switch (wm)
        {
    default:
        break;

    case WM_DESTROY:    /* Remove subclasser. */
        RemoveProp(hwnd, szFuncLo);
        RemoveProp(hwnd, szFuncHi);
        SubclassWindow(hwnd, lpfn);
        break;

    case WM_MEASUREITEM:
        {
        LPMEASUREITEMSTRUCT lpmis;
        HDC                 hdc;
        HWND                hwndList;

        /* Is it for us? */
        lpmis = (LPMEASUREITEMSTRUCT)lParam;
        if ((hwndList = HwndGetList(hwnd,
          lpmis->CtlType, lpmis->CtlID)) == NULL)
            break;  /* Nope. */

        if ((hdc = GetDC(hwndList)) != NULL)
            {
            TEXTMETRIC  txm;
            BITMAP      bmp;
            HBITMAP     hbmp;

            /* Leave 2 border thicknesses for caret. */
            if ((hbmp = (HBITMAP)GetProp(hwndList, szMod)) !=
              NULL)
                { 
                GetObject(hbmp, sizeof bmp, &bmp);
                GetTextMetrics(hdc, &txm);
                lpmis->itemHeight =
                  max(txm.tmHeight, bmp.bmHeight) +
                  2 * GetSystemMetrics(SM_CYBORDER)
                  - 4 /* ??? ron slop ??? */;
                }
            ReleaseDC(hwndList, hdc);
            }
        }
        return TRUE;

    case WM_DRAWITEM:
        {
        LPDRAWITEMSTRUCT    lpdis;

        /* Is it for us? */
        lpdis = (LPDRAWITEMSTRUCT)lParam;
        if (HwndGetList(hwnd, lpdis->CtlType,
          lpdis->CtlID) == NULL)
            break;  /* Nope. */
        DrawListItem(lpdis);
        }
        return TRUE;
        }

    return CallWindowProc(lpfn, hwnd, wm, wParam,
      lParam);
    }

HWND HwndGetList(HWND hwndParent, UINT wType, UINT did)
    {
    HWND    hwnd;
    char    szBuf[sizeof szMod];

    if (wType != ODT_LISTBOX ||
      (hwnd = GetDlgItem(hwndParent, did)) == NULL)
        return NULL;
    GetClassName(hwnd, szBuf, sizeof szBuf);
    return lstrcmp(szBuf, szMod) == 0 ? hwnd : NULL;
    }

void DrawListItem(LPDRAWITEMSTRUCT lpdis)
    {
    HBITMAP hbmp;
    BITMAP  bmp;

    if ((hbmp = (HBITMAP)GetProp(lpdis->hwndItem, szMod)) == NULL)
        return; /* Out of GDI memory. */
    GetObject(hbmp, sizeof bmp, &bmp);

    FillRect(lpdis->hDC, &lpdis->rcItem, GetStockObject(WHITE_BRUSH));
        DrawCheck(lpdis, &bmp, hbmp);
        DrawString(lpdis, &bmp);
        if(lpdis->itemState & ODS_FOCUS)
            DrawFocusRect(lpdis->hDC, &lpdis->rcItem);
    }

void DrawString(LPDRAWITEMSTRUCT lpdis, LPBITMAP lpbmp)
    {
    COLORREF    OldText, OldBk;
    int         cb;
    LPSTR       lpsz;
    int aTabs[2] = { 200, 300  };

    cb  = ListBox_GetTextLen(lpdis->hwndItem, lpdis->itemID);

    if ((lpsz = (LPSTR)GlobalAllocPtr(GHND, cb+1)) == NULL)
        return; /* No memory for string. */
    ListBox_GetText(lpdis->hwndItem, lpdis->itemID, (LPARAM)lpsz);

    if ((lpdis->itemState & ODS_SELECTED))
        {
        OldText = SetTextColor(lpdis->hDC,
                               GetSysColor(COLOR_HIGHLIGHTTEXT));
        OldBk   = SetBkColor(lpdis->hDC,
                             GetSysColor(COLOR_HIGHLIGHT));
        }
    else
        {
        OldText = SetTextColor(lpdis->hDC,
                               GetSysColor(COLOR_WINDOWTEXT));
        OldBk   = SetBkColor(lpdis->hDC,
                             GetSysColor(COLOR_WINDOW));
        }

    if(strchr(lpsz, '='))
        *strchr(lpsz, '=')  = '\t';

    TabbedTextOut(lpdis->hDC, lpdis->rcItem.left+(lpbmp->bmWidth*2),
        lpdis->rcItem.top + 1, lpsz, lstrlen(lpsz),
        sizeof(aTabs) / sizeof(int), aTabs, (lpbmp->bmWidth*2));
    SetTextColor(lpdis->hDC, OldText);
    SetBkColor(lpdis->hDC, OldBk);
    GlobalFreePtr(lpsz);
    }

void DrawCheck(LPDRAWITEMSTRUCT lpdis, LPBITMAP lpbmp, HBITMAP hbmp)
    {
    HDC     hdcMem;
    HBITMAP hbmpSav;
    COLORREF    Color;
    HBRUSH  Old, New;
    LPARAM  Data        = lpdis->itemData;
    RECT    CheckRect   = lpdis->rcItem;
    int     IsCheck = FALSE;

    if(Data & LBF_RED)
        Color  = RGB(255,0,0);
    else if(Data & LBF_YELLOW)
        Color  = RGB(255,255,0);
    else if(Data & LBF_GREEN)
        Color  = RGB(0,255,0);
    else
        {
        Color   = GetSysColor(COLOR_WINDOW);
        IsCheck = TRUE;
        }
    New = CreateSolidBrush(Color);
    Old = SelectObject(lpdis->hDC, New);
    CheckRect.right = lpbmp->bmWidth * (IsCheck?2:1);
    FillRect(lpdis->hDC, &CheckRect, New);
    if(!IsCheck)
        FrameRect(lpdis->hDC, &CheckRect,
                  GetStockObject(BLACK_BRUSH));
    SelectObject(lpdis->hDC, Old);
    if (!(lpdis->itemData & LBF_CHECK))
        return; /* Nothing more to draw. */
    if ((hdcMem = CreateCompatibleDC(lpdis->hDC)) == NULL)
        return; /* Out of GDI memory. */
    if ((hbmpSav = (HBITMAP)SelectObject(hdcMem, hbmp)) != NULL)
        {
        BitBlt(lpdis->hDC,
          lpdis->rcItem.left + lpbmp->bmWidth / 2,
          ((lpdis->rcItem.bottom + lpdis->rcItem.top) -
            lpbmp->bmHeight) / 2, lpbmp->bmWidth,
          lpbmp->bmHeight, hdcMem, 0, 0, SRCCOPY);
        SelectObject(hdcMem, hbmpSav);
        }
    DeleteDC(hdcMem);
    }

