VERSION 2.00
Begin Form Test 
   Caption         =   "Toolbar Sample "
   ClientHeight    =   5820
   ClientLeft      =   2340
   ClientTop       =   1770
   ClientWidth     =   7365
   Height          =   6225
   Left            =   2280
   LinkTopic       =   "Form1"
   ScaleHeight     =   5820
   ScaleWidth      =   7365
   Top             =   1425
   Width           =   7485
   Begin PictureBox ToolBar 
      Align           =   1  'Align Top
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   450
      Left            =   0
      ScaleHeight     =   30
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   491
      TabIndex        =   0
      Top             =   0
      Width           =   7365
   End
   Begin Image ToolbarBitmaps 
      Height          =   225
      Left            =   240
      Picture         =   TEST.FRX:0000
      Top             =   720
      Visible         =   0   'False
      Width           =   2160
   End
End
Option Explicit

Const NUM_TOOLBAR_BUTTONS = 8

Const BUTTON_FILENEW = 1
Const BUTTON_FILEOPEN = 2
Const BUTTON_FILESAVE = 3
Const BUTTON_EDITCUT = 4
Const BUTTON_EDITCOPY = 5
Const BUTTON_EDITPASTE = 6
Const BUTTON_FILEPRINT = 7
Const BUTTON_HELPCONTEXT = 8

Sub Form_Load ()
    Dim x As Integer

    ' Initialize the toolbar
    Call ToolBarInit(Toolbar, ToolbarBitmaps, TOOLBUTTON_STDIMAGEWIDTH, TOOLBUTTON_STDIMAGEHEIGHT, NUM_TOOLBAR_BUTTONS, TOOLBUTTON_STDWIDTH, TOOLBUTTON_STDHEIGHT)
    
    ' Now setup the toolbar buttons
    x = TOOLBUTTON_STDSEPERATOR * 2
    Call ToolBarInitButton(BUTTON_FILENEW, x, TOOLIMAGE_FILENEW, False)
    x = x + TOOLBUTTON_STDWIDTH - 1
    Call ToolBarInitButton(BUTTON_FILEOPEN, x, TOOLIMAGE_FILEOPEN, False)
    x = x + TOOLBUTTON_STDWIDTH - 1
    Call ToolBarInitButton(BUTTON_FILESAVE, x, TOOLIMAGE_FILESAVE, False)
    
    x = x + TOOLBUTTON_STDWIDTH + TOOLBUTTON_STDSEPERATOR
    Call ToolBarInitButton(BUTTON_EDITCUT, x, TOOLIMAGE_EDITCUT, False)
    x = x + TOOLBUTTON_STDWIDTH - 1
    Call ToolBarInitButton(BUTTON_EDITCOPY, x, TOOLIMAGE_EDITCOPY, False)
    x = x + TOOLBUTTON_STDWIDTH - 1
    Call ToolBarInitButton(BUTTON_EDITPASTE, x, TOOLIMAGE_EDITPASTE, False)
    
    x = x + TOOLBUTTON_STDWIDTH + TOOLBUTTON_STDSEPERATOR
    Call ToolBarInitButton(BUTTON_FILEPRINT, x, TOOLIMAGE_FILEPRINT, False)
    
    x = x + TOOLBUTTON_STDWIDTH + TOOLBUTTON_STDSEPERATOR
    Call ToolBarInitButton(BUTTON_HELPCONTEXT, x, TOOLIMAGE_HELPCONTEXT, True)

    ' The Edit Paste button will be disabled
    Call ToolBarSetButtonState(BUTTON_EDITPASTE, COMMANDBUTTON_DISABLED)
End Sub

Sub ToolBar_MouseDown (Button As Integer, Shift As Integer, x As Single, Y As Single)
    Select Case ToolBarDepressButton()
        Case BUTTON_FILENEW
            MsgBox "File New Button Pressed"
        Case BUTTON_FILEOPEN
            MsgBox "File Open Button Pressed"
        Case BUTTON_FILESAVE
            MsgBox "File Save Button Pressed"
        Case BUTTON_EDITCUT
            Call ToolBarSetButtonState(BUTTON_EDITPASTE, COMMANDBUTTON_UP)
            MsgBox "Edit Cut Button Pressed"
        Case BUTTON_EDITCOPY
            Call ToolBarSetButtonState(BUTTON_EDITPASTE, COMMANDBUTTON_UP)
            MsgBox "Edit Copy Button Pressed"
        Case BUTTON_EDITPASTE
            MsgBox "Edit Paste Button Pressed"
        Case BUTTON_FILEPRINT
            MsgBox "File Print Button Pressed"
        Case BUTTON_HELPCONTEXT
            If ToolBarGetButtonState(BUTTON_HELPCONTEXT) = ATTRIBUTEBUTTON_UP Then
                MsgBox "Help Context is Off"
            End If
            If ToolBarGetButtonState(BUTTON_HELPCONTEXT) = ATTRIBUTEBUTTON_DOWN Then
                MsgBox "Help Context is On"
            End If
    End Select
End Sub

Sub ToolBar_Paint ()
    ToolBarPaint
End Sub

