// printer.h - define a class for dealing with printer selection

#ifndef PRINTER_H
#define PRINTER_H

#include <stdlib.h> // need size_t

#if !(defined(_INC_WINDOWS) || defined(__WINDOWS_H))
    #include <windows.h>
#endif

class   TPrinter
    {
public:
    // persistance via .ini file name not implemented yet!
    TPrinter(const char *IniFilename = 0);
    TPrinter(const TPrinter& Other);
    TPrinter& operator=(const TPrinter& Other);
   ~TPrinter();
    size_t  GetDriver(char *Buffer, size_t BufferSize);
    size_t  GetDevice(char *Buffer, size_t BufferSize);
    size_t  GetPort(char *Buffer, size_t BufferSize);
    int     SetupDialog(HWND ParentWindow);
    HDC     CreateDC();
private:
    void    Free();
    char   *IniFilename_;
    char   *Driver_;
    char   *Device_;
    char   *Port_;
    };

#endif // PRINTER_H

