   title vcall32
   page ,132

.386p

.xlist
   include vmm.inc
   include vwin32.inc
   include winerror.inc
; winerror.inc sets this to none, this conflicts with /Cx
option casemap:notpublic    
   include vw32svc.inc
.list

VCall32_Major   equ     1
VCall32_Minor   equ     0

VWIN32_DIOC equ 0002A001Fh

VxD_DATA_SEG
; Win32 DeviceIOControl dispatch table
align 4
ioctltbl    label   dword
   dd  offset32 ioctl_openclose
   dd  offset32 ioctl_openclose
   dd  offset32 ioctl_GetVersion
   dd  offset32 ioctl_GetVxDCall
ioctlcnt equ ($-ioctltbl)/4

vcall    dd 0   ; address of VxDCall PM Callback
diocprev dd 0   ; pointer to the previos DIOC handler
paramcnt dd 0   ; Win32 DIOC handler's DWORD parameter count
VxD_DATA_ENDS

Declare_Virtual_Device VCALL32, \
                       VCall32_Major, \
                       VCall32_Minor, \
                       VCall32_Control

VxD_LOCKED_CODE_SEG

VCall32_Control proc
Control_Dispatch SYS_DYNAMIC_DEVICE_INIT, VCall32_DynamicInit
Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT, VCall32_DynamicExit
Control_Dispatch W32_DEVICEIOCONTROL, VCall32_W32dioc
   clc
   ret
VCall32_Control endp

VCall32_DynamicInit proc
   cCall   _Get_Win32_Param_Count,<VWIN32_DIOC>
   mov     [paramcnt], eax
   ; hook DeviceIOCOntrol win32 service
   cCall   _Hook_Win32_Service,<VWIN32_DIOC,\
                               <offset32 Dioc_Handler>>
   mov     [diocprev], eax

   clc
   ret
VCall32_DynamicInit endp

VCall32_DynamicExit proc
   ; unhook w32 service
   cCall   _Unhook_Win32_Service,<VWIN32_DIOC,\
                                 <offset32 Dioc_Handler>>
   clc
   ret
VCall32_DynamicExit endp

VCall32_W32dioc proc uses esi edi ebx ebp
   ; get ioctl index
   ; increment it for CLOSEHANDLE to start the table
   mov   eax, [esi].dwIoControlCode
   inc   eax
   .IF eax >= ioctlcnt
      ; not supported service number
      mov   eax, ERROR_NOT_SUPPORTED
      stc
   .ELSE
      ; call through the ioctl branch table
      call    ioctltbl[eax*4]

      xor   eax, eax
      clc
   .ENDIF
   ret
VCall32_W32dioc  endp

; deviceIOcontrol services
ioctl_openclose proc
   ret    
ioctl_openclose endp

ioctl_GetVersion proc
   .IF [esi].cbOutBuffer >= 4
      mov     esi, [esi].lpvOutBuffer
      mov     dword ptr [esi],(VCall32_Major shl 8)+VCall32_Minor
   .ENDIF
   ret
ioctl_GetVersion endp

ioctl_GetVxDCall proc
   .IF [esi].cbOutBuffer >= 4
      mov     esi, [esi].lpvOutBuffer
      mov     eax, [vcall]
      mov     [esi], eax
   .ENDIF
   ret
ioctl_GetVxDCall endp

Dioc_Handler proc
   mov     eax, [esp+4]    ; pointer to CRS
   ; the Win32 service dispatcher has already adjusted
   ; the client stack - walk it backwards
   mov     eax, [eax].Client_ESP

   ; get the numnber if DeviceIOControl Win32 service parameters
   mov     edx, [paramcnt]
   ; add 1 DWORD for near return from VxDCall, 
   ; and 2 more for far return from [3b:xxxx] call
   add     edx, 3
   ; canver to a number of bytes
   shl     edx, 2

   ; land at the place where the call to PM callback was made
   sub     eax, edx
   ; get the VxDCall IP where PM callback would have returned
   ; if was not simulated
   mov     eax, [eax]
   ; get the pointer where PM callback is stored
   mov     eax, [eax-4]
   ; save it to return later to VCALL.DLL
   mov     [vcall], eax

   ; jump to the real Win32 service handler
   mov     edx, [diocprev]
   jmp     [edx]
Dioc_Handler endp

VxD_LOCKED_CODE_ENDS
   end
