#include <windows.h>

/* VCALL32 Device IO Control subfunctions */
typedef enum {
   VCALL_GETVERSION=1,
   VCALL_GETVCALL
}VCALL_DIOC;

#pragma pack(1)
/* FWORD PTR */
typedef struct {
   DWORD offs;
   WORD  sel;
}FWORD, *PFWORD;

FWORD cb;   /* PM API Callback */

BOOL WINAPI DllMain(HINSTANCE hDLLInst,
                    DWORD fdwReason,
                    LPVOID lpvReserved)
{
char *devname = "\\\\.\\VCALL32.VXD";
HANDLE hVxD;
DWORD out[1];                   // ioctl return values

   if (DLL_PROCESS_ATTACH == fdwReason)
   {
      hVxD = CreateFile(devname,0,0,NULL,0,
                        FILE_FLAG_DELETE_ON_CLOSE,NULL);

      if (INVALID_HANDLE_VALUE == hVxD)
         return (FALSE);
         
      DeviceIoControl (hVxD,VCALL_GETVCALL,NULL,0,out,sizeof(out),
                       NULL,NULL);
      cb.offs = ((PFWORD)out[0])->offs;
      cb.sel = ((PFWORD)out[0])->sel;
            
      CloseHandle (hVxD);
   }
   return TRUE;
}

_declspec(naked) void WINAPI VCall (DWORD svc)
{
   _asm {
      pop   eax            /* retrieve return address */
      xchg  eax, [esp]     /* exchange with Win32 service number */
      call  fword ptr [cb] /* call PM callback */
   }
}
