#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "security.h"

//------------------------------------------------------------------
VOID DumpWinStaSD(VOID)
{
    SECURITY_INFORMATION Sec =  OWNER_SECURITY_INFORMATION | 
                                GROUP_SECURITY_INFORMATION | 
                                DACL_SECURITY_INFORMATION;
    DWORD   Size = 0;
    HWINSTA hWinSta = NULL;
    char    szName[MAX_PATH];
    PSECURITY_DESCRIPTOR pSD = malloc(SD_BUF);

    hWinSta = GetProcessWindowStation();
    if (hWinSta) {
        if (GetUserObjectInformation(hWinSta, UOI_NAME, szName, 
                                   MAX_PATH * sizeof(char), &Size)) {
            Dbg1("\nDUMP WINDOW STATION SD: %s\n", szName); 
        }     
        if(GetUserObjectSecurity(hWinSta, &Sec, pSD, SD_BUF, &Size)){
            DumpSD(pSD, WDJSRVC_WINSTA);
        }
        CloseHandle(hWinSta); 
    }
    if (pSD) free(pSD);

} // DumpWinStaSD 

//------------------------------------------------------------------
VOID DumpDesktopSD(VOID)
{
    SECURITY_INFORMATION Sec =  OWNER_SECURITY_INFORMATION | 
                                GROUP_SECURITY_INFORMATION | 
                                DACL_SECURITY_INFORMATION;
    DWORD   Size = 0;
    HDESK   hDesktop = NULL;
    char    szName[MAX_PATH];
    PSECURITY_DESCRIPTOR pSD = malloc(SD_BUF);

    hDesktop = GetThreadDesktop(GetCurrentThreadId());
    if (hDesktop) {    
        if (GetUserObjectInformation(hDesktop, UOI_NAME, szName, 
                                 MAX_PATH * sizeof(char), &Size)) {
            Dbg1("\nDUMP DESKTOP SD: %s\n", szName); 
        }
        if(GetUserObjectSecurity(hDesktop, &Sec,pSD,SD_BUF,&Size)){
            DumpSD(pSD, WDJSRVC_DESKTOP);
        } 
        CloseHandle(hDesktop); 
    }
    if (pSD) free(pSD);

} // DumpDesktopSD 

//------------------------------------------------------------------
VOID DumpSD(PSECURITY_DESCRIPTOR pSD, DWORD ObjectType)
{
    PSID sid = NULL;
    PACL dacl = NULL;
    BOOL bDefault, bPresent;

    if (!IsValidSecurityDescriptor(pSD)) {
        return;
    }

    if (GetSecurityDescriptorOwner(pSD, &sid, &bDefault)) {
        Dbg("-> Owner: ");
        if (bDefault) {
           Dbg("(SE_OWNER_DEFAULTED) ");
        }
        if (sid) { 
            DumpSid(sid, 0);
        }
    }

     if (GetSecurityDescriptorGroup(pSD, &sid, &bDefault)) {
        Dbg("-> Primary Group: ");
        if (bDefault) {
           Dbg("(SE_OWNER_DEFAULTED) ");
        }
        if (sid) { 
            DumpSid(sid, 0);
        } 
    }

    if (GetSecurityDescriptorDacl(pSD, &bPresent, &dacl, &bDefault)) {

        Dbg("-> Discretionary Access Control List: \n");
        if (bPresent) {
            if (bDefault) {
                Dbg("   SE_OWNER_DEFAULTED flag is set\n");
            }
            DumpAcl(dacl, ObjectType);
        }
    }
    return;

} // DumpSD

VOID DumpSid(PSID Sid, DWORD Attributes)
{
    SID_NAME_USE Use;
    char szAccount[MAX_PATH], szDomain[MAX_PATH];
    ULONG size1 = MAX_PATH, size2 = MAX_PATH;

    if (LookupAccountSid(NULL, Sid, szAccount, &size1, szDomain,
                         &size2, &Use)) {        
        Dbg1("%s\\", szDomain);
        Dbg1("%s, ", szAccount);
        Dbg1("Attributes: %x\n", Attributes);
    } else {
        Dbg("Unknown\n");
    }
        
} // DumpSid

VOID DumpAcl(PACL Acl, DWORD ObjectType)
{
    PACCESS_ALLOWED_ACE ace;
    ULONG i;

    //
    // Dump info for each ace in the acl
    //
    for (i=0; i < Acl->AceCount; i++) {
        if (GetAce(Acl, i, (LPVOID *)&ace)) {
            if (ace->Header.AceType == ACCESS_ALLOWED_ACE_TYPE) {
                Dbg("   Access ALLOWED: ");
            }else if(ace->Header.AceType == ACCESS_DENIED_ACE_TYPE){
                Dbg("   Access DENIED: ");
            } else {
                Dbg("   Audit ace: ");
            }
            DumpSid((PSID)&(ace->SidStart), 0);
            DumpAccessMask(ace->Mask, ObjectType);
        }
    }

    return;

} // DumpAcl

VOID DumpAccessMask(ACCESS_MASK Mask, DWORD ObjectType)
{
    DWORD Specific = 0;

    Dbg("   Access: ");
    
    // Bits 16 - 23 (16-20 currently defined): Standard rights
    if (Mask & DELETE) Dbg("DELETE ");
    if (Mask & READ_CONTROL) Dbg("READ_CONTROL ");
    if (Mask & WRITE_DAC) Dbg("WRITE_DAC ");
    if (Mask & WRITE_OWNER) Dbg("WRITE_OWNER ");
    if (Mask & SYNCHRONIZE) Dbg("SYNCHRONIZE ");

    // Bit 24: Access system security
    if (Mask & ACCESS_SYSTEM_SECURITY) Dbg("ACCESS_SYSTEM_SECURITY ");

    // Bit 25: Maximum allowed
    if (Mask & MAXIMUM_ALLOWED) Dbg("MAXIMUM_ALLOWED ");

    // Bits 26 - 27: Reserved

    // Bits 28 - 31: Generic Rights
    if (Mask & GENERIC_ALL) Dbg("ENERIC_ALL ");
    if (Mask & GENERIC_EXECUTE) Dbg(",GENERIC_EXECUTE ");
    if (Mask & GENERIC_WRITE) Dbg("GENERIC_WRITE ");
    if (Mask & GENERIC_READ) Dbg("GENERIC_READ ");

    // Bits 0 - 15: Specific Rights
    Specific = Mask & SPECIFIC_RIGHTS_ALL;
    Dbg1("\n   Specific(%x)", Specific);

    if (ObjectType == WDJSRVC_WINSTA) {
        if(Specific & WINSTA_ENUMDESKTOPS) Dbg(",ENUMDESKTOPS");
        if(Specific & WINSTA_READATTRIBUTES) Dbg(",READATTRIBUTES");
        if(Specific & WINSTA_ACCESSCLIPBOARD)
            Dbg(",ACCESSCLIPBOARD");
        if(Specific & WINSTA_CREATEDESKTOP) Dbg(",CREATEDESKTOP");
        if(Specific & WINSTA_WRITEATTRIBUTES)
            Dbg(",WRITEATTRIBUTES");
        if(Specific & WINSTA_ACCESSGLOBALATOMS)
            Dbg(",ACCESSGLOBALATOMS");
        if(Specific & WINSTA_EXITWINDOWS) Dbg(",EXITWINDOWS");
        if(Specific & WINSTA_ENUMERATE) Dbg(",ENUMERATE");
        if(Specific & WINSTA_READSCREEN) Dbg(",READSCREEN");
    }

    if (ObjectType == WDJSRVC_DESKTOP) {
        if(Specific & DESKTOP_READOBJECTS) Dbg(",READOBJECTS");
        if(Specific & DESKTOP_CREATEWINDOW) Dbg(",CREATEWINDOW");
        if(Specific & DESKTOP_CREATEMENU) Dbg(",CREATEMENU");
        if(Specific & DESKTOP_HOOKCONTROL) Dbg(",HOOKCONTROL");
        if(Specific & DESKTOP_JOURNALRECORD) Dbg(",JOURNALRECORD");
        if(Specific & DESKTOP_JOURNALPLAYBACK)
            Dbg(",JOURNALPLAYBACK");
        if(Specific & DESKTOP_ENUMERATE) Dbg(",ENUMERATE");
        if(Specific & DESKTOP_WRITEOBJECTS) Dbg(",WRITEOBJECTS");
        if(Specific & DESKTOP_SWITCHDESKTOP) Dbg(",SWITCHDESKTOP");
    }
    Dbg("\n");

} // DumpAccessMask
