#include <malloc.h>
#if defined(__WATCOMC__)
#   define _heapmin _heapshrink
#endif

#include <assert.h>
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#define BIGALLOC    (16)     // in Mb

LPVOID  GetMb(int n)    {
    return VirtualAlloc(0, n*1024L*1024L, MEM_RESERVE,
        PAGE_READWRITE);
    }
void    FreeMb(LPVOID P)
    {  assert(VirtualFree(P, 0, MEM_RELEASE) != FALSE);  }

// figure out how much memory is available
int     AvailableMb()
    {
    static LPVOID   Ptrs[4096]; // I bet there isn't 4Gb
    memset(Ptrs, 0, sizeof(Ptrs));

    int i;
    for(i = 0; i < 4096; ++i)
        {
        Ptrs[i] = GetMb(1);
        if(Ptrs[i] == 0)
            break;
        }
    assert(i < 4096);
    int Result  = i;

    for(i = 0; Ptrs[i]; ++i)
        FreeMb(Ptrs[i]);
    return Result;
    }

class MemChunk
    {
public:
    MemChunk(int Size);
    static void FreeAll();
private:
   ~MemChunk() { if(Chunk) delete[] Chunk; }
    class MemChunk*     Next;
    char*               Chunk;
    static MemChunk*    List;
    };
MemChunk* MemChunk::List = 0;
MemChunk::MemChunk(int Size)
    {
    Chunk   = new char[Size];
    assert(Chunk != 0);
    Next    = List;
    List    = this;
    }
void MemChunk::FreeAll()
    {
    MemChunk* Rover = List;
    while(Rover)
        {
        Rover   = List->Next;
        delete List;
        List    = Rover;
        }
    }

void    main()
    {
    int     StartAmount = AvailableMb();
    printf("Starting memory test (%dMb available).\n",
        StartAmount);
    int     CurrentAmount = StartAmount;

    // now use up at least BIGALLOC Mb of memory
    while(CurrentAmount > (StartAmount - BIGALLOC))
        {
        for(int i = 0; i < 1024; ++i)
            new MemChunk(1 + rand()%512);
        CurrentAmount   = AvailableMb();
        }
    printf("After allocating memory, there is %dMb available\n",
        CurrentAmount);
    MemChunk::FreeAll();
    CurrentAmount   = AvailableMb();
    printf("After freeing memory, there is %dMb available\n",
        CurrentAmount);
    _heapmin();
    CurrentAmount   = AvailableMb();
    printf("After calling _heapmin(), there is %dMb available\n",
        CurrentAmount);
    }

